/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.desc;

import java.io.File;
import javax.swing.JPanel;
import org.cristalise.gui.graph.view.VertexPropertyPanel;
import org.cristalise.gui.tabs.outcome.InvalidOutcomeException;
import org.cristalise.gui.tabs.outcome.InvalidSchemaException;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.gui.tabs.outcome.OutcomeNotInitialisedException;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElemActDefOutcomeHandler
extends VertexPropertyPanel
implements OutcomeHandler {
    private static final Logger log = LoggerFactory.getLogger(ElemActDefOutcomeHandler.class);
    ActivityDef act;
    boolean unsaved;

    public ElemActDefOutcomeHandler() {
        super(true);
        this.createLayout(null);
    }

    @Override
    public void setOutcome(String outcome) throws InvalidOutcomeException {
        try {
            this.act = (ActivityDef)Gateway.getMarshaller().unmarshall(outcome);
            this.setVertex((Vertex)this.act);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            throw new InvalidOutcomeException();
        }
    }

    @Override
    public void setDescription(String description) throws InvalidSchemaException {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEditable(!readOnly);
    }

    @Override
    public JPanel getPanel() throws OutcomeNotInitialisedException {
        return this;
    }

    @Override
    public String getOutcome() throws OutcomeException {
        try {
            return Gateway.getMarshaller().marshall((Object)this.act);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            throw new OutcomeException();
        }
    }

    @Override
    public void run() {
        this.revalidate();
        this.doLayout();
    }

    @Override
    public boolean isUnsaved() {
        return this.unsaved;
    }

    @Override
    public void saved() {
        this.unsaved = false;
    }

    @Override
    public void export(File targetFile) throws Exception {
        FileStringUtility.string2File((File)targetFile, (String)this.getOutcome());
    }
}

