/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import io.vertx.core.Vertx;
import java.util.StringTokenizer;
import javax.swing.JTabbedPane;
import org.cristalise.gui.ItemDetails;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.collection.AggregationView;
import org.cristalise.gui.tabs.collection.CollectionView;
import org.cristalise.gui.tabs.collection.DependencyView;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionPane
extends ItemTabPane {
    private static final Logger log = LoggerFactory.getLogger(CollectionPane.class);
    JTabbedPane collTabs;

    public CollectionPane() {
        super("Collection", "Item Collection");
        this.createLayout();
    }

    @Override
    public void setParent(ItemDetails parent) {
        super.setParent(parent);
        Vertx vertx = Gateway.getVertx();
        vertx.eventBus().localConsumer(parent.getItemPath().getUUID() + "/" + ClusterType.COLLECTION, message -> {
            String[] tokens = ((String)message.body()).split(":");
            String collPath = tokens[0];
            if (tokens[1].equals("DELETE")) {
                return;
            }
            vertx.executeBlocking(promise -> {
                try {
                    int idx = collPath.lastIndexOf("/");
                    String collName = collPath.substring(0, idx);
                    if (collPath.endsWith("/last")) {
                        this.add((Collection<? extends CollectionMember>)this.sourceItem.getItem().getCollection(collName));
                    } else {
                        Integer version = new Integer(collPath.substring(idx + 1));
                        this.add((Collection<? extends CollectionMember>)this.sourceItem.getItem().getCollection(collName, version));
                    }
                }
                catch (ObjectNotFoundException e) {
                    log.error("", (Throwable)e);
                }
                promise.complete();
            }, res -> {});
        });
    }

    public void add(Collection<? extends CollectionMember> contents) {
        log.debug("Got " + contents.getName() + ": " + contents.getClass().getName());
        log.debug("Looking for existing " + contents.getName());
        CollectionView thisCollView = this.findTabForCollName(contents.getName());
        if (contents instanceof Aggregation) {
            AggregationView thisAggView;
            if (thisCollView == null) {
                thisAggView = new AggregationView();
                thisAggView.setItem(this.sourceItem.getItem());
                thisCollView = thisAggView;
            } else {
                thisAggView = (AggregationView)thisCollView;
            }
            thisAggView.setCollection((Collection<AggregationMember>)((Aggregation)contents));
        } else if (contents instanceof Dependency) {
            DependencyView thisDepView;
            if (thisCollView == null) {
                thisDepView = new DependencyView();
                thisDepView.setItem(this.sourceItem.getItem());
                thisCollView = thisDepView;
            } else {
                thisDepView = (DependencyView)thisCollView;
            }
            thisDepView.setCollection((Collection<DependencyMember>)((Dependency)contents));
        } else {
            log.error("Collection type " + contents.getClass().getName() + " not known");
            return;
        }
        log.info("Adding new " + thisCollView.getClass().getName());
        this.collTabs.add(contents.getName() + (contents instanceof CollectionDescription ? "*" : ""), thisCollView);
    }

    private CollectionView<? extends CollectionMember> findTabForCollName(String collName) {
        CollectionView thisCollView = null;
        for (int i = 0; i < this.collTabs.getTabCount(); ++i) {
            thisCollView = (CollectionView)this.collTabs.getComponentAt(i);
            if (thisCollView.getCollection() == null || !collName.equals(thisCollView.getCollection().getName())) continue;
            return thisCollView;
        }
        return null;
    }

    protected void createLayout() {
        this.initPanel();
        this.collTabs = new JTabbedPane();
        this.add(this.collTabs);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Collection Loader");
        try {
            String collNames = this.sourceItem.getItem().queryData(ClusterType.COLLECTION + "/all");
            StringTokenizer tok = new StringTokenizer(collNames, ",");
            while (tok.hasMoreTokens()) {
                this.add((Collection<? extends CollectionMember>)this.sourceItem.getItem().getCollection(tok.nextToken()));
            }
        }
        catch (Exception e) {
            log.error("Error loading collections", (Throwable)e);
        }
    }

    @Override
    public void reload() {
        Gateway.getStorage().clearCache(this.sourceItem.getItemPath(), ClusterType.COLLECTION.getName());
        this.collTabs.removeAll();
        this.initForItem(this.sourceItem);
    }
}

