/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemDetails;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.gui.tabs.outcome.form.OutcomePanel;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTabPane
extends JPanel
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ItemTabPane.class);
    protected NodeItem sourceItem;
    protected String titleText = null;
    protected ImageIcon titleIcon = null;
    private final String tabName;
    public static Font titleFont = null;
    public static Color headingColor = new Color(0, 0, 185);
    protected ItemDetails parent;
    protected static ImageIcon mReloadIcon = null;
    protected Box titleBox;

    public void focusLost(FocusEvent e) {
    }

    public ItemTabPane(String tabName, String titleText) {
        this.tabName = tabName;
        String string = this.titleText = titleText == null ? null : titleText;
        if (titleFont == null) {
            titleFont = new Font("SansSerif", 1, this.getFont().getSize() + 5);
        }
        log.debug("ItemTabPane.<init> - viewing " + tabName);
        this.setLayout(new BoxLayout(this, 1));
    }

    public void setParent(ItemDetails parent) {
        this.parent = parent;
    }

    public String getTabName() {
        return this.tabName;
    }

    protected JLabel getTitle(String titleText) {
        if (this.titleIcon == null) {
            this.titleIcon = ImageLoader.findImage("info_16.png");
        }
        JLabel title = new JLabel(titleText, this.titleIcon, 2);
        title.setFont(titleFont);
        title.setForeground(headingColor);
        return title;
    }

    protected void addTitle(JLabel title) {
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(title);
        labelBox.add(Box.createHorizontalGlue());
        this.add(labelBox);
    }

    protected void addGlue() {
        this.add(Box.createVerticalGlue());
    }

    protected void initPanel() {
        if (this.titleText == null) {
            this.titleText = this.tabName;
        }
        JLabel title = this.getTitle(this.titleText);
        JButton refreshButton = new JButton(mReloadIcon);
        refreshButton.setToolTipText("Refresh");
        refreshButton.setMargin(new Insets(0, 0, 0, 0));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemTabPane.this.setCursor(new Cursor(3));
                ItemTabPane.this.reload();
                ItemTabPane.this.setCursor(new Cursor(0));
            }
        });
        String defaultStartTab = MainFrame.getPref("DefaultStartTab", "Properties");
        JToggleButton defaultStart = new JToggleButton(ImageLoader.findImage("graph/start.png"));
        defaultStart.setMargin(new Insets(0, 0, 0, 0));
        defaultStart.setToolTipText("Select this tab to be the default one opened when you double click an item");
        defaultStart.setSelected(this.tabName.equals(defaultStartTab));
        defaultStart.setActionCommand(this.tabName);
        defaultStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JToggleButton)e.getSource()).isSelected()) {
                    MainFrame.setPref("DefaultStartTab", e.getActionCommand());
                }
            }
        });
        this.titleBox = Box.createHorizontalBox();
        this.titleBox.add(title);
        this.titleBox.add(Box.createHorizontalGlue());
        this.titleBox.add(defaultStart);
        this.titleBox.add(refreshButton);
        this.add(this.titleBox);
        this.add(Box.createVerticalStrut(5));
    }

    public void initForItem(NodeItem sourceItem) {
        this.sourceItem = sourceItem;
        new Thread(this).start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Default Entity Pane Builder");
        JLabel error = new JLabel("In Development");
        this.add(error);
    }

    public void reload() {
    }

    public void runCommand(String command) {
    }

    public void destroy() {
        this.parent = null;
    }

    public static OutcomeHandler getOutcomeHandler(String schema, int version) {
        String propName = "OutcomeHandler." + schema + "." + version;
        if (Gateway.getProperties().containsKey((Object)propName)) {
            try {
                return (OutcomeHandler)Gateway.getProperties().getInstance(propName);
            }
            catch (Exception ex) {
                log.error("Error creating handler " + Gateway.getProperties().getString(propName) + ". using default outcome editor");
            }
        }
        propName = "OutcomeHandler.*";
        if (Gateway.getProperties().containsKey((Object)propName)) {
            try {
                return (OutcomeHandler)Gateway.getProperties().getInstance(propName);
            }
            catch (Exception ex) {
                log.error("Error creating handler " + Gateway.getProperties().getString(propName) + ". using default outcome editor");
            }
        }
        return new OutcomePanel();
    }

    static {
        try {
            mReloadIcon = ImageLoader.findImage("refresh.png");
        }
        catch (Exception e) {
            log.warn("Couldn't load images: " + e);
        }
    }
}

