/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import io.vertx.core.Vertx;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.ItemDetails;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.persistency.C2KLocalObjectMap;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobListPane
extends ItemTabPane {
    private static final Logger log = LoggerFactory.getLogger(JobListPane.class);
    C2KLocalObjectMap<Job> joblist;
    JoblistTableModel model;
    JTable eventTable;

    public JobListPane() {
        super("Job List", "Job List");
        this.initPanel();
        this.add(Box.createVerticalStrut(5));
        this.eventTable = new JTable();
        JScrollPane eventScroll = new JScrollPane(this.eventTable);
        this.add(eventScroll);
    }

    @Override
    public void setParent(ItemDetails parent) {
        super.setParent(parent);
        Vertx vertx = Gateway.getVertx();
        vertx.eventBus().localConsumer(parent.getItemPath().getUUID() + "/" + ClusterType.JOB, message -> vertx.executeBlocking(promise -> {
            this.reload();
            promise.complete();
        }, result -> {
            if (result.failed()) {
                log.warn("", result.cause());
            }
        }));
    }

    @Override
    public void reload() {
        Gateway.getStorage().clearCache(this.parent.getItemPath(), ClusterType.JOB);
        if (this.model != null) {
            this.model.setView();
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Joblist Pane Builder");
        this.joblist = this.sourceItem.getItem().getJobs();
        this.model = new JoblistTableModel();
        this.eventTable.setModel(this.model);
        this.model.setView();
    }

    private class JoblistTableModel
    extends AbstractTableModel {
        Job[] jobArray;

        private JoblistTableModel() {
        }

        public void setView() {
            this.jobArray = JobListPane.this.joblist.values().toArray(new Job[0]);
            log.debug("JoblistTableModel.setView() - jobArray.length:{}", (Object)this.jobArray.length);
            this.fireTableStructureChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Activity";
                }
                case 1: {
                    return "Transition";
                }
                case 2: {
                    return "Schema";
                }
                case 3: {
                    return "Script";
                }
                case 4: {
                    return "StateMachine";
                }
                case 5: {
                    return "RoleOverride";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.jobArray != null ? this.jobArray.length : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.jobArray.length <= rowIndex || this.jobArray[rowIndex] == null) {
                log.warn("JoblistTableModel.getValueAt() - INVALID rowIndex:{}", (Object)rowIndex);
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.jobArray[rowIndex].getStepName();
                    }
                    case 1: {
                        return this.jobArray[rowIndex].getTransitionName();
                    }
                    case 2: {
                        return this.jobArray[rowIndex].getSchema() != null ? this.jobArray[rowIndex].getSchemaName() : "";
                    }
                    case 3: {
                        return this.jobArray[rowIndex].getScript() != null ? this.jobArray[rowIndex].getScriptName() : "";
                    }
                    case 4: {
                        return this.jobArray[rowIndex].getStateMachine() != null ? this.jobArray[rowIndex].getStateMachine().name : "";
                    }
                    case 5: {
                        return this.jobArray[rowIndex].getRoleOverride();
                    }
                }
                return "";
            }
            catch (Exception e) {
                log.warn("JoblistTableModel.getValueAt() - rowIndex:{} columnIndex:{}", new Object[]{rowIndex, columnIndex, e});
                return "";
            }
        }
    }
}

