/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.collection;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.view.PropertyTable;
import org.cristalise.gui.graph.view.PropertyTableModel;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;

public class CollectionMemberPropertyPanel
extends JPanel
implements ActionListener {
    private final PropertyTableModel mPropertyModel;
    private final PropertyTable mPropertyTable;
    private boolean isEditable = false;
    CollectionMember selectedCollMem;
    GridBagLayout gridbag = new GridBagLayout();
    protected JLabel selObjSlot;
    protected JLabel selObjMember;
    JButton addPropButton;
    JButton delPropButton;
    Box newPropBox;
    private JTextField newPropName;
    private JComboBox<String> newPropType;
    String[] typeOptions = new String[]{"String", "Boolean", "Integer", "Float"};
    String[] typeInitVal = new String[]{"", "false", "0", "0.0"};

    public CollectionMemberPropertyPanel() {
        this.setLayout(this.gridbag);
        this.mPropertyModel = new PropertyTableModel(false);
        this.mPropertyTable = new PropertyTable(this.mPropertyModel);
        this.createLayout();
    }

    public void setMember(CollectionMember cm) {
        String newMemberName;
        this.selectedCollMem = cm;
        try {
            ItemPath path = cm.getItemPath();
            newMemberName = path == null ? "No member" : Gateway.getProxy((Path)path).getProperty("Name");
        }
        catch (ObjectNotFoundException e) {
            newMemberName = "Item or Item name property not found";
        }
        this.selObjSlot.setText(newMemberName);
        this.selObjMember.setText("Slot " + cm.getID());
        this.mPropertyModel.setMap(cm.getProperties());
        this.addPropButton.setEnabled(this.isEditable);
        this.delPropButton.setEnabled(this.isEditable);
    }

    public void createLayout() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.ipadx = 5;
        c.ipady = 5;
        this.selObjSlot = new JLabel();
        this.selObjSlot.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(this.selObjSlot, c);
        this.add(this.selObjSlot);
        ++c.gridy;
        this.selObjMember = new JLabel();
        this.gridbag.setConstraints(this.selObjMember, c);
        this.add(this.selObjMember);
        ++c.gridy;
        JLabel title = new JLabel("Properties");
        title.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(title, c);
        this.add(title);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 2.0;
        JScrollPane scroll = new JScrollPane(this.mPropertyTable);
        this.gridbag.setConstraints(scroll, c);
        this.add(scroll);
        this.newPropBox = Box.createHorizontalBox();
        this.newPropBox.add(new JLabel("New :"));
        this.newPropBox.add(Box.createHorizontalGlue());
        this.newPropName = new JTextField(15);
        this.newPropBox.add(this.newPropName);
        this.newPropType = new JComboBox<String>(this.typeOptions);
        this.newPropBox.add(this.newPropType);
        this.newPropBox.add(Box.createHorizontalStrut(1));
        this.addPropButton = new JButton("Add");
        this.addPropButton.setMargin(new Insets(0, 0, 0, 0));
        this.delPropButton = new JButton("Del");
        this.delPropButton.setMargin(new Insets(0, 0, 0, 0));
        this.addPropButton.addActionListener(this);
        this.delPropButton.addActionListener(this);
        this.newPropBox.add(this.addPropButton);
        this.newPropBox.add(this.delPropButton);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.gridbag.setConstraints(this.newPropBox, c);
        this.add(this.newPropBox);
    }

    public void clear() {
        this.selObjSlot.setText("");
        this.selObjMember.setText("Nothing Selected");
        this.mPropertyModel.setMap(new CastorHashMap());
        this.addPropButton.setEnabled(false);
        this.delPropButton.setEnabled(false);
    }

    public void setEditable(boolean editable) {
        this.mPropertyModel.setEditable(editable);
        this.isEditable = editable;
        this.newPropBox.setVisible(editable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addPropButton) {
            if (this.newPropName.getText().length() < 1) {
                JOptionPane.showMessageDialog(this, "Enter a name for the new property", "Cannot add property", 0);
                return;
            }
            if (this.mPropertyModel.sourceMap.containsKey((Object)this.newPropName.getText())) {
                JOptionPane.showMessageDialog(this, "Property '" + this.newPropName.getText() + "' already exists.", "Cannot add property", 0);
                return;
            }
            if (this.mPropertyTable.getCellEditor() != null) {
                this.mPropertyTable.getCellEditor().stopCellEditing();
            }
            try {
                Class<?> newPropClass = Class.forName("java.lang." + this.typeOptions[this.newPropType.getSelectedIndex()]);
                Class[] params = new Class[]{String.class};
                Constructor<?> init = newPropClass.getConstructor(params);
                Object[] initParams = new Object[]{this.typeInitVal[this.newPropType.getSelectedIndex()]};
                this.mPropertyModel.addProperty(this.newPropName.getText(), init.newInstance(initParams), false);
            }
            catch (Exception ex) {
                MainFrame.exceptionDialog(ex);
            }
        } else if (e.getSource() == this.delPropButton) {
            int selrow = this.mPropertyTable.getSelectedRow();
            if (selrow == -1) {
                JOptionPane.showMessageDialog(this, "Select a property to remove", "Cannot delete property", 0);
                return;
            }
            this.mPropertyModel.delProperty(this.mPropertyModel.sortedNameList.get(selrow));
        }
    }
}

