/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.AttributeList;
import org.cristalise.gui.tabs.outcome.form.CardinalException;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.gui.tabs.outcome.form.field.EditField;
import org.exolab.castor.xml.schema.ElementDecl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Field
extends OutcomeStructure {
    private static final Logger log = LoggerFactory.getLogger(Field.class);
    EditField myElementPanel = null;
    AttributeList myAttributes;
    JLabel tagName;
    Text textNode;
    boolean fixed;
    public static final JPanel nullPanel = new JPanel();

    public Field(ElementDecl model, boolean readOnly, HashMap<String, Class<?>> specialEditFields) {
        super(model, readOnly, specialEditFields);
        try {
            this.myElementPanel = EditField.getEditField(model, specialEditFields);
            log.debug("Field type: " + this.myElementPanel.getClass().getName());
            if (readOnly) {
                this.myElementPanel.setEditable(false);
            }
        }
        catch (StructuralException e) {
            this.myElementPanel = null;
        }
        this.myAttributes = new AttributeList(model, readOnly);
        this.tagName = Field.makeLabel(model.getName(), this.help);
        this.setupPanel();
    }

    private void setupPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints position = new GridBagConstraints();
        position.anchor = 18;
        position.ipadx = 5;
        position.ipady = 5;
        position.insets = new Insets(5, 5, 0, 0);
        position.gridwidth = 1;
        position.gridy = 0;
        position.gridx = 0;
        position.weightx = 2.0;
        position.weighty = 0.0;
        position.fill = 0;
        gridbag.setConstraints(this.getLabel(), position);
        this.add(this.getLabel());
        ++position.gridy;
        position.weighty = 1.0;
        position.fill = 2;
        gridbag.setConstraints(this.getCData(), position);
        this.add(this.getCData());
        ++position.gridx;
        --position.gridy;
        position.gridheight = 2;
        position.weightx = 0.0;
        position.fill = 0;
        gridbag.setConstraints(this.getAttributes(), position);
        this.add(this.getAttributes());
        position.gridx = 0;
        position.gridheight = 1;
        ++position.gridy;
    }

    public JComponent getLabel() {
        return this.tagName;
    }

    public Component getCData() {
        if (this.myElementPanel == null) {
            return nullPanel;
        }
        return this.myElementPanel.getControl();
    }

    public JComponent getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void addStructure(OutcomeStructure newElement) throws StructuralException {
        throw new StructuralException("Field " + this.model.getName() + " cannot have child structures");
    }

    @Override
    public void addInstance(Element myElement, Document parentDoc) throws OutcomeException {
        log.debug("Accepting Field " + myElement.getTagName());
        if (this.myElement != null) {
            throw new CardinalException("Field " + this.getName() + " cannot repeat");
        }
        this.myElement = myElement;
        try {
            if (this.myElementPanel == null) {
                log.error("Field should be empty. Discarding contents.");
            } else {
                if (myElement.hasChildNodes()) {
                    this.textNode = (Text)myElement.getFirstChild();
                } else {
                    this.textNode = parentDoc.createTextNode(this.getDefaultValue());
                    myElement.appendChild(this.textNode);
                }
                this.myElementPanel.setData(this.textNode);
            }
        }
        catch (ClassCastException ex) {
            throw new StructuralException("First child node of Field " + this.getName() + " was not Text: " + myElement.getFirstChild().getNodeType());
        }
        this.myAttributes.setInstance(myElement);
    }

    @Override
    public String validateStructure() {
        this.myAttributes.validateAttributes();
        if (this.myElementPanel != null) {
            this.myElementPanel.updateNode();
        }
        Text contents = (Text)this.myElement.getFirstChild();
        if (!(this.myElement.hasAttributes() || this.model.getMinOccurs() >= 1 || contents != null && contents.getData().length() != 0)) {
            this.myElement.getParentNode().removeChild(this.myElement);
        }
        return null;
    }

    @Override
    public Element initNew(Document parent) {
        log.debug("Creating Field " + this.getName());
        this.myElement = parent.createElement(this.getName());
        if (this.myElementPanel != null) {
            String defaultVal = this.readOnly ? "" : this.getDefaultValue();
            this.textNode = parent.createTextNode(defaultVal);
            this.myElement.appendChild(this.textNode);
            this.myElementPanel.setData(this.textNode);
        }
        this.myAttributes.initNew(this.myElement);
        return this.myElement;
    }

    private String getDefaultValue() {
        String defaultValue = this.model.getFixedValue();
        if (defaultValue == null) {
            defaultValue = this.model.getDefaultValue();
        }
        if (defaultValue == null) {
            defaultValue = this.myElementPanel.getDefaultValue();
        }
        return defaultValue;
    }

    @Override
    public void grabFocus() {
        if (this.myElementPanel != null) {
            this.myElementPanel.grabFocus();
        } else {
            this.myAttributes.grabFocus();
        }
    }
}

