/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.DataRecord;
import org.cristalise.gui.tabs.outcome.form.Dimension;
import org.cristalise.gui.tabs.outcome.form.Field;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class OutcomeStructure
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(OutcomeStructure.class);
    ElementDecl model;
    Element myElement = null;
    HashMap<String, Class<?>> specialEditFields;
    boolean readOnly;
    HashMap<String, OutcomeStructure> subStructure = new HashMap();
    ArrayList<String> order = new ArrayList();
    public static ImageIcon helpIconSmall = ImageLoader.findImage("query_16.png");
    String help = null;
    boolean deferChild = false;

    public OutcomeStructure(ElementDecl model, boolean readOnly, HashMap<String, Class<?>> specialControls) {
        this.model = model;
        this.readOnly = readOnly;
        this.specialEditFields = specialControls;
        this.subStructure = new HashMap();
        String doc = OutcomeStructure.extractHelp((Annotated)model);
        if (doc.length() > 0) {
            this.help = doc;
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public OutcomeStructure createStructure(ElementDecl model, boolean readOnly) throws OutcomeException {
        ComplexType elementComplexType;
        XMLType elementType = model.getType();
        if (model.getMaxOccurs() == 0) {
            return null;
        }
        if (model.getMaxOccurs() > 1 || model.getMaxOccurs() == Particle.UNBOUNDED || model.getMinOccurs() == 0) {
            return new Dimension(model, readOnly, this.specialEditFields);
        }
        if (elementType == null) {
            throw new StructuralException("Element " + model.getName() + " is elementary yet has no type.");
        }
        if (elementType instanceof SimpleType) {
            return new Field(model, readOnly, this.specialEditFields);
        }
        try {
            elementComplexType = (ComplexType)elementType;
        }
        catch (ClassCastException e) {
            throw new StructuralException("Unknown XMLType for element " + model.getName());
        }
        if (elementComplexType.getParticleCount() == 0) {
            return new Field(model, readOnly, this.specialEditFields);
        }
        return new DataRecord(model, readOnly, this.deferChild, this.specialEditFields);
    }

    public void enumerateElements(ContentModelGroup group) throws OutcomeException {
        XMLType base;
        if (group instanceof ComplexType && (base = ((ComplexType)group).getBaseType()) instanceof ComplexType) {
            this.enumerateElements((ContentModelGroup)((ComplexType)base));
        }
        Enumeration elements = group.enumerate();
        while (elements.hasMoreElements()) {
            Particle thisParticle = (Particle)elements.nextElement();
            if (thisParticle instanceof Group) {
                Order thisOrder;
                ModelGroup thisModel;
                Group thisGroup = (Group)thisParticle;
                if (thisGroup instanceof ModelGroup && (thisModel = (ModelGroup)thisGroup).hasReference()) {
                    thisGroup = thisModel.getReference();
                }
                if ((thisOrder = thisGroup.getOrder()) == Order.sequence || thisOrder == Order.all) {
                    this.enumerateElements((ContentModelGroup)thisGroup);
                    continue;
                }
                throw new StructuralException("The '" + thisGroup.getOrder() + "' group is not supported");
            }
            if (thisParticle instanceof ElementDecl) {
                ElementDecl thisElement = (ElementDecl)thisParticle;
                this.addStructure(this.createStructure(thisElement, this.readOnly));
                continue;
            }
            if (thisParticle instanceof Wildcard) continue;
            throw new StructuralException("Particle " + thisParticle.getClass() + " not implemented");
        }
    }

    public void addStructure(OutcomeStructure newElement) throws OutcomeException {
        if (newElement == null) {
            return;
        }
        this.subStructure.put(newElement.getName(), newElement);
        this.order.add(newElement.getName());
    }

    public abstract void addInstance(Element var1, Document var2) throws OutcomeException;

    public Element getElement() {
        return this.myElement;
    }

    @Override
    public String getName() {
        if (this.model == null) {
            return null;
        }
        return this.model.getName();
    }

    public ElementDecl getModel() {
        return this.model;
    }

    public String getHelp() {
        return this.help;
    }

    public static JLabel makeLabel(String name, String helpText) {
        JLabel label;
        if (helpText == null) {
            label = new JLabel(name);
        } else {
            label = new JLabel(name, helpIconSmall, 2);
            label.setHorizontalTextPosition(10);
            label.setToolTipText("<html>" + helpText + "</html>");
        }
        return label;
    }

    public String validateStructure() {
        StringBuffer errors = new StringBuffer();
        for (OutcomeStructure element : this.subStructure.values()) {
            errors.append(element.validateStructure());
        }
        return errors.toString();
    }

    public abstract Element initNew(Document var1);

    public static String extractHelp(Annotated model) {
        Enumeration e = model.getAnnotations();
        StringBuffer doc = new StringBuffer();
        if (e.hasMoreElements()) {
            Annotation note = (Annotation)e.nextElement();
            Enumeration g = note.getDocumentation();
            while (g.hasMoreElements()) {
                Documentation thisDoc = (Documentation)g.nextElement();
                Enumeration h = thisDoc.getObjects();
                while (h.hasMoreElements()) {
                    AnyNode node = (AnyNode)h.nextElement();
                    String line = node.toString();
                    if (line.length() == 0) {
                        line = node.getStringValue();
                    }
                    if (line.length() <= 0) continue;
                    doc.append(line).append("\n");
                }
            }
        }
        return doc.toString();
    }

    @Override
    public abstract void grabFocus();

    public static Class<?> getJavaClass(int typeCode) {
        switch (typeCode) {
            case 11: {
                return Boolean.class;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return BigInteger.class;
            }
            case 14: 
            case 15: 
            case 16: {
                return BigDecimal.class;
            }
            case 12: 
            case 13: {
                return ImageIcon.class;
            }
        }
        return String.class;
    }

    public static Object getTypedValue(String value, Class<?> type) {
        try {
            if (type.equals(Boolean.class)) {
                if (value == null || value.equals("")) {
                    return Boolean.FALSE;
                }
                return Boolean.valueOf(value);
            }
            if (type.equals(BigInteger.class)) {
                if (value == null || value.equals("")) {
                    return new BigInteger("0");
                }
                return new BigInteger(value);
            }
            if (type.equals(BigDecimal.class)) {
                if (value == null || value.equals("")) {
                    return new BigDecimal(0);
                }
                return new BigDecimal(value);
            }
        }
        catch (Exception ex) {
            log.error("Cannot convert value '" + value + "' to a " + type.getName(), (Throwable)ex);
        }
        return value == null ? "" : value;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String ? ((String)value).length() == 0 : (value instanceof Boolean ? (Boolean)value == false : (value instanceof BigInteger ? ((BigInteger)value).intValue() == 0 : value instanceof BigDecimal && (double)((BigDecimal)value).floatValue() == 0.0));
    }
}

