/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.text.JTextComponent;
import org.cristalise.gui.tabs.outcome.form.field.EditField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanEditField
extends EditField {
    private static final Logger log = LoggerFactory.getLogger(BooleanEditField.class);
    JCheckBox checkbox = new JCheckBox();

    public BooleanEditField() {
        this.checkbox.setSelected(false);
        this.checkbox.addFocusListener(this);
    }

    @Override
    public String getText() {
        return String.valueOf(this.checkbox.isSelected());
    }

    @Override
    public void setText(String text) {
        boolean newState = false;
        try {
            newState = Boolean.valueOf(text);
        }
        catch (Exception ex) {
            log.error("", (Object)("Invalid value for checkbox: " + text));
        }
        this.checkbox.setSelected(newState);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.checkbox.setEnabled(editable);
    }

    @Override
    public Component getControl() {
        return this.checkbox;
    }

    @Override
    public String getDefaultValue() {
        return "false";
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public JTextComponent makeTextField() {
        return null;
    }
}

