/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.cristalise.gui.DynamicTreeBuilder;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.NodeAgent;
import org.cristalise.gui.tree.NodeContext;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.gui.tree.NodeRole;
import org.cristalise.gui.tree.NodeSubscriber;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;

public abstract class Node
implements Runnable {
    protected Path binding;
    protected DefaultMutableTreeNode treeNode;
    protected String name;
    protected ItemPath itemPath;
    protected String type = "";
    protected String toolTip = null;
    protected Icon icon;
    protected boolean isExpandable = false;
    protected List<Node> childNodes = new ArrayList<Node>();
    protected ArrayList<NodeSubscriber> subscribers = new ArrayList();
    protected DynamicTreeBuilder loader = null;
    private boolean loaded = false;
    private String iconName;
    protected ItemTabManager desktop;
    static ImageIcon folder = ImageLoader.findImage("folder.png");
    static ImageIcon emptyLeaf = ImageLoader.findImage("leaf.png");

    public Node(ItemTabManager desktop) {
        this.desktop = desktop;
    }

    protected void createTreeNode() {
        this.treeNode = new DefaultMutableTreeNode(this);
    }

    public Node(Path path, ItemTabManager desktop) {
        this.binding = path;
        this.desktop = desktop;
        try {
            this.itemPath = path.getItemPath();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        String[] pathComponents = path.getPath();
        this.name = pathComponents.length > 0 ? pathComponents[pathComponents.length - 1] : Gateway.getProperties().getProperty("Name");
    }

    public ItemTabManager getDesktop() {
        return this.desktop;
    }

    public Node newNode(Path path) {
        try {
            if (path.getItemPath() instanceof AgentPath) {
                return new NodeAgent(path, this.desktop);
            }
            if (path instanceof RolePath) {
                return new NodeRole(path, this.desktop);
            }
            return new NodeItem(path, this.desktop);
        }
        catch (ObjectNotFoundException ex) {
            return new NodeContext(path, this.desktop);
        }
    }

    public void makeExpandable() {
        if (this.isExpandable) {
            return;
        }
        this.loader = new DynamicTreeBuilder(this.treeNode, this.desktop);
        this.treeNode.insert(this.loader.getTreeNode(), 0);
        this.isExpandable = true;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public void setTreeNode(DefaultMutableTreeNode treeNode) {
        this.treeNode = treeNode;
        treeNode.setUserObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeNode(NodeSubscriber target) {
        this.subscribers.add(target);
        if (!this.loaded) {
            this.loaded = true;
            this.loadMore();
        } else {
            List<Node> list = this.childNodes;
            synchronized (list) {
                for (Node node : this.childNodes) {
                    target.add(node);
                }
            }
        }
    }

    public void loadMore() {
        Thread loading = new Thread(this);
        loading.start();
    }

    public void unsubscribeNode(NodeSubscriber target) {
        this.subscribers.remove(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node newNode) {
        List<Node> list = this.childNodes;
        synchronized (list) {
            this.childNodes.add(newNode);
            for (NodeSubscriber thisSub : this.subscribers) {
                thisSub.add(newNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Path oldPath) {
        List<Node> list = this.childNodes;
        synchronized (list) {
            for (NodeSubscriber thisSub : this.subscribers) {
                thisSub.remove(oldPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChildren() {
        List<Node> list = this.childNodes;
        synchronized (list) {
            for (Node node : this.childNodes) {
                this.remove(node.getPath());
            }
        }
    }

    public Node getChildNode(Path itsPath) {
        for (Node node : this.childNodes) {
            if (!node.getPath().equals((Object)itsPath)) continue;
            return node;
        }
        return null;
    }

    public void end(boolean more) {
        for (NodeSubscriber thisSub : this.subscribers) {
            thisSub.end(more);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Node Loader: " + this.name);
        this.loadChildren();
    }

    public abstract void loadChildren();

    public void refresh() {
        this.removeAllChildren();
        this.loadChildren();
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Path getPath() {
        return this.binding;
    }

    public DynamicTreeBuilder getTreeBuilder() {
        return this.loader;
    }

    public String toString() {
        if (this.name.length() > 0) {
            return this.name;
        }
        return "Cristal";
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return this.isExpandable ? folder : emptyLeaf;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIcon(String icon) {
        this.iconName = icon;
        this.icon = ImageLoader.findImage("typeicons/" + icon + "_16.png");
        if (this.icon == ImageLoader.nullImg) {
            this.icon = ImageLoader.findImage("typeicons/item_16.png");
        }
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Node.this.isExpandable) {
                    Node.this.refresh();
                }
            }
        });
        popup.add(menuItem);
        return popup;
    }

    public String getToolTip() {
        if (this.toolTip != null && this.toolTip.length() > 0) {
            return this.toolTip;
        }
        return this.type;
    }

    public void setToolTip(String tip) {
        this.toolTip = tip;
    }
}

