/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeCollectionMember;
import org.cristalise.gui.tree.NodeSubscriber;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.AddMembersToCollection;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCollection
extends Node {
    private static final Logger log = LoggerFactory.getLogger(NodeCollection.class);
    ItemProxy parent;
    Collection<? extends CollectionMember> thisCollection;
    String path;

    public NodeCollection(ItemProxy parent, String name, ItemTabManager desktop) {
        super(desktop);
        this.parent = parent;
        this.name = name;
        this.path = parent.getPath() + "/" + ClusterType.COLLECTION + "/" + name + "/last";
        this.createTreeNode();
        this.makeExpandable();
        Vertx vertx = Gateway.getVertx();
        vertx.eventBus().localConsumer(parent.getPath().getUUID() + "/" + ClusterType.COLLECTION, message -> {
            String[] tokens = ((String)message.body()).split(":");
            String collPath = tokens[0];
            if (tokens[1].equals("DELETE")) {
                return;
            }
            vertx.executeBlocking(promise -> {
                try {
                    int idx = collPath.lastIndexOf("/");
                    String collName = collPath.substring(0, idx);
                    if (collPath.endsWith("/last")) {
                        this.add((Collection<? extends CollectionMember>)parent.getCollection(collName));
                    } else {
                        Integer version = new Integer(collPath.substring(idx + 1));
                        this.add((Collection<? extends CollectionMember>)parent.getCollection(collName, version));
                    }
                }
                catch (ObjectNotFoundException e) {
                    log.error("localConsumer.handler()", (Throwable)e);
                }
                promise.complete();
            }, res -> log.warn("", res.cause()));
        });
    }

    public NodeCollection(ItemProxy parent, Collection<? extends CollectionMember> coll, ItemTabManager desktop) {
        this(parent, coll.getName(), desktop);
        this.add(coll);
    }

    @Override
    public void loadChildren() {
        try {
            if (this.thisCollection == null) {
                Collection initColl = (Collection)this.parent.getObject(ClusterType.COLLECTION + "/" + this.name + "/last");
                this.add((Collection<? extends CollectionMember>)initColl);
            }
        }
        catch (ObjectNotFoundException ex) {
            this.end(false);
            return;
        }
    }

    public void add(Collection<? extends CollectionMember> contents) {
        if (!contents.getName().equals(this.name)) {
            return;
        }
        this.type = contents.getClass().getSimpleName();
        ArrayList newMembers = contents.getMembers().list;
        ArrayList oldMembers = this.thisCollection == null ? new ArrayList() : this.thisCollection.getMembers().list;
        ArrayList<Integer> currentSlotIds = new ArrayList<Integer>();
        for (CollectionMember newMember : newMembers) {
            if (oldMembers.contains(newMember)) continue;
            currentSlotIds.add(newMember.getID());
            NodeCollectionMember newMemberNode = new NodeCollectionMember(newMember, this.desktop);
            newMemberNode.setCollection(contents, newMember.getID(), this.parent);
            newMemberNode.setToolTip(NodeCollection.getPropertyToolTip(newMember.getProperties()));
            this.add(newMemberNode);
        }
        for (Node node : this.childNodes) {
            int slotId = ((NodeCollectionMember)node).getMember().getID();
            if (currentSlotIds.contains(slotId)) continue;
            this.remove(slotId);
        }
        this.thisCollection = contents;
        if (this.isDependency()) {
            this.setToolTip(NodeCollection.getPropertyToolTip(((Dependency)contents).getProperties()));
        }
        this.end(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int slotId) {
        List list = this.childNodes;
        synchronized (list) {
            int oldIdx = -1;
            Path oldPath = null;
            for (int i = 0; i < this.childNodes.size(); ++i) {
                int id = ((NodeCollectionMember)this.childNodes.get(i)).getMember().getID();
                if (id != slotId) continue;
                oldIdx = i;
                oldPath = ((Node)this.childNodes.get(i)).getPath();
            }
            if (oldIdx != -1) {
                this.childNodes.remove(oldIdx);
                for (NodeSubscriber thisSub : this.subscribers) {
                    thisSub.remove(oldPath);
                }
            }
        }
    }

    public boolean addMember(ItemPath itemPath) {
        if (!this.isDependency()) {
            return false;
        }
        try {
            Dependency dep = new Dependency(this.thisCollection.getName());
            CastorHashMap memberProps1 = new CastorHashMap();
            dep.addMember(itemPath, memberProps1, "", null);
            MainFrame.userAgent.execute(this.parent, AddMembersToCollection.class, Gateway.getMarshaller().marshall((Object)dep));
            return true;
        }
        catch (Exception e1) {
            MainFrame.exceptionDialog(e1);
            return false;
        }
    }

    public static String getPropertyToolTip(CastorHashMap props) {
        if (props.size() == 0) {
            return null;
        }
        StringBuffer verStr = new StringBuffer("<html>");
        for (KeyValuePair prop : props.getKeyValuePairs()) {
            verStr.append("<b>").append(prop.getKey()).append(":</b> ").append(prop.getValue()).append("<br/>");
        }
        return verStr.append("</html>").toString();
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public boolean isDependency() {
        return this.thisCollection instanceof Dependency;
    }
}

