/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import io.vertx.core.Vertx;
import java.util.Iterator;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.Node;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeContext
extends Node {
    private static final Logger log = LoggerFactory.getLogger(NodeContext.class);
    Iterator<Path> children;

    public NodeContext(Path path, ItemTabManager desktop) {
        super(path, desktop);
        this.itemPath = null;
        this.createTreeNode();
        this.makeExpandable();
        this.type = "Cristal Context";
        if (this.binding instanceof DomainPath) {
            Vertx vertx = Gateway.getVertx();
            vertx.eventBus().localConsumer("tree", message -> {
                String[] tokens = ((String)message.body()).split(":");
                vertx.executeBlocking(promise -> {
                    if (tokens[1].equals("ADD")) {
                        this.pathAdded(new DomainPath(tokens[0]));
                    } else {
                        this.pathRemoved(new DomainPath(tokens[0]));
                    }
                    promise.complete();
                }, res -> {});
            });
        }
    }

    @Override
    public void loadChildren() {
        Path newPath;
        if (this.children == null) {
            this.children = Gateway.getLookup().getChildren(this.binding);
        }
        for (int batch = 75; this.children.hasNext() && batch > 0 && (newPath = this.children.next()) != null; --batch) {
            log.info("Subscription.run() - new node: " + newPath);
            this.add(this.newNode(newPath));
        }
        this.end(this.children.hasNext());
    }

    public void pathAdded(DomainPath path) {
        this.add(this.newNode((Path)path));
    }

    @Override
    public void refresh() {
        this.children = null;
        super.refresh();
    }

    public void pathRemoved(DomainPath path) {
        this.remove((Path)path);
    }
}

