/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqOutcomeHandler
extends JooqHandler {
    static final Table<?> OUTCOME_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"OUTCOME"}));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String[])new String[]{"UUID"}), UUID.class);
    static final Field<String> SCHEMA_NAME = DSL.field((Name)DSL.name((String[])new String[]{"SCHEMA_NAME"}), String.class);
    static final Field<Integer> SCHEMA_VERSION = DSL.field((Name)DSL.name((String[])new String[]{"SCHEMA_VERSION"}), Integer.class);
    static final Field<Integer> EVENT_ID = DSL.field((Name)DSL.name((String[])new String[]{"EVENT_ID"}), Integer.class);
    static final Field<String> XML = DSL.field((Name)DSL.name((String[])new String[]{"XML"}), String.class);

    @Override
    protected Table<?> getTable() {
        return OUTCOME_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        switch (primaryKeys.length) {
            case 0: {
                return SCHEMA_NAME;
            }
            case 1: {
                return SCHEMA_VERSION;
            }
            case 2: {
                return EVENT_ID;
            }
            case 3: {
                return null;
            }
        }
        throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                break;
            }
            case 2: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                conditions.add(SCHEMA_VERSION.equal((Object)Integer.valueOf(primaryKeys[1])));
                break;
            }
            case 3: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                conditions.add(SCHEMA_VERSION.equal((Object)Integer.valueOf(primaryKeys[1])));
                conditions.add(EVENT_ID.equal((Object)Integer.valueOf(primaryKeys[2])));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        throw new IllegalArgumentException("Outcome must not be updated uuid:" + uuid + " name:" + obj.getName());
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) {
        Outcome outcome = (Outcome)obj;
        return context.insertInto(OUTCOME_TABLE).set(UUID, (Object)uuid).set(SCHEMA_NAME, (Object)outcome.getSchema().getName()).set(SCHEMA_VERSION, (Object)outcome.getSchema().getVersion()).set(EVENT_ID, (Object)outcome.getID()).set(XML, (Object)outcome.getData()).execute();
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            try {
                String xml = (String)result.get(XML);
                return new Outcome(((Integer)result.get(EVENT_ID)).intValue(), xml, LocalObjectLoader.getSchema((String)((String)result.get(SCHEMA_NAME)), (int)((Integer)result.get(SCHEMA_VERSION))));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) throws PersistencyException {
        DataType<String> xmlType = this.getXMLType(context);
        context.createTableIfNotExists(OUTCOME_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(SCHEMA_NAME, NAME_TYPE.nullable(false)).column(SCHEMA_VERSION, VERSION_TYPE.nullable(false)).column(EVENT_ID, ID_TYPE.nullable(false)).column(XML, xmlType.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + OUTCOME_TABLE)).primaryKey(new Field[]{UUID, SCHEMA_NAME, SCHEMA_VERSION, EVENT_ID})}).execute();
    }
}

