/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConnectionProvider;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;

public abstract class JooqHandler {
    public static final String JOOQ_URI = "JOOQ.URI";
    public static final String JOOQ_USER = "JOOQ.user";
    public static final String JOOQ_PASSWORD = "JOOQ.password";
    public static final String JOOQ_DIALECT = "JOOQ.dialect";
    public static final String JOOQ_AUTOCOMMIT = "JOOQ.autoCommit";
    public static final String JOOQ_DOMAIN_HANDLERS = "JOOQ.domainHandlers";
    public static final DataType<UUID> UUID_TYPE = SQLDataType.UUID;
    public static final DataType<String> NAME_TYPE = SQLDataType.VARCHAR.length(64);
    public static final DataType<Integer> VERSION_TYPE = SQLDataType.INTEGER;
    public static final DataType<String> STRING_TYPE = SQLDataType.VARCHAR.length(800);
    public static final DataType<Integer> ID_TYPE = SQLDataType.INTEGER;
    public static final DataType<Timestamp> TIMESTAMP_TYPE = SQLDataType.TIMESTAMP;
    public static final DataType<String> XML_TYPE = SQLDataType.CLOB;
    public static final DataType<String> XML_TYPE_MYSQL = new DefaultDataType(SQLDialect.MYSQL, SQLDataType.CLOB, "mediumtext", "char");
    public static final DataType<byte[]> ATTACHMENT_TYPE = SQLDataType.BLOB;

    public static DSLContext connect() throws PersistencyException {
        String uri = Gateway.getProperties().getString(JOOQ_URI);
        String user = Gateway.getProperties().getString(JOOQ_USER);
        String pwd = Gateway.getProperties().getString(JOOQ_PASSWORD);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{uri, user, pwd})) {
            throw new IllegalArgumentException("JOOQ (uri, user, password) config values must not be blank");
        }
        SQLDialect dialect = SQLDialect.valueOf((String)Gateway.getProperties().getString(JOOQ_DIALECT, "POSTGRES"));
        Logger.msg((int)1, (String)("JooqHandler.open() - uri:'" + uri + "' user:'" + user + "' dialect:'" + dialect + "'"), (Object[])new Object[0]);
        try {
            DSLContext context = DSL.using((Connection)DriverManager.getConnection(uri, user, pwd), (SQLDialect)dialect);
            boolean autoCommit = Gateway.getProperties().getBoolean(JOOQ_AUTOCOMMIT, false);
            ((DefaultConnectionProvider)context.configuration().connectionProvider()).setAutoCommit(autoCommit);
            return context;
        }
        catch (Exception ex) {
            Logger.error((String)("JooqHandler could not connect to URI '" + uri + "' with user '" + user + "'"), (Object[])new Object[0]);
            Logger.error((Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
    }

    protected abstract Table<?> getTable();

    protected abstract Field<?> getNextPKField(String ... var1) throws PersistencyException;

    protected abstract List<Condition> getPKConditions(UUID var1, String ... var2) throws PersistencyException;

    protected Record fetchRecord(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.select(new SelectField[0]).from(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).fetchOne();
    }

    protected Result<?> fetchDistinctResult(DSLContext context, Field<?> field, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.selectDistinct(field).from(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).fetch();
    }

    protected List<Condition> getPKConditions(UUID uuid, C2KLocalObject obj) throws PersistencyException {
        String[] pathArray = obj.getClusterPath().split("/");
        String[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        return this.getPKConditions(uuid, primaryKeys);
    }

    public int put(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        if (this.exists(context, uuid, obj)) {
            return this.update(context, uuid, obj);
        }
        return this.insert(context, uuid, obj);
    }

    public int delete(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.delete(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).execute();
    }

    public String[] getNextPrimaryKeys(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Field<?> field = this.getNextPKField(primaryKeys);
        if (field == null) {
            return new String[0];
        }
        Result<?> result = this.fetchDistinctResult(context, field, uuid, primaryKeys);
        String[] returnValue = new String[result.size()];
        int i = 0;
        for (Record rec : result) {
            returnValue[i++] = rec.get(0).toString();
        }
        return returnValue;
    }

    public boolean exists(DSLContext context, UUID uuid) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectField[])new SelectField[0]).from(this.getTable()).where(this.getPKConditions(uuid, new String[0])));
    }

    public boolean exists(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectField[])new SelectField[0]).from(this.getTable()).where(this.getPKConditions(uuid, obj)));
    }

    protected UUID getUUID(Record record, Field<UUID> field) {
        if (record.get(field.getName()) instanceof String) {
            return UUID.fromString((String)record.get(field.getName(), String.class));
        }
        return (UUID)record.get(field);
    }

    protected DataType<String> getXMLType(DSLContext context) {
        if (context.dialect().equals((Object)SQLDialect.MYSQL)) {
            return XML_TYPE_MYSQL;
        }
        return XML_TYPE;
    }

    public abstract void createTables(DSLContext var1) throws PersistencyException;

    public abstract int update(DSLContext var1, UUID var2, C2KLocalObject var3) throws PersistencyException;

    public abstract int insert(DSLContext var1, UUID var2, C2KLocalObject var3) throws PersistencyException;

    public abstract C2KLocalObject fetch(DSLContext var1, UUID var2, String ... var3) throws PersistencyException;
}

