/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqJobHandler
extends JooqHandler {
    static final Table<?> JOB_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"JOB"}));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String[])new String[]{"UUID"}), UUID.class);
    static final Field<Integer> ID = DSL.field((Name)DSL.name((String[])new String[]{"ID"}), Integer.class);
    static final Field<UUID> DELEGATE_UUID = DSL.field((Name)DSL.name((String[])new String[]{"DELEGATE_UUID"}), UUID.class);
    static final Field<UUID> ITEM_UUID = DSL.field((Name)DSL.name((String[])new String[]{"ITEM_UUID"}), UUID.class);
    static final Field<String> STEP_NAME = DSL.field((Name)DSL.name((String[])new String[]{"STEP_NAME"}), String.class);
    static final Field<String> STEP_PATH = DSL.field((Name)DSL.name((String[])new String[]{"STEP_PATH"}), String.class);
    static final Field<String> STEP_TYPE = DSL.field((Name)DSL.name((String[])new String[]{"STEP_TYPE"}), String.class);
    static final Field<String> TRANSITION = DSL.field((Name)DSL.name((String[])new String[]{"TRANSITION"}), String.class);
    static final Field<String> ORIGIN_STATE_NAME = DSL.field((Name)DSL.name((String[])new String[]{"ORIGIN_STATE_NAME"}), String.class);
    static final Field<String> TARGET_STATE_NAME = DSL.field((Name)DSL.name((String[])new String[]{"TARGET_STATE_NAME"}), String.class);
    static final Field<String> AGENT_ROLE = DSL.field((Name)DSL.name((String[])new String[]{"AGENT_ROLE"}), String.class);
    static final Field<String> ACT_PROPERTIES = DSL.field((Name)DSL.name((String[])new String[]{"ACT_PROPERTIES"}), String.class);
    static final Field<Timestamp> CREATION_TS = DSL.field((Name)DSL.name((String[])new String[]{"CREATION_TS"}), Timestamp.class);

    @Override
    protected Table<?> getTable() {
        return JOB_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        if (primaryKeys.length == 0) {
            return ID;
        }
        return null;
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(ID.equal((Object)Integer.valueOf(primaryKeys[0])));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        throw new PersistencyException("Job must not be updated - uuid:" + uuid + " id:" + obj.getName());
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        String actPropsXML;
        String transXML;
        Job job = (Job)obj;
        try {
            transXML = Gateway.getMarshaller().marshall((Object)job.getTransition());
            actPropsXML = Gateway.getMarshaller().marshall((Object)job.getActProps());
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
        return context.insertInto(JOB_TABLE).set(UUID, (Object)uuid).set(ID, (Object)job.getId()).set(DELEGATE_UUID, job.getDelegatePath() == null ? null : job.getDelegatePath().getUUID()).set(ITEM_UUID, (Object)job.getItemPath().getUUID()).set(STEP_NAME, (Object)job.getStepName()).set(STEP_PATH, (Object)job.getStepPath()).set(STEP_TYPE, (Object)job.getStepType()).set(TRANSITION, (Object)transXML).set(ORIGIN_STATE_NAME, (Object)job.getOriginStateName()).set(TARGET_STATE_NAME, (Object)job.getTargetStateName()).set(AGENT_ROLE, (Object)job.getAgentRole()).set(ACT_PROPERTIES, (Object)actPropsXML).set(CREATION_TS, (Object)DateUtility.toSqlTimestamp((GTimeStamp)job.getCreationDate())).execute();
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            try {
                Transition trans = (Transition)Gateway.getMarshaller().unmarshall((String)result.get(TRANSITION));
                CastorHashMap actProps = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)result.get(ACT_PROPERTIES));
                UUID delegate = this.getUUID(result, DELEGATE_UUID);
                GTimeStamp ts = DateUtility.fromSqlTimestamp((Timestamp)((Timestamp)result.get(CREATION_TS)));
                return new Job(((Integer)result.get(ID)).intValue(), new ItemPath(this.getUUID(result, ITEM_UUID)), (String)result.get(STEP_NAME), (String)result.get(STEP_PATH), (String)result.get(STEP_TYPE), trans, (String)result.get(ORIGIN_STATE_NAME), (String)result.get(TARGET_STATE_NAME), (String)result.get(AGENT_ROLE), new AgentPath(this.getUUID(result, UUID)), delegate == null ? null : new AgentPath(delegate), actProps, ts);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
                throw new PersistencyException(ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) {
        DataType<String> xmlType = this.getXMLType(context);
        context.createTableIfNotExists(JOB_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(ID, ID_TYPE.nullable(false)).column(DELEGATE_UUID, UUID_TYPE.nullable(true)).column(ITEM_UUID, UUID_TYPE.nullable(false)).column(STEP_NAME, NAME_TYPE.nullable(false)).column(STEP_PATH, NAME_TYPE.nullable(false)).column(STEP_TYPE, NAME_TYPE.nullable(false)).column(TRANSITION, xmlType.nullable(false)).column(ORIGIN_STATE_NAME, NAME_TYPE.nullable(false)).column(TARGET_STATE_NAME, NAME_TYPE.nullable(false)).column(AGENT_ROLE, NAME_TYPE.nullable(false)).column(ACT_PROPERTIES, xmlType.nullable(false)).column(CREATION_TS, TIMESTAMP_TYPE.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + JOB_TABLE)).primaryKey(new Field[]{UUID, ID})}).execute();
    }
}

