/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class JooqItemHandler {
    static final Table<?> ITEM_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"ITEM"}));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String[])new String[]{"UUID"}), UUID.class);
    static final Field<String> IOR = DSL.field((Name)DSL.name((String[])new String[]{"IOR"}), String.class);
    static final Field<Boolean> IS_AGENT = DSL.field((Name)DSL.name((String[])new String[]{"IS_AGENT"}), Boolean.class);
    static final Field<Boolean> IS_PASSWORD_TEMPORARY = DSL.field((Name)DSL.name((String[])new String[]{"IS_PASSWORD_TEMPORARY"}), Boolean.class);
    static final Field<String> PASSWORD = DSL.field((Name)DSL.name((String[])new String[]{"PASSWORD"}), String.class);

    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(ITEM_TABLE).column(UUID, JooqHandler.UUID_TYPE.nullable(false)).column(IOR, JooqHandler.STRING_TYPE.nullable(true)).column(IS_AGENT, SQLDataType.BOOLEAN.nullable(false)).column(IS_PASSWORD_TEMPORARY, SQLDataType.BOOLEAN.nullable(true)).column(PASSWORD, JooqHandler.STRING_TYPE.nullable(true)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + ITEM_TABLE)).primaryKey(new Field[]{UUID})}).execute();
    }

    public int updatePassword(DSLContext context, AgentPath agent, String password, boolean temporary) throws PersistencyException {
        UpdateSetMoreStep update = context.update(ITEM_TABLE).set(PASSWORD, (Object)password);
        if (Gateway.getProperties().getBoolean("JOOQ.TemporaryPwdFieldImplemented", true)) {
            update.set(IS_PASSWORD_TEMPORARY, (Object)temporary);
        }
        return update.where(new Condition[]{UUID.equal((Object)agent.getUUID())}).execute();
    }

    public int updateIOR(DSLContext context, ItemPath item, String ior) throws PersistencyException {
        return context.update(ITEM_TABLE).set(IOR, (Object)ior).where(new Condition[]{UUID.equal((Object)item.getUUID())}).execute();
    }

    public int update(DSLContext context, ItemPath path) throws PersistencyException {
        boolean isAgent = path instanceof AgentPath;
        return context.update(ITEM_TABLE).set(IOR, (Object)path.getIORString()).set(IS_AGENT, (Object)isAgent).where(new Condition[]{UUID.equal((Object)path.getUUID())}).execute();
    }

    public int delete(DSLContext context, UUID uuid) throws PersistencyException {
        return context.delete(ITEM_TABLE).where(new Condition[]{UUID.equal((Object)uuid)}).execute();
    }

    public int insert(DSLContext context, AgentPath agentPath, JooqItemPropertyHandler properties) throws PersistencyException {
        int rows;
        InsertSetMoreStep insert = context.insertInto(ITEM_TABLE).set(UUID, (Object)agentPath.getUUID()).set(IOR, (Object)agentPath.getIORString()).set(IS_AGENT, (Object)true);
        if (Gateway.getProperties().getBoolean("JOOQ.TemporaryPwdFieldImplemented", true)) {
            insert.set(IS_PASSWORD_TEMPORARY, (Object)agentPath.isPasswordTemporary());
        }
        if ((rows = insert.execute()) != 1) {
            throw new PersistencyException("Insert into ITEM table rows:" + rows);
        }
        Property name = new Property(BuiltInItemProperties.NAME, agentPath.getAgentName(), true);
        rows = properties.insert(context, agentPath.getUUID(), (C2KLocalObject)name);
        if (rows != 1) {
            throw new PersistencyException("Insert into ITEM_PROPERTY table rows:" + rows);
        }
        return 1;
    }

    public int insert(DSLContext context, ItemPath path) throws PersistencyException {
        return context.insertInto(ITEM_TABLE).set(UUID, (Object)path.getUUID()).set(IOR, (Object)path.getIORString()).set(IS_AGENT, (Object)false).execute();
    }

    public boolean exists(DSLContext context, UUID uuid) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectField[])new SelectField[0]).from(ITEM_TABLE).where(new Condition[]{UUID.equal((Object)uuid)}));
    }

    public ItemPath fetch(DSLContext context, UUID uuid, JooqItemPropertyHandler properties) throws PersistencyException {
        Record result = context.select(new SelectField[0]).from(ITEM_TABLE).where(new Condition[]{UUID.equal((Object)uuid)}).fetchOne();
        return JooqItemHandler.getItemPath(context, properties, result);
    }

    public String fetchPassword(DSLContext context, UUID uuid) throws PersistencyException {
        Record result = context.select(PASSWORD).from(ITEM_TABLE).where(new Condition[]{UUID.equal((Object)uuid)}).fetchOne();
        return (String)result.get(PASSWORD);
    }

    public static ItemPath getItemPath(DSLContext context, JooqItemPropertyHandler properties, Record record) throws PersistencyException {
        if (record != null) {
            UUID uuid = record.get(UUID.getName()) instanceof String ? java.util.UUID.fromString((String)record.get(UUID.getName(), String.class)) : (UUID)record.get(UUID);
            boolean isAgent = (Boolean)record.get(IS_AGENT.getName(), Boolean.class);
            String ior = (String)record.get(IOR);
            Boolean isTempPwd = false;
            try {
                isTempPwd = (Boolean)record.get(IS_PASSWORD_TEMPORARY.getName(), Boolean.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String nameProp = BuiltInItemProperties.NAME.toString();
            if (isAgent) {
                String name = record.field(nameProp) != null ? (String)record.get(nameProp, String.class) : ((Property)properties.fetch(context, uuid, nameProp)).getValue();
                return new AgentPath(uuid, ior, name, isTempPwd != null ? isTempPwd : false);
            }
            return new ItemPath(uuid, ior);
        }
        return null;
    }

    public List<Path> fetchAll(DSLContext context, List<UUID> uuids, JooqItemPropertyHandler properties) throws PersistencyException {
        Result result = context.select(new SelectField[0]).from(ITEM_TABLE).where(new Condition[]{UUID.in(uuids)}).fetch();
        ArrayList<Path> foundPathes = new ArrayList<Path>();
        for (Record record : result) {
            foundPathes.add((Path)JooqItemHandler.getItemPath(context, properties, record));
        }
        return foundPathes;
    }
}

