/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionalClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqDomainHandler;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqCollectionHadler;
import org.cristalise.storage.jooqdb.clusterStore.JooqHistoryHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqJobHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqLifecycleHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeAttachmentHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqViewpointHandler;
import org.jooq.DSLContext;
import org.jooq.impl.DefaultConnectionProvider;

public class JooqClusterStorage
extends TransactionalClusterStorage {
    protected DSLContext context;
    protected Boolean autoCommit;
    protected HashMap<ClusterType, JooqHandler> jooqHandlers = new HashMap();
    protected List<JooqDomainHandler> domainHandlers = new ArrayList<JooqDomainHandler>();

    public void open(Authenticator auth) throws PersistencyException {
        this.context = JooqHandler.connect();
        this.autoCommit = Gateway.getProperties().getBoolean("JOOQ.autoCommit", false);
        this.initialiseHandlers();
    }

    public void initialiseHandlers() throws PersistencyException {
        Logger.msg((int)1, (String)"JooqClusterStorage.initialiseHandlers() - Starting with standard hadlers.", (Object[])new Object[0]);
        this.jooqHandlers.put(ClusterType.PROPERTY, new JooqItemPropertyHandler());
        this.jooqHandlers.put(ClusterType.OUTCOME, new JooqOutcomeHandler());
        this.jooqHandlers.put(ClusterType.VIEWPOINT, new JooqViewpointHandler());
        this.jooqHandlers.put(ClusterType.LIFECYCLE, new JooqLifecycleHandler());
        this.jooqHandlers.put(ClusterType.COLLECTION, new JooqCollectionHadler());
        this.jooqHandlers.put(ClusterType.HISTORY, new JooqHistoryHandler());
        this.jooqHandlers.put(ClusterType.JOB, new JooqJobHandler());
        this.jooqHandlers.put(ClusterType.ATTACHMENT, new JooqOutcomeAttachmentHandler());
        for (JooqHandler jooqHandler : this.jooqHandlers.values()) {
            jooqHandler.createTables(this.context);
        }
        try {
            String handlers = Gateway.getProperties().getString("JOOQ.domainHandlers", "");
            for (String handlerClass : StringUtils.split((String)handlers, (String)",")) {
                if (!handlerClass.contains(".")) {
                    handlerClass = "org.cristalise.storage." + handlerClass;
                }
                Logger.msg((int)1, (String)("JooqClusterStorage.initialiseHandlers() - Instantiate domain handler:" + handlerClass), (Object[])new Object[0]);
                this.domainHandlers.add((JooqDomainHandler)Class.forName(handlerClass).newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.error((String)"JooqClusterStorage could not instantiate domain handler", (Object[])new Object[0]);
            Logger.error((Throwable)ex);
            throw new PersistencyException("JooqClusterStorage could not instantiate domain handler:" + ex.getMessage());
        }
        if (!Gateway.getProperties().getBoolean("JOOQ.disableDomainCreateTables", false)) {
            for (JooqDomainHandler jooqDomainHandler : this.domainHandlers) {
                jooqDomainHandler.createTables(this.context);
            }
        }
    }

    public void close() throws PersistencyException {
        Logger.msg((int)1, (String)"JooqClusterStorage.close()", (Object[])new Object[0]);
        try {
            this.context.close();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public void begin(Object locker) {
        Logger.msg((int)8, (String)"JooqClusterStorage.begin() - Nothing DONE.", (Object[])new Object[0]);
    }

    public void commit(Object locker) throws PersistencyException {
        if (this.autoCommit.booleanValue()) {
            Logger.msg((int)1, (String)("JooqClusterStorage.commit(DISABLED) - autoCommit:" + this.autoCommit), (Object[])new Object[0]);
            return;
        }
        Logger.msg((int)1, (String)"JooqClusterStorage.commit()", (Object[])new Object[0]);
        try {
            ((DefaultConnectionProvider)this.context.configuration().connectionProvider()).commit();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public void abort(Object locker) {
        if (this.autoCommit.booleanValue()) {
            Logger.msg((int)1, (String)("JooqClusterStorage.abort(DISABLED) - autoCommit:" + this.autoCommit), (Object[])new Object[0]);
            return;
        }
        Logger.msg((int)1, (String)"JooqClusterStorage.abort()", (Object[])new Object[0]);
        try {
            ((DefaultConnectionProvider)this.context.configuration().connectionProvider()).rollback();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public short queryClusterSupport(String type) {
        return this.queryClusterSupport(ClusterType.getValue((String)type));
    }

    public short queryClusterSupport(ClusterType type) {
        if (type == ClusterType.PATH) {
            return 0;
        }
        return 3;
    }

    public boolean checkQuerySupport(String language) {
        String lang = language.trim().toUpperCase();
        return "SQL".equals(lang) || ("SQL:" + this.context.dialect()).equals(lang);
    }

    public String getName() {
        return "JOOQ:" + this.context.dialect() + " ClusterStorage";
    }

    public String getId() {
        return "JOOQ:" + this.context.dialect();
    }

    public String executeQuery(Query query) throws PersistencyException {
        throw new PersistencyException("UnImplemented");
    }

    public ClusterType[] getClusters(ItemPath itemPath) throws PersistencyException {
        ArrayList<ClusterType> result = new ArrayList<ClusterType>();
        for (ClusterType type : this.jooqHandlers.keySet()) {
            if (!this.jooqHandlers.get(type).exists(this.context, itemPath.getUUID())) continue;
            result.add(type);
        }
        return result.toArray(new ClusterType[0]);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        if (StringUtils.isBlank((CharSequence)path)) {
            ArrayList<String> result = new ArrayList<String>();
            for (ClusterType k : this.getClusters(itemPath)) {
                result.add(k.toString());
            }
            return result.toArray(new String[0]);
        }
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler != null) {
            Logger.msg((int)5, (String)("JooqClusterStorage.getClusterContents() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys)), (Object[])new Object[0]);
            return handler.getNextPrimaryKeys(this.context, uuid, (String[])primaryKeys);
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException {
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler != null) {
            Logger.msg((int)5, (String)("JooqClusterStorage.get() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys:" + Arrays.toString(primaryKeys)), (Object[])new Object[0]);
            C2KLocalObject obj = handler.fetch(this.context, uuid, (String[])primaryKeys);
            if (obj == null && Logger.doLog((int)8)) {
                Logger.warning((String)("JooqClusterStorage.get() - Could NOT fetch '" + itemPath + "/" + path + "'"), (Object[])new Object[0]);
            }
            return obj;
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        this.put(itemPath, obj, null);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = obj.getClusterType();
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler == null) {
            throw new PersistencyException("Write is not supported for cluster:'" + cluster + "'");
        }
        Logger.msg((int)5, (String)("JooqClusterStorage.put() - uuid:" + uuid + " cluster:" + cluster + " path:" + obj.getClusterPath()), (Object[])new Object[0]);
        handler.put(this.context, uuid, obj);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.put(this.context, uuid, obj, locker);
        }
    }

    public void delete(ItemPath itemPath, String path) throws PersistencyException {
        this.delete(itemPath, path, null);
    }

    public void delete(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler == null) {
            throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
        }
        Logger.msg((int)5, (String)("JooqClusterStorage.delete() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys)), (Object[])new Object[0]);
        handler.delete(this.context, uuid, (String[])primaryKeys);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.delete(this.context, uuid, locker, (String[])primaryKeys);
        }
    }
}

