/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqCollectionHadler
extends JooqHandler {
    static final Table<?> COLLECTION_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"COLLECTION"}));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String[])new String[]{"UUID"}), UUID.class);
    static final Field<String> NAME = DSL.field((Name)DSL.name((String[])new String[]{"NAME"}), String.class);
    static final Field<String> VERSION = DSL.field((Name)DSL.name((String[])new String[]{"VERSION"}), String.class);
    static final Field<String> XML = DSL.field((Name)DSL.name((String[])new String[]{"XML"}), String.class);

    @Override
    protected Table<?> getTable() {
        return COLLECTION_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        switch (primaryKeys.length) {
            case 0: {
                return NAME;
            }
            case 1: {
                return VERSION;
            }
            case 2: {
                return null;
            }
        }
        throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(NAME.equal((Object)primaryKeys[0]));
                break;
            }
            case 2: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(NAME.equal((Object)primaryKeys[0]));
                conditions.add(VERSION.equal((Object)primaryKeys[1]));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys (max 2):" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        try {
            return context.update(COLLECTION_TABLE).set(XML, (Object)Gateway.getMarshaller().marshall((Object)obj)).where(this.getPKConditions(uuid, obj)).execute();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        Collection collection = (Collection)obj;
        try {
            return context.insertInto(COLLECTION_TABLE).set(UUID, (Object)uuid).set(NAME, (Object)collection.getName()).set(VERSION, (Object)collection.getVersionName()).set(XML, (Object)Gateway.getMarshaller().marshall((Object)obj)).execute();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            try {
                String xml = (String)result.get(XML);
                return (C2KLocalObject)Gateway.getMarshaller().unmarshall(xml);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(COLLECTION_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(NAME, NAME_TYPE.nullable(false)).column(VERSION, NAME_TYPE.nullable(false)).column(XML, XML_TYPE.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + COLLECTION_TABLE)).primaryKey(new Field[]{UUID, NAME, VERSION})}).execute();
    }
}

