/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class JooqItemPropertyHandler
extends JooqHandler {
    public static final Table<?> ITEM_PROPERTY_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"ITEM_PROPERTY"}));
    public static final Field<UUID> UUID = DSL.field((Name)DSL.name((String[])new String[]{"UUID"}), UUID.class);
    public static final Field<String> NAME = DSL.field((Name)DSL.name((String[])new String[]{"NAME"}), String.class);
    public static final Field<String> VALUE = DSL.field((Name)DSL.name((String[])new String[]{"VALUE"}), String.class);
    public static final Field<Boolean> MUTABLE = DSL.field((Name)DSL.name((String[])new String[]{"MUTABLE"}), Boolean.class);

    @Override
    protected Table<?> getTable() {
        return ITEM_PROPERTY_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        if (primaryKeys.length == 0) {
            return NAME;
        }
        return null;
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(NAME.equal((Object)primaryKeys[0]));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        return context.update(ITEM_PROPERTY_TABLE).set(VALUE, (Object)((Property)obj).getValue()).set(MUTABLE, (Object)((Property)obj).isMutable()).where(this.getPKConditions(uuid, obj)).execute();
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        return this.insert(context, uuid, new C2KLocalObject[]{obj});
    }

    public int insert(DSLContext context, UUID uuid, C2KLocalObject ... objs) throws PersistencyException {
        InsertQuery insertInto = context.insertQuery(ITEM_PROPERTY_TABLE);
        for (C2KLocalObject obj : objs) {
            insertInto.addValue(UUID, (Object)uuid);
            insertInto.addValue(NAME, (Object)obj.getName());
            insertInto.addValue(VALUE, (Object)((Property)obj).getValue());
            insertInto.addValue(MUTABLE, (Object)((Property)obj).isMutable());
            insertInto.newRecord();
        }
        Logger.msg((int)8, (String)("JooqItemPropertyHandler.insert() - SQL:\n" + insertInto), (Object[])new Object[0]);
        return insertInto.execute();
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            return new Property((String)result.get(NAME), (String)result.get(VALUE), ((Boolean)result.get(MUTABLE.getName(), Boolean.class)).booleanValue());
        }
        return null;
    }

    public List<UUID> findItemsByName(DSLContext context, String name) {
        return this.findItems(context, new Property(BuiltInItemProperties.NAME, name));
    }

    public List<UUID> findItems(DSLContext context, Property ... properties) {
        return this.findItems(context, -1, -1, properties);
    }

    public List<UUID> findItems(DSLContext context, int offset, int limit, Property ... properties) {
        Logger.msg((int)5, (String)("JooqItemPropertyHandler.findItems() - properties:" + Arrays.toString(properties)), (Object[])new Object[0]);
        SelectQuery select = context.selectQuery();
        Field firstJoinField = null;
        for (Property p : properties) {
            Field currJoinField = DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "UUID"}), UUID.class);
            if (firstJoinField == null) {
                select.addSelect(new SelectField[]{currJoinField});
                select.addFrom((TableLike)ITEM_PROPERTY_TABLE.as(p.getName()));
                firstJoinField = currJoinField;
            } else {
                select.addJoin((TableLike)ITEM_PROPERTY_TABLE.as(p.getName()), JoinType.LEFT_OUTER_JOIN, new Condition[]{firstJoinField.equal(currJoinField)});
            }
            Condition actualCondition = DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "NAME"}), String.class).equal((Object)p.getName()).and(DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "VALUE"}), String.class).equal((Object)p.getValue()));
            select.addConditions(Operator.AND, new Condition[]{actualCondition});
        }
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        Logger.msg((int)8, (String)("JooqItemPropertyHandler.findItems() - SQL:\n" + select), (Object[])new Object[0]);
        Result result = select.fetch();
        ArrayList<UUID> returnValue = new ArrayList<UUID>();
        for (Record record : result) {
            returnValue.add((UUID)record.get(0, UUID.class));
        }
        return returnValue;
    }

    @Override
    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(ITEM_PROPERTY_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(NAME, NAME_TYPE.nullable(false)).column(VALUE, STRING_TYPE.nullable(true)).column(MUTABLE, SQLDataType.BOOLEAN.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + ITEM_PROPERTY_TABLE)).primaryKey(new Field[]{UUID, NAME})}).execute();
    }
}

