/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class JooqRolePathHandler {
    public static final Table<?> ROLE_PATH_TABLE = DSL.table((Name)DSL.name((String[])new String[]{"ROLE_PATH"}));
    public static final Field<String> PATH = DSL.field((Name)DSL.name((String[])new String[]{"PATH"}), String.class);
    public static final Field<Boolean> JOBLIST = DSL.field((Name)DSL.name((String[])new String[]{"JOBLIST"}), Boolean.class);
    public static final Field<UUID> AGENT = DSL.field((Name)DSL.name((String[])new String[]{"AGENT"}), UUID.class);
    static final UUID NO_AGENT = new UUID(0L, 0L);

    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(ROLE_PATH_TABLE).column(PATH, JooqHandler.STRING_TYPE.nullable(false)).column(AGENT, JooqHandler.UUID_TYPE.nullable(false)).column(JOBLIST, SQLDataType.BOOLEAN.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + ROLE_PATH_TABLE)).primaryKey(new Field[]{PATH, AGENT})}).execute();
    }

    public static RolePath getRolePath(Record record) {
        if (record != null) {
            return new RolePath((String)record.get(PATH), ((Boolean)record.get(JOBLIST.getName(), Boolean.class)).booleanValue());
        }
        return null;
    }

    public static List<Path> getLisOfPaths(Result<?> result) {
        ArrayList<Path> roles = new ArrayList<Path>();
        if (result != null) {
            for (Record record : result) {
                roles.add((Path)JooqRolePathHandler.getRolePath(record));
            }
        }
        return roles;
    }

    public int update(DSLContext context, RolePath role) throws PersistencyException {
        return context.update(ROLE_PATH_TABLE).set(JOBLIST, (Object)role.hasJobList()).where(new Condition[]{PATH.equal((Object)role.getStringPath())}).and(AGENT.equal((Object)NO_AGENT)).execute();
    }

    public int delete(DSLContext context, RolePath role, AgentPath agent) throws PersistencyException {
        DeleteQuery delete = context.deleteQuery(ROLE_PATH_TABLE);
        delete.addConditions(new Condition[]{PATH.equal((Object)role.getStringPath())});
        if (agent != null) {
            delete.addConditions(Operator.AND, new Condition[]{AGENT.equal((Object)agent.getUUID())});
        }
        return delete.execute();
    }

    public int insert(DSLContext context, RolePath role, AgentPath agent) throws PersistencyException {
        UUID uuid = NO_AGENT;
        if (agent != null) {
            uuid = agent.getUUID();
        }
        return context.insertInto(ROLE_PATH_TABLE).set(PATH, (Object)role.getStringPath()).set(JOBLIST, (Object)role.hasJobList()).set(AGENT, (Object)uuid).execute();
    }

    public boolean exists(DSLContext context, RolePath role, AgentPath agent) throws PersistencyException {
        UUID uuid = NO_AGENT;
        if (agent != null) {
            uuid = agent.getUUID();
        }
        return context.fetchExists((Select)DSL.select((SelectField[])new SelectField[0]).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.equal((Object)role.getStringPath())}).and(AGENT.equal((Object)uuid)));
    }

    public RolePath fetch(DSLContext context, RolePath role) throws PersistencyException {
        Record result = context.select(new SelectField[0]).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.equal((Object)role.getStringPath())}).and(AGENT.equal((Object)NO_AGENT)).fetchOne();
        return JooqRolePathHandler.getRolePath(result);
    }

    public List<UUID> findAgents(DSLContext context, RolePath role) throws PersistencyException {
        Result result = context.select(new SelectField[0]).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.equal((Object)role.getStringPath())}).fetch();
        ArrayList<UUID> agents = new ArrayList<UUID>();
        if (result != null) {
            for (Record record : result) {
                UUID agent = (UUID)record.get(AGENT);
                if (agent.equals(NO_AGENT)) continue;
                agents.add(agent);
            }
        }
        return agents;
    }

    private SelectQuery<?> getFindRolesOfAgentSelect(DSLContext context, AgentPath agent) {
        SelectQuery select = context.selectQuery();
        select.addFrom(ROLE_PATH_TABLE);
        select.addConditions(new Condition[]{AGENT.equal((Object)agent.getUUID())});
        return select;
    }

    public int countRolesOfAgent(DSLContext context, AgentPath agent) throws PersistencyException {
        SelectQuery<?> selectCount = this.getFindRolesOfAgentSelect(context, agent);
        selectCount.addSelect(new SelectField[]{DSL.count()});
        return (Integer)selectCount.fetchOne(0, Integer.TYPE);
    }

    public List<Path> findRolesOfAgent(DSLContext context, AgentPath agent) throws PersistencyException {
        return this.findRolesOfAgent(context, agent, -1, -1);
    }

    public List<Path> findRolesOfAgent(DSLContext context, AgentPath agent, int offset, int limit) throws PersistencyException {
        SelectQuery<?> select = this.getFindRolesOfAgentSelect(context, agent);
        select.addSelect((SelectField[])ROLE_PATH_TABLE.fields());
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        return JooqRolePathHandler.getLisOfPaths(select.fetch());
    }

    public int countByRegex(DSLContext context, String pattern) {
        return (Integer)context.select((SelectField)DSL.countDistinct(PATH)).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.likeRegex(pattern)}).fetchOne(0, Integer.TYPE);
    }

    public List<Path> findByRegex(DSLContext context, String pattern) {
        Result result = context.selectDistinct(PATH, JOBLIST).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.likeRegex(pattern)}).fetch();
        return JooqRolePathHandler.getLisOfPaths(result);
    }

    public List<Path> findByRegex(DSLContext context, String pattern, int offset, int limit) {
        Result result = context.selectDistinct(PATH, JOBLIST).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.likeRegex(pattern)}).orderBy(PATH).limit(limit).offset(offset).fetch();
        return JooqRolePathHandler.getLisOfPaths(result);
    }

    public List<Path> find(DSLContext context, RolePath startPath, String name, List<UUID> uuids) {
        String pattern = startPath.getStringPath() + "/%" + name;
        return this.find(context, pattern, uuids);
    }

    public List<Path> find(DSLContext context, String pattern, List<UUID> uuids) {
        SelectConditionStep select = context.select(new SelectField[0]).from(ROLE_PATH_TABLE).where(new Condition[]{PATH.like(pattern)});
        if (uuids != null && uuids.size() != 0) {
            select.and(AGENT.in(uuids));
        }
        return JooqRolePathHandler.getLisOfPaths(select.fetch());
    }
}

