/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqHistoryHandler
extends JooqHandler {
    static final Table<?> EVENT_TABLE = DSL.table((Name)DSL.name((String)"EVENT"));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String)"UUID"), UUID.class);
    static final Field<Integer> ID = DSL.field((Name)DSL.name((String)"ID"), Integer.class);
    static final Field<UUID> AGENT_UUID = DSL.field((Name)DSL.name((String)"AGENT_UUID"), UUID.class);
    static final Field<UUID> DELEGATE_UUID = DSL.field((Name)DSL.name((String)"DELEGATE_UUID"), UUID.class);
    static final Field<String> AGENT_ROLE = DSL.field((Name)DSL.name((String)"AGENT_ROLE"), String.class);
    static final Field<String> SCHEMA_NAME = DSL.field((Name)DSL.name((String)"SCHEMA_NAME"), String.class);
    static final Field<Integer> SCHEMA_VERSION = DSL.field((Name)DSL.name((String)"SCHEMA_VERSION"), Integer.class);
    static final Field<String> STATEMACHINE_NAME = DSL.field((Name)DSL.name((String)"STATEMACHINE_NAME"), String.class);
    static final Field<Integer> STATEMACHINE_VERSION = DSL.field((Name)DSL.name((String)"STATEMACHINE_VERSION"), Integer.class);
    static final Field<String> STEP_NAME = DSL.field((Name)DSL.name((String)"STEP_NAME"), String.class);
    static final Field<String> STEP_PATH = DSL.field((Name)DSL.name((String)"STEP_PATH"), String.class);
    static final Field<String> STEP_TYPE = DSL.field((Name)DSL.name((String)"STEP_TYPE"), String.class);
    static final Field<Integer> ORIGIN_STATE_ID = DSL.field((Name)DSL.name((String)"ORIGIN_STATE_ID"), Integer.class);
    static final Field<Integer> TARGET_STATE_ID = DSL.field((Name)DSL.name((String)"TARGET_STATE_ID"), Integer.class);
    static final Field<Integer> TRANSITION_ID = DSL.field((Name)DSL.name((String)"TRANSITION_ID"), Integer.class);
    static final Field<String> VIEW_NAME = DSL.field((Name)DSL.name((String)"VIEW_NAME"), String.class);
    static final Field<Timestamp> TIMESTAMP = DSL.field((Name)DSL.name((String)"TIMESTAMP"), Timestamp.class);

    @Override
    protected Table<?> getTable() {
        return EVENT_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        if (primaryKeys.length == 0) {
            return ID;
        }
        return null;
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(ID.equal((Object)Integer.valueOf(primaryKeys[0])));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys (max 1):" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        throw new PersistencyException("Event must not be updated - uuid:" + uuid + " id:" + obj.getName());
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        Event event = (Event)obj;
        AgentPath delegate = event.getDelegatePath();
        return context.insertInto(EVENT_TABLE).set(UUID, (Object)uuid).set(ID, (Object)event.getID()).set(AGENT_UUID, (Object)event.getAgentPath().getUUID()).set(DELEGATE_UUID, (Object)(delegate == null ? null : delegate.getUUID())).set(AGENT_ROLE, (Object)event.getAgentRole()).set(SCHEMA_NAME, (Object)event.getSchemaName()).set(SCHEMA_VERSION, (Object)event.getSchemaVersion()).set(STATEMACHINE_NAME, (Object)event.getStateMachineName()).set(STATEMACHINE_VERSION, (Object)event.getStateMachineVersion()).set(STEP_NAME, (Object)event.getStepName()).set(STEP_PATH, (Object)event.getStepPath()).set(STEP_TYPE, (Object)event.getStepType()).set(ORIGIN_STATE_ID, (Object)event.getOriginState()).set(TARGET_STATE_ID, (Object)event.getTargetState()).set(TRANSITION_ID, (Object)event.getTransition()).set(VIEW_NAME, (Object)event.getViewName()).set(TIMESTAMP, (Object)DateUtility.toSqlTimestamp((GTimeStamp)event.getTimeStamp())).execute();
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            UUID agent = this.getUUID(result, AGENT_UUID);
            UUID delegate = this.getUUID(result, DELEGATE_UUID);
            GTimeStamp ts = DateUtility.fromSqlTimestamp((Timestamp)((Timestamp)result.get(TIMESTAMP)));
            try {
                return new Event((Integer)result.get(ID), new ItemPath(uuid), new AgentPath(agent), delegate == null ? null : new AgentPath(delegate), (String)result.get(AGENT_ROLE), (String)result.get(STEP_NAME), (String)result.get(STEP_PATH), (String)result.get(STEP_TYPE), (String)result.get(STATEMACHINE_NAME), (Integer)result.get(STATEMACHINE_VERSION), ((Integer)result.get(TRANSITION_ID)).intValue(), ((Integer)result.get(ORIGIN_STATE_ID)).intValue(), ((Integer)result.get(TARGET_STATE_ID)).intValue(), (String)result.get(SCHEMA_NAME), (Integer)result.get(SCHEMA_VERSION), (String)result.get(VIEW_NAME), ts);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
                throw new PersistencyException(ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) {
        context.createTableIfNotExists(EVENT_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(ID, ID_TYPE.nullable(false)).column(AGENT_UUID, UUID_TYPE.nullable(false)).column(DELEGATE_UUID, UUID_TYPE.nullable(true)).column(AGENT_ROLE, NAME_TYPE.nullable(true)).column(SCHEMA_NAME, NAME_TYPE.nullable(true)).column(SCHEMA_VERSION, VERSION_TYPE.nullable(true)).column(STATEMACHINE_NAME, NAME_TYPE.nullable(false)).column(STATEMACHINE_VERSION, VERSION_TYPE.nullable(false)).column(STEP_NAME, NAME_TYPE.nullable(false)).column(STEP_PATH, STRING_TYPE.nullable(false)).column(STEP_TYPE, NAME_TYPE.nullable(true)).column(ORIGIN_STATE_ID, ID_TYPE.nullable(false)).column(TARGET_STATE_ID, ID_TYPE.nullable(false)).column(TRANSITION_ID, ID_TYPE.nullable(false)).column(VIEW_NAME, NAME_TYPE.nullable(true)).column(TIMESTAMP, TIMESTAMP_TYPE.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + EVENT_TABLE)).primaryKey(new Field[]{UUID, ID})}).execute();
    }

    @Override
    public void dropTables(DSLContext context) throws PersistencyException {
        context.dropTableIfExists(EVENT_TABLE).execute();
    }
}

