/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.auth.Argon2Password;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.lookup.JooqDomainPathHandler;
import org.cristalise.storage.jooqdb.lookup.JooqItemHandler;
import org.cristalise.storage.jooqdb.lookup.JooqPermissionHandler;
import org.cristalise.storage.jooqdb.lookup.JooqRolePathHandler;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class JooqLookupManager
implements LookupManager {
    protected DSLContext context;
    private JooqItemHandler items;
    private JooqDomainPathHandler domains;
    private JooqRolePathHandler roles;
    private JooqPermissionHandler permissions;
    private JooqItemPropertyHandler properties;
    private Argon2Password passwordHasher;

    public void open(Authenticator auth) {
        try {
            this.context = JooqHandler.connect();
            this.initialiseHandlers();
            this.passwordHasher = new Argon2Password();
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void initialiseHandlers() throws PersistencyException {
        this.items = new JooqItemHandler();
        this.domains = new JooqDomainPathHandler();
        this.roles = new JooqRolePathHandler();
        this.permissions = new JooqPermissionHandler();
        this.properties = new JooqItemPropertyHandler();
        this.items.createTables(this.context);
        this.domains.createTables(this.context);
        this.roles.createTables(this.context);
        this.permissions.createTables(this.context);
        this.properties.createTables(this.context);
    }

    public void dropHandlers() throws PersistencyException {
        this.properties.dropTables(this.context);
        this.permissions.dropTables(this.context);
        this.roles.dropTables(this.context);
        this.domains.dropTables(this.context);
        this.items.dropTables(this.context);
    }

    public void initializeDirectory() throws ObjectNotFoundException {
        Logger.msg((int)6, (String)"JOOQLookupManager.initializeDirectory() - NOTHING done.", (Object[])new Object[0]);
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    public boolean exists(Path path) {
        if (path == null) {
            return false;
        }
        boolean exists = false;
        try {
            if (path instanceof ItemPath) {
                exists = this.items.exists(this.context, path.getUUID());
            } else if (path instanceof AgentPath) {
                exists = this.items.exists(this.context, path.getUUID());
            } else if (path instanceof DomainPath) {
                exists = this.domains.exists(this.context, (DomainPath)path);
            } else if (path instanceof RolePath) {
                exists = this.roles.exists(this.context, (RolePath)path, null);
            }
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
        }
        if (Logger.doLog((int)5)) {
            JooqHandler.logConnectionCount("JooqLookupManager.exists()", this.context);
        }
        return exists;
    }

    public void add(Path newPath) throws ObjectCannotBeUpdated, ObjectAlreadyExistsException {
        if (this.exists(newPath)) {
            throw new ObjectAlreadyExistsException("Path exist:" + newPath);
        }
        Logger.msg((int)8, (String)("JooqLookupManager.add() - path:" + newPath), (Object[])new Object[0]);
        try {
            int rows = 0;
            if (newPath instanceof AgentPath) {
                rows = this.items.insert(this.context, (AgentPath)newPath, this.properties);
            } else if (newPath instanceof ItemPath) {
                rows = this.items.insert(this.context, (ItemPath)newPath);
            } else if (newPath instanceof DomainPath) {
                rows = this.domains.insert(this.context, (DomainPath)newPath);
            } else if (newPath instanceof RolePath) {
                int n = rows = this.createRole((RolePath)newPath) != null ? 1 : 0;
            }
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("JOOQLookupManager must insert some records:" + rows);
            }
            Logger.msg((int)8, (String)("JooqLookupManager.add() - path:" + newPath + " rows inserted:" + rows), (Object[])new Object[0]);
            if (Logger.doLog((int)5)) {
                JooqHandler.logConnectionCount("JooqLookupManager.add()", this.context);
            }
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    public void delete(Path path) throws ObjectCannotBeUpdated {
        if (!this.exists(path)) {
            throw new ObjectCannotBeUpdated("Path does not exist:" + path);
        }
        Logger.msg((int)8, (String)("JooqLookupManager.delete() - path:" + path), (Object[])new Object[0]);
        try {
            if (this.getChildren(path).hasNext()) {
                throw new ObjectCannotBeUpdated("Path is not a leaf");
            }
            int rows = 0;
            if (path instanceof ItemPath) {
                rows = this.items.delete(this.context, path.getUUID());
            } else if (path instanceof AgentPath) {
                rows = this.items.delete(this.context, path.getUUID());
            } else if (path instanceof DomainPath) {
                rows = this.domains.delete(this.context, path.getStringPath());
            } else if (path instanceof RolePath) {
                this.permissions.delete(this.context, path.getStringPath());
                rows = this.roles.delete(this.context, (RolePath)path, null);
            }
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("JOOQLookupManager must delete some records:" + rows);
            }
            Logger.msg((int)8, (String)("JooqLookupManager.delete() - path:" + path + " rows deleted:" + rows), (Object[])new Object[0]);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    public ItemPath getItemPath(String sysKey) throws InvalidItemPathException, ObjectNotFoundException {
        ItemPath ip = new ItemPath(sysKey);
        if (!this.exists((Path)ip)) {
            throw new ObjectNotFoundException("Path does not exist:" + sysKey);
        }
        try {
            return this.items.fetch(this.context, ip.getUUID(), this.properties);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw new InvalidItemPathException(e.getMessage());
        }
    }

    public String getIOR(Path path) throws ObjectNotFoundException {
        try {
            return this.getItemPath(path.getStringPath()).getIORString();
        }
        catch (InvalidItemPathException e) {
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    private List<Path> find(Path start, String name, List<UUID> uuids) {
        Logger.msg((int)8, (String)("JooqLookupManager.find() - start:" + start + " name:" + name), (Object[])new Object[0]);
        if (start instanceof DomainPath) {
            return this.domains.find(this.context, (DomainPath)start, name, uuids);
        }
        if (start instanceof RolePath) {
            return this.roles.find(this.context, (RolePath)start, name, uuids);
        }
        return new ArrayList<Path>();
    }

    public Iterator<Path> search(Path start, String name) {
        List<Path> result = this.find(start, name, null);
        if (result == null) {
            return new ArrayList().iterator();
        }
        return result.iterator();
    }

    public AgentPath getAgentPath(String agentName) throws ObjectNotFoundException {
        List<UUID> uuids = this.properties.findItemsByName(this.context, agentName);
        if (uuids.size() == 0) {
            throw new ObjectNotFoundException("Could not find agent:" + agentName);
        }
        try {
            return (AgentPath)this.items.fetch(this.context, uuids.get(0), this.properties);
        }
        catch (PersistencyException e) {
            throw new ObjectNotFoundException("Could not retrieve agentName:" + agentName + " error:" + e.getMessage());
        }
    }

    public RolePath getRolePath(String roleName) throws ObjectNotFoundException {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        uuids.add(JooqRolePathHandler.NO_AGENT);
        List<Path> result = this.roles.find(this.context, "%/" + roleName, uuids);
        if (result == null || result.size() == 0) {
            throw new ObjectNotFoundException("Role '" + roleName + "' does not exist");
        }
        if (result.size() > 1) {
            throw new ObjectNotFoundException("Unbiguos roleName:'" + roleName + "'");
        }
        RolePath role = (RolePath)result.get(0);
        role.setPermissions(this.permissions.fetch(this.context, role.getStringPath()));
        return role;
    }

    public ItemPath resolvePath(DomainPath domainPath) throws InvalidItemPathException, ObjectNotFoundException {
        if (!this.exists((Path)domainPath)) {
            throw new ObjectNotFoundException("Path does not exist:" + domainPath);
        }
        try {
            DomainPath dp = this.domains.fetch(this.context, domainPath);
            if (dp.getTarget() == null) {
                throw new InvalidItemPathException("DomainPath has no target:" + domainPath);
            }
            return this.items.fetch(this.context, dp.getTarget().getUUID(), this.properties);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public String getAgentName(AgentPath agentPath) throws ObjectNotFoundException {
        if (!this.exists((Path)agentPath)) {
            throw new ObjectNotFoundException("Path does not exist:" + agentPath);
        }
        try {
            ItemPath ip = this.items.fetch(this.context, agentPath.getUUID(), this.properties);
            if (ip instanceof AgentPath) {
                return ((AgentPath)ip).getAgentName();
            }
            throw new ObjectNotFoundException("Path is not an agent:" + agentPath);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    private String getChildrenPattern(Path path) {
        return "^" + path.getStringPath() + "/[^/]*$";
    }

    public Iterator<Path> getChildren(Path path) {
        String pattern = this.getChildrenPattern(path);
        Logger.msg((int)8, (String)("JooqLookupManager.getChildren() - pattern:" + pattern), (Object[])new Object[0]);
        Iterator<Path> iter = null;
        if (path instanceof RolePath) {
            iter = this.roles.findByRegex(this.context, pattern).iterator();
        } else if (path instanceof DomainPath) {
            iter = this.domains.findByRegex(this.context, pattern).iterator();
        }
        if (Logger.doLog((int)5)) {
            JooqHandler.logConnectionCount("JooqLookupManager.getChildren()", this.context);
        }
        if (iter == null) {
            return new ArrayList().iterator();
        }
        return iter;
    }

    public Lookup.PagedResult getChildren(Path path, int offset, int limit) {
        String pattern = this.getChildrenPattern(path);
        Logger.msg((int)8, (String)"JooqLookupManager.getChildren() - pattern:%s offset:%d limit:%d", (Object[])new Object[]{pattern, offset, limit});
        if (path instanceof ItemPath) {
            return new Lookup.PagedResult();
        }
        int maxRows = 0;
        if (path instanceof RolePath) {
            maxRows = this.roles.countByRegex(this.context, pattern);
        } else if (path instanceof DomainPath) {
            maxRows = this.domains.countByRegex(this.context, pattern);
        }
        if (maxRows == 0) {
            return new Lookup.PagedResult();
        }
        List<Path> pathes = null;
        if (path instanceof RolePath) {
            pathes = this.roles.findByRegex(this.context, pattern, offset, limit);
        } else if (path instanceof DomainPath) {
            pathes = this.domains.findByRegex(this.context, pattern, offset, limit);
        }
        if (Logger.doLog((int)5)) {
            JooqHandler.logConnectionCount("JooqLookupManager.getChildren()", this.context);
        }
        if (pathes == null) {
            return new Lookup.PagedResult();
        }
        return new Lookup.PagedResult(maxRows, pathes);
    }

    private SelectQuery<?> getSearchSelect(Path start, List<Property> props) {
        SelectQuery select = this.context.selectQuery();
        select.addFrom(JooqDomainPathHandler.DOMAIN_PATH_TABLE);
        for (Property p : props) {
            Field joinField = DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "UUID"}), UUID.class);
            select.addJoin((TableLike)JooqItemPropertyHandler.ITEM_PROPERTY_TABLE.as(p.getName()), JoinType.LEFT_OUTER_JOIN, JooqDomainPathHandler.TARGET.equal(joinField));
            select.addConditions(Operator.AND, DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "NAME"}), String.class).equal((Object)p.getName()));
            select.addConditions(Operator.AND, (Condition)DSL.upper((Field)DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "VALUE"}), String.class)).like(DSL.upper((String)p.getValue())));
        }
        select.addConditions(Operator.AND, (Condition)JooqDomainPathHandler.PATH.like(this.domains.getFindPattern(start, "")));
        return select;
    }

    public Iterator<Path> search(Path start, Property ... props) {
        return this.search((Path)start, Arrays.asList(props), (int)0, (int)0).rows.iterator();
    }

    public Lookup.PagedResult search(Path start, List<Property> props, int offset, int limit) {
        if (!this.exists(start)) {
            return new Lookup.PagedResult(0, new ArrayList());
        }
        int maxRows = -1;
        if (limit > 0) {
            SelectQuery<?> selectCount = this.getSearchSelect(start, props);
            selectCount.addSelect(new SelectFieldOrAsterisk[]{DSL.count()});
            Logger.msg((int)8, (String)"JooqLookupManager.search(props) - SQL(count):\n%s", (Object[])new Object[]{selectCount});
            maxRows = (Integer)selectCount.fetchOne(0, Integer.TYPE);
            if (maxRows == 0) {
                return new Lookup.PagedResult(0, new ArrayList());
            }
        }
        SelectQuery<?> select = this.getSearchSelect(start, props);
        select.addSelect(new SelectFieldOrAsterisk[]{JooqDomainPathHandler.PATH, JooqDomainPathHandler.TARGET});
        select.addOrderBy(new OrderField[]{JooqDomainPathHandler.PATH});
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        Logger.msg((int)8, (String)"JooqLookupManager.search(props) - SQL:\n%s", (Object[])new Object[]{select});
        return new Lookup.PagedResult(maxRows, this.domains.getListOfPath(select.fetch()));
    }

    public Iterator<Path> search(Path start, PropertyDescriptionList props) {
        return this.search((Path)start, (PropertyDescriptionList)props, (int)0, (int)0).rows.iterator();
    }

    public Lookup.PagedResult search(Path start, PropertyDescriptionList props, int offset, int limit) {
        throw new RuntimeException("InMemoryLookup.search(PropertyDescriptionList) - UNIMPLEMENTED start:" + start);
    }

    public RolePath createRole(RolePath role) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        Logger.msg((int)5, (String)("JooqLookupManager.createRole() - role:" + role), (Object[])new Object[0]);
        if (this.exists((Path)role)) {
            throw new ObjectAlreadyExistsException("Role:" + role);
        }
        try {
            role.getParent();
            this.roles.insert(this.context, role, null);
            this.permissions.insert(this.context, role.getStringPath(), role.getPermissionsList());
            return role;
        }
        catch (Throwable t) {
            Logger.error((Throwable)t);
            throw new ObjectCannotBeUpdated("Parent role for '" + role + "' does not exists");
        }
    }

    public void addRole(AgentPath agent, RolePath role) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        if (!this.exists((Path)role)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        if (!this.exists((Path)agent)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            int rows = this.roles.insert(this.context, role, agent);
            if (rows != 1) {
                throw new ObjectCannotBeUpdated("Updated rows must be 1 but it was '" + rows + "'");
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    private SelectQuery<?> getGetAgentsSelect(RolePath role) {
        SelectQuery select = this.context.selectQuery();
        select.addFrom((TableLike)JooqRolePathHandler.ROLE_PATH_TABLE.as("role"));
        select.addJoin((TableLike)JooqItemHandler.ITEM_TABLE.as("item"), JoinType.JOIN, JooqRolePathHandler.AGENT.equal(DSL.field((Name)DSL.name((String[])new String[]{"item", "UUID"}), UUID.class)));
        select.addJoin((TableLike)JooqItemPropertyHandler.ITEM_PROPERTY_TABLE.as("prop"), JoinType.JOIN, JooqRolePathHandler.AGENT.equal(DSL.field((Name)DSL.name((String[])new String[]{"prop", "UUID"}), UUID.class)));
        select.addConditions(Operator.AND, JooqRolePathHandler.PATH.equal((Object)role.getStringPath()));
        select.addConditions(Operator.AND, JooqItemPropertyHandler.NAME.equal((Object)"Name"));
        return select;
    }

    public AgentPath[] getAgents(RolePath role) throws ObjectNotFoundException {
        return this.getAgents((RolePath)role, (int)-1, (int)-1).rows.toArray(new AgentPath[0]);
    }

    public Lookup.PagedResult getAgents(RolePath role, int offset, int limit) throws ObjectNotFoundException {
        int maxRows = -1;
        if (limit > 0) {
            SelectQuery<?> selectCount = this.getGetAgentsSelect(role);
            selectCount.addSelect(new SelectFieldOrAsterisk[]{DSL.count()});
            Logger.msg((int)8, (String)"JooqLookupManager.getAgents(props) - role:%s  SQL(count):\n%s", (Object[])new Object[]{role, selectCount});
            maxRows = (Integer)selectCount.fetchOne(0, Integer.TYPE);
        }
        SelectQuery<?> select = this.getGetAgentsSelect(role);
        select.addSelect(new SelectFieldOrAsterisk[]{DSL.field((Name)DSL.name((String[])new String[]{"item", "UUID"}), UUID.class), JooqItemHandler.IOR, JooqItemHandler.IS_AGENT, JooqItemPropertyHandler.VALUE.as("Name")});
        if (Gateway.getProperties().getBoolean("JOOQ.TemporaryPwdFieldImplemented", true)) {
            select.addSelect(new SelectFieldOrAsterisk[]{JooqItemHandler.IS_PASSWORD_TEMPORARY});
        }
        select.addOrderBy(new OrderField[]{DSL.field((Name)DSL.name((String)"Name"))});
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        Logger.msg((int)8, (String)"JooqLookupManager.getAgents() - role:%s  SQL:\n%s", (Object[])new Object[]{role, select});
        Result result = select.fetch();
        Lookup.PagedResult pResult = new Lookup.PagedResult();
        if (result != null) {
            pResult.maxRows = maxRows;
            for (Record record : result) {
                try {
                    pResult.rows.add(JooqItemHandler.getItemPath(this.context, null, record));
                }
                catch (PersistencyException e) {
                    Logger.error((Throwable)e);
                    throw new ObjectNotFoundException(e.getMessage());
                }
            }
        }
        return pResult;
    }

    public RolePath[] getRoles(AgentPath agent) {
        try {
            return this.roles.findRolesOfAgent(this.context, agent, this.permissions).toArray(new RolePath[0]);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            return new RolePath[0];
        }
    }

    public Lookup.PagedResult getRoles(AgentPath agent, int offset, int limit) {
        try {
            return new Lookup.PagedResult(this.roles.countRolesOfAgent(this.context, agent), this.roles.findRolesOfAgent(this.context, agent, offset, limit, this.permissions));
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            return new Lookup.PagedResult();
        }
    }

    public boolean hasRole(AgentPath agent, RolePath role) {
        try {
            return this.roles.exists(this.context, role, agent);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public void removeRole(AgentPath agent, RolePath role) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        if (!this.exists((Path)role)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        if (!this.exists((Path)agent)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            int rows = this.roles.delete(this.context, role, agent);
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("Role:" + role + " Agent:" + agent + " are not related.");
            }
        }
        catch (Exception e) {
            throw new ObjectCannotBeUpdated("Role:" + role + " Agent:" + agent + " error:" + e.getMessage());
        }
    }

    public void setAgentPassword(AgentPath agent, String newPassword) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException {
        this.setAgentPassword(agent, newPassword, false);
    }

    public void setAgentPassword(AgentPath agent, String newPassword, boolean temporary) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException {
        if (!this.exists((Path)agent)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            int rows = this.items.updatePassword(this.context, agent, this.passwordHasher.hashPassword(newPassword.toCharArray()), temporary);
            if (rows != 1) {
                throw new ObjectCannotBeUpdated("Agent:" + agent);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated("Agent:" + agent + " error:" + e.getMessage());
        }
    }

    public void setHasJobList(RolePath role, boolean hasJobList) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)role)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        role.setHasJobList(hasJobList);
        try {
            this.roles.update(this.context, role);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated("Role:" + role + " error:" + e.getMessage());
        }
    }

    public Iterator<Path> searchAliases(ItemPath itemPath) {
        return this.domains.find(this.context, itemPath).iterator();
    }

    public Lookup.PagedResult searchAliases(ItemPath itemPath, int offset, int limit) {
        return new Lookup.PagedResult(this.domains.countFind(this.context, itemPath), this.domains.find(this.context, itemPath, offset, limit));
    }

    public void setIOR(ItemPath item, String ior) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)item)) {
            throw new ObjectNotFoundException("Item:" + item);
        }
        item.setIORString(ior);
        try {
            this.items.updateIOR(this.context, item, ior);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated("Item:" + item + " error:" + e.getMessage());
        }
    }

    public void setPermission(RolePath role, String permission) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        ArrayList<String> permissions = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)permission)) {
            permissions.add(permission);
        }
        this.setPermissions(role, permissions);
    }

    public void setPermissions(RolePath role, List<String> permissions) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)role)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        role.setPermissions(permissions);
        try {
            if (this.permissions.exists(this.context, role.getStringPath())) {
                this.permissions.delete(this.context, role.getStringPath());
            }
            this.permissions.insert(this.context, role.getStringPath(), role.getPermissionsList());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new ObjectCannotBeUpdated("Role:" + role + " error:" + e.getMessage());
        }
    }

    public void postStartServer() {
    }

    public void postBoostrap() {
    }
}

