/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.auth;

import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.auth.Argon2Password;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.lookup.JooqItemHandler;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(JooqAuthenticator.class);
    DSLContext context = null;
    private JooqItemHandler items;
    private JooqItemPropertyHandler properties;
    private Argon2Password paswordHasher;

    public boolean authenticate(String resource) throws InvalidDataException, ObjectNotFoundException {
        try {
            this.context = JooqHandler.connect();
            this.items = new JooqItemHandler();
            this.properties = new JooqItemPropertyHandler();
            if (!JooqHandler.readOnlyDataSource.booleanValue()) {
                this.items.createTables(this.context);
                this.properties.createTables(this.context);
            }
            this.paswordHasher = new Argon2Password();
            return true;
        }
        catch (PersistencyException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    private UUID getAgentUUID(String agentName) throws ObjectNotFoundException {
        List<UUID> uuids = this.properties.findItemsByName(this.context, agentName);
        if (uuids.size() == 0) {
            throw new ObjectNotFoundException("Could not find agent name:" + agentName);
        }
        if (uuids.size() != 1) {
            throw new ObjectNotFoundException("Ambiguous agent name:" + agentName);
        }
        try {
            ItemPath item = this.items.fetch(this.context, uuids.get(0), this.properties);
            if (item instanceof AgentPath) {
                return item.getUUID();
            }
            throw new ObjectNotFoundException("'" + agentName + " is not an Agent");
        }
        catch (PersistencyException e) {
            throw new ObjectNotFoundException("Could not retrieve agentName:" + agentName + " error:" + e.getMessage());
        }
    }

    public boolean authenticate(String agentName, String password, String resource) throws InvalidDataException, ObjectNotFoundException {
        if (this.context == null && !this.authenticate(resource)) {
            return false;
        }
        try {
            String pwd = this.items.fetchPassword(this.context, this.getAgentUUID(agentName));
            return this.paswordHasher.checkPassword(pwd, password.toCharArray());
        }
        catch (PersistencyException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException("Problem authenticating agent:" + agentName + " error:" + e.getMessage());
        }
    }

    public Object getAuthObject() {
        if (this.context == null) {
            try {
                this.authenticate(null);
            }
            catch (InvalidDataException | ObjectNotFoundException e) {
                log.error("", e);
            }
        }
        return this.context;
    }

    public void disconnect() {
        this.context.close();
    }
}

