/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqOutcomeAttachmentHandler
extends JooqHandler {
    private static final Logger log = LoggerFactory.getLogger(JooqOutcomeAttachmentHandler.class);
    static final Table<?> OUTCOME_ATTACHMENT_TABLE = DSL.table((Name)DSL.name((String)"ATTACHMENT"));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String)"UUID"), UUID.class);
    static final Field<String> SCHEMA_NAME = DSL.field((Name)DSL.name((String)"SCHEMA_NAME"), String.class);
    static final Field<Integer> SCHEMA_VERSION = DSL.field((Name)DSL.name((String)"SCHEMA_VERSION"), Integer.class);
    static final Field<Integer> EVENT_ID = DSL.field((Name)DSL.name((String)"EVENT_ID"), Integer.class);
    static final Field<String> FILE_NAME = DSL.field((Name)DSL.name((String)"FILE_NAME"), String.class);
    static final Field<byte[]> ATTACHMENT = DSL.field((Name)DSL.name((String)"ATTACHMENT"), byte[].class);
    private boolean enableFileName = Gateway.getProperties().getBoolean("JOOQ.OutcomeAttachment.enableFileName", true);

    @Override
    protected Table<?> getTable() {
        return OUTCOME_ATTACHMENT_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        switch (primaryKeys.length) {
            case 0: {
                return SCHEMA_NAME;
            }
            case 1: {
                return SCHEMA_VERSION;
            }
            case 2: {
                return EVENT_ID;
            }
            case 3: {
                return null;
            }
        }
        throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                break;
            }
            case 2: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                conditions.add(SCHEMA_VERSION.equal((Object)Integer.valueOf(primaryKeys[1])));
                break;
            }
            case 3: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(SCHEMA_NAME.equal((Object)primaryKeys[0]));
                conditions.add(SCHEMA_VERSION.equal((Object)Integer.valueOf(primaryKeys[1])));
                conditions.add(EVENT_ID.equal((Object)Integer.valueOf(primaryKeys[2])));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        throw new IllegalArgumentException("OutcomeAttachment must not be updated uuid:" + uuid + " name:" + obj.getName());
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) {
        OutcomeAttachment attachment = (OutcomeAttachment)obj;
        InsertSetMoreStep insert = context.insertInto(OUTCOME_ATTACHMENT_TABLE).set(UUID, (Object)uuid).set(SCHEMA_NAME, (Object)attachment.getSchemaName()).set(SCHEMA_VERSION, (Object)attachment.getSchemaVersion()).set(EVENT_ID, (Object)attachment.getEventId()).set(ATTACHMENT, (Object)attachment.getBinaryData());
        if (this.enableFileName) {
            insert.set(FILE_NAME, (Object)attachment.getFileName());
        }
        return insert.execute();
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            String fileName = null;
            if (this.enableFileName) {
                fileName = (String)result.get(FILE_NAME);
            }
            try {
                Schema schema = LocalObjectLoader.getSchema((String)((String)result.get(SCHEMA_NAME)), (int)((Integer)result.get(SCHEMA_VERSION)));
                byte[] binaryData = (byte[])result.get(ATTACHMENT);
                return new OutcomeAttachment(schema.getItemPath(), schema.getName(), schema.getVersion().intValue(), ((Integer)result.get(EVENT_ID)).intValue(), fileName, binaryData);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) throws PersistencyException {
        CreateTableColumnStep create = context.createTableIfNotExists(OUTCOME_ATTACHMENT_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(SCHEMA_NAME, NAME_TYPE.nullable(false)).column(SCHEMA_VERSION, VERSION_TYPE.nullable(false)).column(EVENT_ID, ID_TYPE.nullable(false)).column(ATTACHMENT, ATTACHMENT_TYPE.nullable(false));
        if (this.enableFileName) {
            create.column(FILE_NAME, NAME_TYPE.nullable(true));
        }
        create.constraints(new Constraint[]{DSL.constraint((String)("PK_" + OUTCOME_ATTACHMENT_TABLE)).primaryKey(new Field[]{UUID, SCHEMA_NAME, SCHEMA_VERSION, EVENT_ID})}).execute();
    }

    @Override
    public void dropTables(DSLContext context) throws PersistencyException {
        context.dropTableIfExists(OUTCOME_ATTACHMENT_TABLE).execute();
    }
}

