/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqPermissionHandler {
    public static final Table<?> ROLE_PERMISSION_TABLE = DSL.table((Name)DSL.name((String)"ROLE_PERMISSION"));
    public static final Field<String> ROLE_PATH = DSL.field((Name)DSL.name((String)"ROLE_PATH"), String.class);
    public static final Field<String> PERMISSION = DSL.field((Name)DSL.name((String)"PERMISSION"), String.class);

    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(ROLE_PERMISSION_TABLE).column(ROLE_PATH, JooqHandler.STRING_TYPE.nullable(false)).column(PERMISSION, JooqHandler.TEXT_TYPE.nullable(true)).execute();
    }

    public void dropTables(DSLContext context) throws PersistencyException {
        context.dropTableIfExists(ROLE_PERMISSION_TABLE).execute();
    }

    public boolean exists(DSLContext context, String role) {
        return context.fetchExists((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from(ROLE_PERMISSION_TABLE).where(ROLE_PATH.equal((Object)role)));
    }

    public int delete(DSLContext context, String role) throws PersistencyException {
        return context.delete(ROLE_PERMISSION_TABLE).where(ROLE_PATH.equal((Object)role)).execute();
    }

    public int insert(DSLContext context, String role, List<String> permissions) {
        InsertQuery insertInto = context.insertQuery(ROLE_PERMISSION_TABLE);
        if (permissions.size() > 0) {
            for (String permission : permissions) {
                insertInto.addValue(ROLE_PATH, (Object)role);
                insertInto.addValue(PERMISSION, (Object)permission);
                insertInto.newRecord();
            }
            return insertInto.execute();
        }
        return 0;
    }

    public List<String> fetch(DSLContext context, String role) {
        Result result = context.select(new SelectFieldOrAsterisk[0]).from(ROLE_PERMISSION_TABLE).where(ROLE_PATH.equal((Object)role)).fetch();
        ArrayList<String> permissions = new ArrayList<String>();
        if (result != null) {
            for (Record record : result) {
                permissions.add((String)record.get(PERMISSION));
            }
        }
        return permissions;
    }
}

