/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionalClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.storage.jooqdb.JooqDomainHandler;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqCollectionHadler;
import org.cristalise.storage.jooqdb.clusterStore.JooqHistoryHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqJobHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqLifecycleHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeAttachmentHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqViewpointHandler;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqClusterStorage
extends TransactionalClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(JooqClusterStorage.class);
    protected HashMap<ClusterType, JooqHandler> jooqHandlers = new HashMap();
    protected List<JooqDomainHandler> domainHandlers = new ArrayList<JooqDomainHandler>();
    protected ConcurrentHashMap<Object, Connection> connectionMap = new ConcurrentHashMap();

    public void open(Authenticator auth) throws PersistencyException {
        this.initialiseHandlers();
    }

    public void initialiseHandlers() throws PersistencyException {
        log.info("initialiseHandlers() - Starting with standard hadlers.");
        this.jooqHandlers.put(ClusterType.PROPERTY, new JooqItemPropertyHandler());
        this.jooqHandlers.put(ClusterType.OUTCOME, new JooqOutcomeHandler());
        this.jooqHandlers.put(ClusterType.VIEWPOINT, new JooqViewpointHandler());
        this.jooqHandlers.put(ClusterType.LIFECYCLE, new JooqLifecycleHandler());
        this.jooqHandlers.put(ClusterType.COLLECTION, new JooqCollectionHadler());
        this.jooqHandlers.put(ClusterType.HISTORY, new JooqHistoryHandler());
        this.jooqHandlers.put(ClusterType.JOB, new JooqJobHandler());
        this.jooqHandlers.put(ClusterType.ATTACHMENT, new JooqOutcomeAttachmentHandler());
        DSLContext context = JooqHandler.connect();
        if (!JooqHandler.readOnlyDataSource.booleanValue()) {
            context.transaction(nested -> {
                for (JooqHandler handler : this.jooqHandlers.values()) {
                    handler.createTables(DSL.using((Configuration)nested));
                }
            });
            this.initialiseDomainHandlers(context);
        }
    }

    private void initialiseDomainHandlers(DSLContext context) throws PersistencyException {
        try {
            String handlers = Gateway.getProperties().getString("JOOQ.domainHandlers", "");
            for (String handlerClass : StringUtils.split((String)handlers, (String)",")) {
                if (!handlerClass.contains(".")) {
                    handlerClass = "org.cristalise.storage." + handlerClass;
                }
                log.info("initialiseHandlers() - Instantiate domain handler:" + handlerClass);
                this.domainHandlers.add((JooqDomainHandler)Class.forName(handlerClass).newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            log.error("JooqClusterStorage could not instantiate domain handler", (Throwable)ex);
            throw new PersistencyException("JooqClusterStorage could not instantiate domain handler:" + ex.getMessage());
        }
        if (!Gateway.getProperties().getBoolean("JOOQ.disableDomainCreateTables", false)) {
            context.transaction(nested -> {
                for (JooqDomainHandler handler : this.domainHandlers) {
                    handler.createTables(DSL.using((Configuration)nested));
                }
            });
        }
    }

    public void dropHandlers() throws PersistencyException {
        DSLContext context = JooqHandler.connect();
        context.transaction(nested -> {
            for (JooqHandler handler : this.jooqHandlers.values()) {
                handler.dropTables(DSL.using((Configuration)nested));
            }
        });
    }

    public void close() throws PersistencyException {
        log.info("close()");
        JooqHandler.closeDataSource();
    }

    public void postBoostrap() throws PersistencyException {
        JooqHandler.connect().transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postBoostrap(DSL.using((Configuration)nested));
            }
        });
        if (!JooqHandler.readOnlyDataSource.booleanValue() && !JooqHandler.autoCommit.booleanValue()) {
            JooqHandler.recreateDataSource(JooqHandler.autoCommit);
        }
    }

    public void postStartServer() throws PersistencyException {
        JooqHandler.connect().transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postStartServer(DSL.using((Configuration)nested));
            }
        });
    }

    public void postConnect() throws PersistencyException {
        if (!JooqHandler.readOnlyDataSource.booleanValue() && !JooqHandler.autoCommit.booleanValue()) {
            JooqHandler.recreateDataSource(true);
        }
        JooqHandler.connect().transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postConnect(DSL.using((Configuration)nested));
            }
        });
    }

    public void begin(Object locker) throws PersistencyException {
        if (!JooqHandler.getDataSource().isAutoCommit() && locker == null) {
            throw new PersistencyException("locker cannot be null when autoCommit is false");
        }
        Connection conn = JooqHandler.connect().configuration().connectionProvider().acquire();
        if (locker != null) {
            this.connectionMap.put(locker, conn);
        } else {
            log.warn("begin() called with a null locker");
        }
    }

    private DSLContext retrieveContext(Object locker) throws PersistencyException {
        if (JooqHandler.getDataSource().isAutoCommit()) {
            return JooqHandler.connect();
        }
        return JooqHandler.connect(this.connectionMap.get(locker));
    }

    public void commit(Object locker) throws PersistencyException {
        if (!JooqHandler.getDataSource().isAutoCommit() && locker == null) {
            throw new PersistencyException("locker cannot be null when autoCommit is false");
        }
        DSLContext context = this.retrieveContext(locker);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.commit(context, locker);
        }
        if (locker == null) {
            log.warn("commit() Cannot retrieve connection because locker is null");
            return;
        }
        log.info("commit()");
        try {
            Connection conn = this.connectionMap.remove(locker);
            if (!JooqHandler.getDataSource().isAutoCommit()) {
                conn.commit();
            }
            conn.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public void abort(Object locker) throws PersistencyException {
        if (!JooqHandler.getDataSource().isAutoCommit() && locker == null) {
            throw new PersistencyException("locker cannot be null when autoCommit is false");
        }
        DSLContext context = this.retrieveContext(locker);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.abort(context, locker);
        }
        if (locker == null) {
            log.warn("abort() Cannot retrieve connection because locker is null");
            return;
        }
        log.info("abort()");
        try {
            Connection conn = this.connectionMap.remove(locker);
            if (!JooqHandler.getDataSource().isAutoCommit()) {
                conn.rollback();
            }
            conn.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public short queryClusterSupport(String type) {
        return this.queryClusterSupport(ClusterType.getValue((String)type));
    }

    public short queryClusterSupport(ClusterType type) {
        if (type == ClusterType.PATH) {
            return 0;
        }
        return 3;
    }

    public boolean checkQuerySupport(String language) {
        String lang = language.trim().toUpperCase();
        return "SQL".equals(lang) || ("SQL:" + JooqHandler.dialect).equals(lang);
    }

    public String getName() {
        return "JOOQ:" + JooqHandler.dialect + " ClusterStorage";
    }

    public String getId() {
        return "JOOQ:" + JooqHandler.dialect;
    }

    public int getLastIntegerId(ItemPath itemPath, String path) throws PersistencyException {
        String[] pathArray = path.split("/");
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler == null) {
            throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
        }
        if (cluster == ClusterType.HISTORY) {
            return ((JooqHistoryHandler)handler).getLastEventId(JooqHandler.connect(), itemPath.getUUID());
        }
        if (cluster == ClusterType.JOB) {
            return ((JooqJobHandler)handler).getLastJobId(JooqHandler.connect(), itemPath.getUUID());
        }
        String msg = "Invalid ClusterType! Must be either HISTORY or JOB. Actual cluster:" + cluster;
        log.error("getLastIntegerId() - {}", (Object)msg);
        throw new PersistencyException(msg);
    }

    public String executeQuery(Query query) throws PersistencyException {
        throw new PersistencyException("UnImplemented");
    }

    public ClusterType[] getClusters(ItemPath itemPath) throws PersistencyException {
        ArrayList<ClusterType> result = new ArrayList<ClusterType>();
        for (ClusterType type : this.jooqHandlers.keySet()) {
            if (!this.jooqHandlers.get(type).exists(JooqHandler.connect(), itemPath.getUUID())) continue;
            result.add(type);
        }
        return result.toArray(new ClusterType[0]);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        if (StringUtils.isBlank((CharSequence)path)) {
            ArrayList<String> result = new ArrayList<String>();
            for (ClusterType k : this.getClusters(itemPath)) {
                result.add(k.toString());
            }
            return result.toArray(new String[0]);
        }
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler != null) {
            log.debug("getClusterContents() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys));
            return handler.getNextPrimaryKeys(JooqHandler.connect(), uuid, (String[])primaryKeys);
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException {
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler != null) {
            log.debug("get() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys:" + Arrays.toString(primaryKeys));
            C2KLocalObject obj = handler.fetch(JooqHandler.connect(), uuid, (String[])primaryKeys);
            if (obj == null) {
                log.trace("JooqClusterStorage.get() - Could NOT fetch '" + itemPath + "/" + path + "'");
            }
            return obj;
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        this.put(itemPath, obj, null);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        if (!JooqHandler.getDataSource().isAutoCommit() && locker == null) {
            throw new PersistencyException("locker cannot be null when autoCommit is false");
        }
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = obj.getClusterType();
        JooqHandler handler = this.jooqHandlers.get(cluster);
        DSLContext context = this.retrieveContext(locker);
        JooqHandler.logConnectionCount("JooqClusterStorage.put(before)", context);
        if (handler == null) {
            throw new PersistencyException("Write is not supported for cluster:'" + cluster + "'");
        }
        log.debug("put() - uuid:" + uuid + " cluster:" + cluster + " path:" + obj.getClusterPath());
        handler.put(context, uuid, obj);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.put(context, uuid, obj, locker);
        }
        JooqHandler.logConnectionCount("JooqClusterStorage.put(after) ", context);
    }

    public void delete(ItemPath itemPath, String path) throws PersistencyException {
        this.delete(itemPath, path, null);
    }

    public void delete(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        if (!JooqHandler.getDataSource().isAutoCommit() && locker == null) {
            throw new PersistencyException("locker cannot be null when autoCommit is false");
        }
        UUID uuid = itemPath.getUUID();
        String[] pathArray = path.split("/");
        Object[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        ClusterType cluster = ClusterType.getValue((String)pathArray[0]);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        DSLContext context = this.retrieveContext(locker);
        if (handler == null) {
            throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
        }
        log.debug("delete() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys));
        handler.delete(context, uuid, (String[])primaryKeys);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.delete(context, uuid, locker, (String[])primaryKeys);
        }
    }
}

