/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.process.Gateway;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JooqHandler {
    private static final Logger log = LoggerFactory.getLogger(JooqHandler.class);
    public static final String JOOQ_URI = "JOOQ.URI";
    public static final String JOOQ_USER = "JOOQ.user";
    public static final String JOOQ_PASSWORD = "JOOQ.password";
    public static final String JOOQ_DIALECT = "JOOQ.dialect";
    public static final String JOOQ_AUTOCOMMIT = "JOOQ.autoCommit";
    public static final String JOOQ_READONLYDATASOURCE = "JOOQ.readOnlyDataSource";
    public static final String JOOQ_DOMAIN_HANDLERS = "JOOQ.domainHandlers";
    public static final String JOOQ_DISABLE_DOMAIN_CREATE = "JOOQ.disableDomainCreateTables";
    public static final String JOOQ_NAME_TYPE_LENGHT = "JOOQ.NameType.length";
    public static final String JOOQ_PASSWORD_TYPE_LENGHT = "JOOQ.PasswordType.length";
    public static final String JOOQ_STRING_TYPE_LENGHT = "JOOQ.StringType.length";
    public static final String JOOQ_TEXT_TYPE_LENGHT = "JOOQ.TextType.length";
    public static final DataType<UUID> UUID_TYPE = SQLDataType.UUID;
    public static final DataType<String> NAME_TYPE = SQLDataType.VARCHAR.length(Gateway.getProperties().getInt("JOOQ.NameType.length", 64));
    public static final DataType<Integer> VERSION_TYPE = SQLDataType.INTEGER;
    public static final DataType<String> PASSWORD_TYPE = SQLDataType.VARCHAR.length(Gateway.getProperties().getInt("JOOQ.PasswordType.length", 800));
    public static final DataType<String> STRING_TYPE = SQLDataType.VARCHAR.length(Gateway.getProperties().getInt("JOOQ.StringType.length", 800));
    public static final DataType<String> TEXT_TYPE = SQLDataType.VARCHAR.length(Gateway.getProperties().getInt("JOOQ.TextType.length", 800));
    public static final DataType<String> IOR_TYPE = SQLDataType.VARCHAR.length(800);
    public static final DataType<Integer> ID_TYPE = SQLDataType.INTEGER;
    public static final DataType<Timestamp> TIMESTAMP_TYPE = SQLDataType.TIMESTAMP;
    public static final DataType<String> XML_TYPE = SQLDataType.CLOB;
    public static final DataType<String> XML_TYPE_MYSQL = new DefaultDataType(SQLDialect.MYSQL, SQLDataType.CLOB, "mediumtext", "char");
    public static final DataType<byte[]> ATTACHMENT_TYPE = SQLDataType.BLOB;
    public static final String uri = Gateway.getProperties().getString("JOOQ.URI");
    public static final String user = Gateway.getProperties().getString("JOOQ.user");
    public static final String pwd = Gateway.getProperties().getString("JOOQ.password");
    public static final Boolean autoCommit = Gateway.getProperties().getBoolean("JOOQ.autoCommit", false);
    public static final Boolean readOnlyDataSource = Gateway.getProperties().getBoolean("JOOQ.readOnlyDataSource", false);
    public static final SQLDialect dialect = SQLDialect.valueOf((String)Gateway.getProperties().getString("JOOQ.dialect", "POSTGRES"));
    private static HikariDataSource ds = null;
    private static HikariConfig config;

    public static synchronized HikariDataSource getDataSource() {
        if (ds == null) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{uri, user, pwd})) {
                throw new IllegalArgumentException("JOOQ (uri, user, password) config values must not be blank");
            }
            config = new HikariConfig();
            config.setPoolName("CRISTAL-iSE-HikariCP");
            config.setRegisterMbeans(true);
            config.setJdbcUrl(uri);
            config.setUsername(user);
            config.setPassword(pwd);
            config.setAutoCommit(autoCommit.booleanValue());
            config.setReadOnly(readOnlyDataSource.booleanValue());
            config.setMaximumPoolSize(50);
            config.setMaxLifetime(60000L);
            config.setMinimumIdle(10);
            config.setIdleTimeout(30000L);
            config.addDataSourceProperty("cachePrepStmts", (Object)true);
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            config.addDataSourceProperty("autoCommit", (Object)autoCommit);
            log.info("getDataSource() - uri:'{}' user:'{}' dialect:'{}'", new Object[]{uri, user, dialect});
            config.setAutoCommit(autoCommit.booleanValue());
            ds = new HikariDataSource(config);
            log.info("getDataSource() create datasource {}", (Object)ds);
        }
        return ds;
    }

    public static synchronized void recreateDataSource(boolean forcedAutoCommit) throws PersistencyException {
        HikariDataSource newDs;
        if (ds == null) {
            throw new PersistencyException("Cannot recreate a null data source");
        }
        log.info("recreateDataSource() autocommit={}", (Object)forcedAutoCommit);
        HikariConfig config = new HikariConfig();
        ds.copyStateTo(config);
        config.setAutoCommit(forcedAutoCommit);
        config.addDataSourceProperty("autoCommit", (Object)forcedAutoCommit);
        JooqHandler.closeDataSource();
        ds = newDs = new HikariDataSource(config);
    }

    public static synchronized void closeDataSource() throws PersistencyException {
        try {
            if (ds != null) {
                HikariPoolMXBean poolBean = ds.getHikariPoolMXBean();
                log.debug("closeDataSource() active connections={}", (Object)poolBean.getActiveConnections());
                while (poolBean.getActiveConnections() > 0) {
                    poolBean.softEvictConnections();
                }
                ds.close();
                ds = null;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public static DSLContext connect() throws PersistencyException {
        try {
            return DSL.using((DataSource)JooqHandler.getDataSource(), (SQLDialect)dialect);
        }
        catch (Exception ex) {
            log.error("JooqHandler could not connect to URI '" + uri + "' with user '" + user + "'", (Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
    }

    public static DSLContext connect(Connection conn) throws PersistencyException {
        try {
            return DSL.using((Connection)conn);
        }
        catch (Exception ex) {
            log.error("JooqHandler could not connect to URI '" + uri + "' with user '" + user + "'", (Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
    }

    protected abstract Table<?> getTable();

    protected abstract Field<?> getNextPKField(String ... var1) throws PersistencyException;

    protected abstract List<Condition> getPKConditions(UUID var1, String ... var2) throws PersistencyException;

    protected Record fetchRecord(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.select(new SelectFieldOrAsterisk[0]).from(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).fetchOne();
    }

    protected Result<?> fetchDistinctResult(DSLContext context, Field<?> field, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.selectDistinct(field).from(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).fetch();
    }

    protected List<Condition> getPKConditions(UUID uuid, C2KLocalObject obj) throws PersistencyException {
        String[] pathArray = obj.getClusterPath().split("/");
        String[] primaryKeys = Arrays.copyOfRange(pathArray, 1, pathArray.length);
        return this.getPKConditions(uuid, primaryKeys);
    }

    public int put(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        if (this.exists(context, uuid, obj)) {
            return this.update(context, uuid, obj);
        }
        return this.insert(context, uuid, obj);
    }

    public int delete(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        return context.delete(this.getTable()).where(this.getPKConditions(uuid, primaryKeys)).execute();
    }

    public String[] getNextPrimaryKeys(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Field<?> field = this.getNextPKField(primaryKeys);
        if (field == null) {
            return new String[0];
        }
        Result<?> result = this.fetchDistinctResult(context, field, uuid, primaryKeys);
        String[] returnValue = new String[result.size()];
        int i = 0;
        for (Record rec : result) {
            returnValue[i++] = rec.get(0).toString();
        }
        return returnValue;
    }

    public boolean exists(DSLContext context, UUID uuid) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from(this.getTable()).where(this.getPKConditions(uuid, new String[0])));
    }

    public boolean exists(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from(this.getTable()).where(this.getPKConditions(uuid, obj)));
    }

    protected UUID getUUID(Record record, Field<UUID> field) {
        if (record.get(field.getName()) instanceof String) {
            return UUID.fromString((String)record.get(field.getName(), String.class));
        }
        return (UUID)record.get(field);
    }

    protected DataType<String> getXMLType(DSLContext context) {
        if (context.dialect().equals((Object)SQLDialect.MYSQL)) {
            return XML_TYPE_MYSQL;
        }
        return XML_TYPE;
    }

    public abstract void createTables(DSLContext var1) throws PersistencyException;

    public abstract void dropTables(DSLContext var1) throws PersistencyException;

    public abstract int update(DSLContext var1, UUID var2, C2KLocalObject var3) throws PersistencyException;

    public abstract int insert(DSLContext var1, UUID var2, C2KLocalObject var3) throws PersistencyException;

    public abstract C2KLocalObject fetch(DSLContext var1, UUID var2, String ... var3) throws PersistencyException;

    public static void logConnectionCount(String text, DSLContext context) {
        if (context.dialect().equals((Object)SQLDialect.POSTGRES)) {
            Record rec = context.fetchOne("SELECT sum(numbackends) FROM pg_stat_database;");
            log.trace("{} ------- Number of POSTGRES connections:{}", (Object)text, rec.get(0, Integer.class));
        } else if (context.dialect().equals((Object)SQLDialect.MYSQL)) {
            Record rec = context.fetchOne("SHOW STATUS WHERE `variable_name` = 'Threads_connected';");
            log.trace("{} ------- Number of MSQL connections:{}", (Object)text, rec.get(1, String.class));
        } else {
            log.trace("{} ------- Printing number of connections not supported for dialect:{}", (Object)text, (Object)context.dialect());
        }
    }
}

