/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.clusterStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqLifecycleHandler
extends JooqHandler {
    private static final Logger log = LoggerFactory.getLogger(JooqLifecycleHandler.class);
    static final Table<?> LIFECYCLE_TABLE = DSL.table((Name)DSL.name((String)"LIFECYCLE"));
    static final Field<UUID> UUID = DSL.field((Name)DSL.name((String)"UUID"), UUID.class);
    static final Field<String> NAME = DSL.field((Name)DSL.name((String)"NAME"), String.class);
    static final Field<String> XML = DSL.field((Name)DSL.name((String)"XML"), String.class);

    @Override
    protected Table<?> getTable() {
        return LIFECYCLE_TABLE;
    }

    @Override
    protected Field<?> getNextPKField(String ... primaryKeys) throws PersistencyException {
        if (primaryKeys.length == 0) {
            return NAME;
        }
        return null;
    }

    @Override
    protected List<Condition> getPKConditions(UUID uuid, String ... primaryKeys) throws PersistencyException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (primaryKeys.length) {
            case 0: {
                conditions.add(UUID.equal((Object)uuid));
                break;
            }
            case 1: {
                conditions.add(UUID.equal((Object)uuid));
                conditions.add(NAME.equal((Object)primaryKeys[0]));
                break;
            }
            default: {
                throw new PersistencyException("Invalid number of primary keys:" + Arrays.toString(primaryKeys));
            }
        }
        return conditions;
    }

    @Override
    public int update(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        try {
            return context.update(LIFECYCLE_TABLE).set(NAME, (Object)obj.getName()).set(XML, (Object)Gateway.getMarshaller().marshall((Object)obj)).where(UUID.equal((Object)uuid)).execute();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    @Override
    public int insert(DSLContext context, UUID uuid, C2KLocalObject obj) throws PersistencyException {
        try {
            return context.insertInto(LIFECYCLE_TABLE).set(UUID, (Object)uuid).set(NAME, (Object)obj.getName()).set(XML, (Object)Gateway.getMarshaller().marshall((Object)obj)).execute();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    @Override
    public C2KLocalObject fetch(DSLContext context, UUID uuid, String ... primaryKeys) throws PersistencyException {
        Record result = this.fetchRecord(context, uuid, primaryKeys);
        if (result != null) {
            try {
                String xml = (String)result.get(XML);
                return (C2KLocalObject)Gateway.getMarshaller().unmarshall(xml);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void createTables(DSLContext context) {
        DataType<String> xmlType = this.getXMLType(context);
        context.createTableIfNotExists(LIFECYCLE_TABLE).column(UUID, UUID_TYPE.nullable(false)).column(NAME, NAME_TYPE.nullable(false)).column(XML, xmlType.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + LIFECYCLE_TABLE)).primaryKey(new Field[]{UUID, NAME})}).execute();
    }

    @Override
    public void dropTables(DSLContext context) throws PersistencyException {
        context.dropTableIfExists(LIFECYCLE_TABLE).execute();
    }
}

