/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.lookup.JooqItemHandler;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqDomainPathHandler {
    private static final Logger log = LoggerFactory.getLogger(JooqDomainPathHandler.class);
    public static final Table<?> DOMAIN_PATH_TABLE = DSL.table((Name)DSL.name((String)"DOMAIN_PATH"));
    public static final Field<String> PATH = DSL.field((Name)DSL.name((String)"PATH"), String.class);
    public static final Field<UUID> TARGET = DSL.field((Name)DSL.name((String)"TARGET"), UUID.class);

    public void createTables(DSLContext context) throws PersistencyException {
        context.createTableIfNotExists(DOMAIN_PATH_TABLE).column(PATH, JooqHandler.STRING_TYPE.nullable(false)).column(TARGET, JooqHandler.UUID_TYPE.nullable(true)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + DOMAIN_PATH_TABLE)).primaryKey(new Field[]{PATH}), DSL.constraint((String)("FK_" + DOMAIN_PATH_TABLE)).foreignKey(TARGET).references(JooqItemHandler.ITEM_TABLE, JooqItemHandler.UUID)}).execute();
    }

    public void dropTables(DSLContext context) throws PersistencyException {
        context.dropTableIfExists(DOMAIN_PATH_TABLE).execute();
    }

    private DomainPath getDomainPath(Record record) {
        UUID uuid = record.get(TARGET.getName()) instanceof String ? UUID.fromString((String)record.get(TARGET.getName(), String.class)) : (UUID)record.get(TARGET);
        if (uuid == null) {
            return new DomainPath((String)record.get(PATH));
        }
        return new DomainPath((String)record.get(PATH), new ItemPath(uuid));
    }

    public List<Path> getListOfPath(Result<?> result) {
        ArrayList<Path> foundPathes = new ArrayList<Path>();
        if (result != null) {
            for (Record record : result) {
                foundPathes.add((Path)this.getDomainPath(record));
            }
        }
        return foundPathes;
    }

    public int delete(DSLContext context, String path) throws PersistencyException {
        return context.delete(DOMAIN_PATH_TABLE).where(PATH.equal((Object)path)).execute();
    }

    public int insert(DSLContext context, DomainPath path) throws PersistencyException {
        InsertQuery insertInto = context.insertQuery(DOMAIN_PATH_TABLE);
        DomainPath root = new DomainPath();
        if (!this.exists(context, root)) {
            insertInto.addValue(PATH, (Object)root.getStringPath());
            insertInto.addValue(TARGET, (Object)null);
            insertInto.newRecord();
        }
        StringBuffer newPath = new StringBuffer("/" + path.getRoot());
        for (String name : path.getPath()) {
            newPath.append("/" + name);
            if (this.exists(context, new DomainPath(newPath.toString()))) continue;
            insertInto.addValue(PATH, (Object)newPath.toString());
            if (path.getStringPath().equals(newPath.toString())) {
                insertInto.addValue(TARGET, path.getTarget() == null ? null : path.getTarget().getUUID());
            } else {
                insertInto.addValue(TARGET, (Object)null);
            }
            insertInto.newRecord();
        }
        log.debug("JooqDomainPathHandler.insert() - SQL:\n" + insertInto.toString());
        return insertInto.execute();
    }

    public boolean exists(DSLContext context, DomainPath path) throws PersistencyException {
        return context.fetchExists((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where(PATH.equal((Object)path.getStringPath())));
    }

    public DomainPath fetch(DSLContext context, DomainPath path) throws PersistencyException {
        Record result = context.select(new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where(PATH.equal((Object)path.getStringPath())).fetchOne();
        return this.getDomainPath(result);
    }

    public int countByRegex(DSLContext context, String pattern) {
        return (Integer)context.selectCount().from(DOMAIN_PATH_TABLE).where(PATH.likeRegex(pattern)).fetchOne(0, Integer.TYPE);
    }

    public List<Path> findByRegex(DSLContext context, String pattern) {
        Result result = context.select(new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where(PATH.likeRegex(pattern)).fetch();
        return this.getListOfPath(result);
    }

    public List<Path> findByRegex(DSLContext context, String pattern, int offset, int limit) {
        Result result = context.select(new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where(PATH.likeRegex(pattern)).orderBy(PATH).limit(limit).offset(offset).fetch();
        return this.getListOfPath(result);
    }

    public String getFindPattern(Path startPath, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return startPath.getStringPath() + "%";
        }
        return startPath.getStringPath() + "/%" + name;
    }

    public List<Path> find(DSLContext context, DomainPath startPath, String name, List<UUID> uuids) {
        String pattern = this.getFindPattern((Path)startPath, name);
        SelectConditionStep select = context.select(new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where((Condition)PATH.like(pattern));
        if (uuids != null && uuids.size() != 0) {
            select.and(TARGET.in(uuids));
        }
        log.debug("JooqDomainPathHandler.find() - SQL:\n" + select);
        return this.getListOfPath(select.fetch());
    }

    public List<Path> find(DSLContext context, ItemPath item) {
        return this.find(context, item, -1, -1);
    }

    public int countFind(DSLContext context, ItemPath item) {
        return (Integer)context.selectCount().from(DOMAIN_PATH_TABLE).where(TARGET.equal((Object)item.getUUID())).fetchOne(0, Integer.TYPE);
    }

    public List<Path> find(DSLContext context, ItemPath item, int offset, int limit) {
        SelectConditionStep select = context.select(new SelectFieldOrAsterisk[0]).from(DOMAIN_PATH_TABLE).where(TARGET.equal((Object)item.getUUID()));
        if (limit > 0) {
            select.limit(limit);
        }
        if (offset > 0) {
            select.offset(offset);
        }
        return this.getListOfPath(select.fetch());
    }
}

