/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.auth;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;

public class Argon2Password {
    private Argon2 argon2 = null;
    private final Argon2Factory.Argon2Types type = Argon2Factory.Argon2Types.ARGON2i;
    private final int saltLenght;
    private final int hashLenght;
    private final int iterations;
    private final int memory;
    private final int parallelism;

    public Argon2Password() {
        this.saltLenght = 16;
        this.hashLenght = 32;
        this.argon2 = Argon2Factory.create((Argon2Factory.Argon2Types)this.type, (int)this.saltLenght, (int)this.hashLenght);
        this.iterations = 2;
        this.memory = 65536;
        this.parallelism = 1;
    }

    public boolean checkPassword(String hash, char[] password) {
        return this.argon2.verify(hash, password);
    }

    public String hashPassword(char[] password) {
        try {
            String string = this.argon2.hash(this.iterations, this.memory, this.parallelism, password);
            return string;
        }
        finally {
            this.argon2.wipeArray(password);
        }
    }
}

