/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.auth;

import org.apache.shiro.authc.credential.PasswordService;
import org.cristalise.storage.jooqdb.auth.Argon2Password;

public class Argon2PasswordService
implements PasswordService {
    private Argon2Password paswordHasher = new Argon2Password();

    public String encryptPassword(Object plaintextPassword) throws IllegalArgumentException {
        if (plaintextPassword instanceof char[]) {
            return this.paswordHasher.hashPassword((char[])plaintextPassword);
        }
        if (plaintextPassword instanceof String) {
            return this.paswordHasher.hashPassword(((String)plaintextPassword).toCharArray());
        }
        throw new IllegalArgumentException("Unsupported password type: " + plaintextPassword.getClass().getName());
    }

    public boolean passwordsMatch(Object submittedPlaintext, String encrypted) {
        return this.paswordHasher.checkPassword(encrypted, (char[])submittedPlaintext);
    }
}

