/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqDataSourceHandler {
    private static final Logger log = LoggerFactory.getLogger(JooqDataSourceHandler.class);
    private static final ConcurrentHashMap<Object, Connection> connectionMap = new ConcurrentHashMap();
    public static final String JOOQ_URI = "JOOQ.URI";
    public static final String JOOQ_USER = "JOOQ.user";
    public static final String JOOQ_PASSWORD = "JOOQ.password";
    public static final String JOOQ_DIALECT = "JOOQ.dialect";
    public static final String JOOQ_AUTOCOMMIT = "JOOQ.autoCommit";
    public static final String JOOQ_READONLYDATASOURCE = "JOOQ.readOnlyDataSource";
    public static final String JOOQ_ASSUMEMINSERVERVERSION = "JOOQ.PostgreSQL.assumeMinServerVersion";
    public static String uri;
    public static String user;
    public static String pwd;
    public static Boolean autoCommit;
    public static Boolean readOnlyDataSource;
    public static SQLDialect dialect;
    public static String assumeMinServerVersion;
    private static HikariDataSource ds;
    private static HikariConfig config;

    public static void readSystemProperties() {
        uri = Gateway.getProperties().getString(JOOQ_URI);
        user = Gateway.getProperties().getString(JOOQ_USER);
        pwd = Gateway.getProperties().getString(JOOQ_PASSWORD);
        autoCommit = Gateway.getProperties().getBoolean(JOOQ_AUTOCOMMIT, false);
        readOnlyDataSource = Gateway.getProperties().getBoolean(JOOQ_READONLYDATASOURCE, false);
        dialect = SQLDialect.valueOf((String)Gateway.getProperties().getString(JOOQ_DIALECT, "POSTGRES"));
        assumeMinServerVersion = Gateway.getProperties().getString(JOOQ_ASSUMEMINSERVERVERSION);
    }

    public static synchronized HikariDataSource getDataSource() {
        if (ds == null) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{uri, user, pwd})) {
                JooqDataSourceHandler.readSystemProperties();
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{uri, user, pwd})) {
                    throw new IllegalArgumentException("JOOQ (uri, user, password) config values must not be blank");
                }
            }
            config = new HikariConfig();
            config.setPoolName("CRISTAL-iSE-HikariCP");
            config.setRegisterMbeans(true);
            config.setJdbcUrl(uri);
            config.setUsername(user);
            config.setPassword(pwd);
            config.setAutoCommit(autoCommit.booleanValue());
            config.setReadOnly(readOnlyDataSource.booleanValue());
            config.setMaximumPoolSize(50);
            config.setMaxLifetime(60000L);
            config.setMinimumIdle(10);
            config.setIdleTimeout(30000L);
            config.addDataSourceProperty("cachePrepStmts", (Object)true);
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            config.addDataSourceProperty("autoCommit", (Object)autoCommit);
            if (assumeMinServerVersion != null) {
                config.addDataSourceProperty("assumeMinServerVersion", (Object)assumeMinServerVersion);
            }
            log.info("getDataSource() - uri:'{}' user:'{}' dialect:'{}'", new Object[]{uri, user, dialect});
            ds = new HikariDataSource(config);
            log.info("getDataSource() - create datasource {}", (Object)ds);
        }
        return ds;
    }

    public static synchronized void closeDataSource() throws PersistencyException {
        try {
            if (ds != null) {
                HikariPoolMXBean poolBean = ds.getHikariPoolMXBean();
                log.debug("closeDataSource() - active connections={}", (Object)poolBean.getActiveConnections());
                while (poolBean.getActiveConnections() > 0) {
                    poolBean.softEvictConnections();
                }
                ds.close();
                ds = null;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public static DSLContext connect() throws PersistencyException {
        try {
            return DSL.using((DataSource)JooqDataSourceHandler.getDataSource(), (SQLDialect)dialect);
        }
        catch (Exception ex) {
            log.error("Could not connect to URI '" + uri + "' with user '" + user + "'", (Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
    }

    public static DSLContext connect(Connection conn) throws PersistencyException {
        try {
            return DSL.using((Connection)conn);
        }
        catch (Exception ex) {
            log.error("Could not connect to URI '" + uri + "' with user '" + user + "'", (Throwable)ex);
            throw new PersistencyException(ex.getMessage());
        }
    }

    public static Connection createConnection(TransactionKey transactionKey) throws PersistencyException {
        if (!JooqDataSourceHandler.getDataSource().isAutoCommit() && transactionKey == null) {
            throw new PersistencyException("transactionKey cannot be null when autoCommit is false");
        }
        log.debug("createConnection() - transactionKey:{}", (Object)transactionKey);
        if (transactionKey != null) {
            Connection conn = JooqDataSourceHandler.connect().configuration().connectionProvider().acquire();
            connectionMap.put(transactionKey, conn);
            return conn;
        }
        log.warn("createConnection() - called with a null transactionKey");
        return null;
    }

    public static Connection removeConnection(TransactionKey transactionKey) throws PersistencyException {
        if (!JooqDataSourceHandler.getDataSource().isAutoCommit() && transactionKey == null) {
            throw new PersistencyException("transactionKey cannot be null when autoCommit is false");
        }
        if (transactionKey == null) {
            log.warn("removeConnection() - Cannot retrieve connection because transactionKey is null");
            return null;
        }
        log.debug("removeConnection() - transactionKey:{}", (Object)transactionKey);
        return connectionMap.remove(transactionKey);
    }

    public static DSLContext retrieveContext(TransactionKey transactionKey) throws PersistencyException {
        log.trace("retrieveContext() - transactionKey:{}", (Object)transactionKey);
        if (JooqDataSourceHandler.getDataSource().isAutoCommit() || transactionKey == null) {
            return JooqDataSourceHandler.connect();
        }
        Connection conn = connectionMap.get(transactionKey);
        if (conn != null) {
            return JooqDataSourceHandler.connect(conn);
        }
        String msg = "Could not find JDBC connection for transactionKey:" + transactionKey;
        log.error("retrieveContext() - {}", (Object)msg);
        throw new PersistencyException(msg);
    }

    public static void logConnectionCount(String text, DSLContext context) {
        if (context.dialect().equals((Object)SQLDialect.POSTGRES)) {
            Record rec = context.fetchOne("SELECT sum(numbackends) FROM pg_stat_database;");
            log.trace("{} ------- Number of POSTGRES connections:{}", (Object)text, rec.get(0, Integer.class));
        } else if (context.dialect().equals((Object)SQLDialect.MYSQL)) {
            Record rec = context.fetchOne("SHOW STATUS WHERE `variable_name` = 'Threads_connected';");
            log.trace("{} ------- Number of MSQL connections:{}", (Object)text, rec.get(1, String.class));
        } else {
            log.trace("{} ------- Printing number of connections not supported for dialect:{}", (Object)text, (Object)context.dialect());
        }
    }

    static {
        ds = null;
    }
}

