/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.storage.jooqdb.JooqDataSourceHandler;
import org.cristalise.storage.jooqdb.JooqDomainHandler;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqCollectionHadler;
import org.cristalise.storage.jooqdb.clusterStore.JooqHistoryHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqJobHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqLifecycleHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeAttachmentHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqOutcomeHandler;
import org.cristalise.storage.jooqdb.clusterStore.JooqViewpointHandler;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqClusterStorage
extends ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(JooqClusterStorage.class);
    protected HashMap<ClusterType, JooqHandler> jooqHandlers = new HashMap();
    protected List<JooqDomainHandler> domainHandlers = new ArrayList<JooqDomainHandler>();

    public void open(Authenticator auth) throws PersistencyException {
        JooqDataSourceHandler.readSystemProperties();
        this.initialiseHandlers();
    }

    public void initialiseHandlers() throws PersistencyException {
        log.info("initialiseHandlers() - Starting with standard hadlers.");
        this.jooqHandlers.put(ClusterType.PROPERTY, new JooqItemPropertyHandler());
        this.jooqHandlers.put(ClusterType.OUTCOME, new JooqOutcomeHandler());
        this.jooqHandlers.put(ClusterType.VIEWPOINT, new JooqViewpointHandler());
        this.jooqHandlers.put(ClusterType.LIFECYCLE, new JooqLifecycleHandler());
        this.jooqHandlers.put(ClusterType.COLLECTION, new JooqCollectionHadler());
        this.jooqHandlers.put(ClusterType.HISTORY, new JooqHistoryHandler());
        this.jooqHandlers.put(ClusterType.JOB, new JooqJobHandler());
        this.jooqHandlers.put(ClusterType.ATTACHMENT, new JooqOutcomeAttachmentHandler());
        DSLContext context = JooqDataSourceHandler.retrieveContext(null);
        if (!JooqDataSourceHandler.readOnlyDataSource.booleanValue()) {
            context.transaction(nested -> {
                for (JooqHandler handler : this.jooqHandlers.values()) {
                    handler.createTables(DSL.using((Configuration)nested));
                }
            });
            this.initialiseDomainHandlers(context);
        }
    }

    private void initialiseDomainHandlers(DSLContext context) throws PersistencyException {
        try {
            String handlers = Gateway.getProperties().getString("JOOQ.domainHandlers", "");
            for (String handlerClass : StringUtils.split((String)handlers, (String)",")) {
                if (!handlerClass.contains(".")) {
                    handlerClass = "org.cristalise.storage." + handlerClass;
                }
                log.info("initialiseHandlers() - Instantiate domain handler:" + handlerClass);
                this.domainHandlers.add((JooqDomainHandler)Class.forName(handlerClass).newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            log.error("JooqClusterStorage could not instantiate domain handler", (Throwable)ex);
            throw new PersistencyException("JooqClusterStorage could not instantiate domain handler:" + ex.getMessage());
        }
        if (!Gateway.getProperties().getBoolean("JOOQ.disableDomainCreateTables", false)) {
            context.transaction(nested -> {
                for (JooqDomainHandler handler : this.domainHandlers) {
                    handler.createTables(DSL.using((Configuration)nested));
                }
            });
        }
    }

    public void dropHandlers() throws PersistencyException {
        DSLContext context = JooqDataSourceHandler.retrieveContext(null);
        context.transaction(nested -> {
            for (JooqHandler handler : this.jooqHandlers.values()) {
                handler.dropTables(DSL.using((Configuration)nested));
            }
        });
    }

    public void close() throws PersistencyException {
        log.info("close()");
        JooqDataSourceHandler.closeDataSource();
    }

    public void postBoostrap() throws PersistencyException {
        JooqDataSourceHandler.retrieveContext(null).transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postBoostrap(DSL.using((Configuration)nested));
            }
        });
    }

    public void postStartServer() throws PersistencyException {
        JooqDataSourceHandler.retrieveContext(null).transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postStartServer(DSL.using((Configuration)nested));
            }
        });
    }

    public void postConnect() throws PersistencyException {
        JooqDataSourceHandler.retrieveContext(null).transaction(nested -> {
            for (JooqDomainHandler domainHandler : this.domainHandlers) {
                domainHandler.postConnect(DSL.using((Configuration)nested));
            }
        });
    }

    public void begin(TransactionKey transactionKey) throws PersistencyException {
        JooqDataSourceHandler.createConnection(transactionKey);
    }

    public void commit(TransactionKey transactionKey) throws PersistencyException {
        log.debug("commit() - transactionKey:{}", (Object)transactionKey);
        DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.commit(context, transactionKey);
        }
        Connection conn = JooqDataSourceHandler.removeConnection(transactionKey);
        if (conn == null) {
            return;
        }
        try {
            if (!JooqDataSourceHandler.getDataSource().isAutoCommit()) {
                conn.commit();
            }
            conn.close();
        }
        catch (Exception e) {
            log.error("commit()", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public void abort(TransactionKey transactionKey) throws PersistencyException {
        log.debug("abort() - transactionKey:{}", (Object)transactionKey);
        DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.abort(context, transactionKey);
        }
        Connection conn = JooqDataSourceHandler.removeConnection(transactionKey);
        if (conn == null) {
            return;
        }
        try {
            if (!JooqDataSourceHandler.getDataSource().isAutoCommit()) {
                conn.rollback();
            }
            conn.close();
        }
        catch (Exception e) {
            log.error("abort()", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public short queryClusterSupport(ClusterType type) {
        if (type == ClusterType.PATH) {
            return 0;
        }
        return 3;
    }

    public boolean checkQuerySupport(String language) {
        String lang = language.trim().toUpperCase();
        return "SQL".equals(lang) || ("SQL:" + JooqDataSourceHandler.dialect).equals(lang);
    }

    public String getName() {
        return "JOOQ:" + JooqDataSourceHandler.dialect + " ClusterStorage";
    }

    public String getId() {
        return "JOOQ:" + JooqDataSourceHandler.dialect;
    }

    public int getLastIntegerId(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
        ClusterType cluster = JooqClusterStorage.getClusterType((String)path);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        if (handler == null) {
            throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
        }
        if (cluster == ClusterType.HISTORY) {
            return ((JooqHistoryHandler)handler).getLastEventId(context, itemPath.getUUID());
        }
        if (cluster == ClusterType.JOB) {
            return ((JooqJobHandler)handler).getLastJobId(context, itemPath.getUUID());
        }
        String msg = "Invalid ClusterType! Must be either HISTORY or JOB. Actual cluster:" + cluster;
        log.error("getLastIntegerId() - {}", (Object)msg);
        throw new PersistencyException(msg);
    }

    public String executeQuery(Query query, TransactionKey transactionKey) throws PersistencyException {
        throw new PersistencyException("UnImplemented");
    }

    public ClusterType[] getClusters(ItemPath itemPath, TransactionKey transactionKey) throws PersistencyException {
        ArrayList<ClusterType> result = new ArrayList<ClusterType>();
        for (ClusterType type : this.jooqHandlers.keySet()) {
            if (!this.jooqHandlers.get(type).exists(JooqDataSourceHandler.retrieveContext(transactionKey), itemPath.getUUID())) continue;
            result.add(type);
        }
        return result.toArray(new ClusterType[0]);
    }

    public String[] getClusterContents(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        if (StringUtils.isBlank((CharSequence)path)) {
            ArrayList<String> result = new ArrayList<String>();
            for (ClusterType k : this.getClusters(itemPath, transactionKey)) {
                result.add(k.toString());
            }
            return result.toArray(new String[0]);
        }
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = JooqClusterStorage.getClusterType((String)path);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        Object[] primaryKeys = JooqHandler.getPrimaryKeys(path);
        if (handler != null) {
            log.debug("getClusterContents() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys));
            return handler.getNextPrimaryKeys(JooqDataSourceHandler.retrieveContext(transactionKey), uuid, (String[])primaryKeys);
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public C2KLocalObject get(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = JooqClusterStorage.getClusterType((String)path);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        Object[] primaryKeys = JooqHandler.getPrimaryKeys(path);
        if (handler != null) {
            log.debug("get() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys:" + Arrays.toString(primaryKeys));
            C2KLocalObject obj = handler.fetch(JooqDataSourceHandler.retrieveContext(transactionKey), uuid, (String[])primaryKeys);
            if (obj == null) {
                log.trace("JooqClusterStorage.get() - Could NOT fetch '" + itemPath + "/" + path + "'");
            }
            return obj;
        }
        throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, TransactionKey transactionKey) throws PersistencyException {
        if (!JooqDataSourceHandler.getDataSource().isAutoCommit() && transactionKey == null) {
            throw new PersistencyException("transactionKey cannot be null when autoCommit is false");
        }
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = obj.getClusterType();
        JooqHandler handler = this.jooqHandlers.get(cluster);
        DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
        JooqDataSourceHandler.logConnectionCount("JooqClusterStorage.put(before)", context);
        if (handler == null) {
            throw new PersistencyException("Write is not supported for cluster:'" + cluster + "'");
        }
        log.debug("put() - uuid:" + uuid + " cluster:" + cluster + " path:" + obj.getClusterPath());
        handler.put(context, uuid, obj);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.put(context, uuid, obj, transactionKey);
        }
        JooqDataSourceHandler.logConnectionCount("JooqClusterStorage.put(after) ", context);
    }

    public void delete(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        if (!JooqDataSourceHandler.getDataSource().isAutoCommit() && transactionKey == null) {
            throw new PersistencyException("transactionKey cannot be null when autoCommit is false");
        }
        UUID uuid = itemPath.getUUID();
        ClusterType cluster = JooqClusterStorage.getClusterType((String)path);
        JooqHandler handler = this.jooqHandlers.get(cluster);
        Object[] primaryKeys = JooqHandler.getPrimaryKeys(path);
        DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
        if (handler == null) {
            throw new PersistencyException("No handler found for cluster:'" + cluster + "'");
        }
        log.debug("delete() - uuid:" + uuid + " cluster:" + cluster + " primaryKeys" + Arrays.toString(primaryKeys));
        handler.delete(context, uuid, (String[])primaryKeys);
        for (JooqDomainHandler domainHandler : this.domainHandlers) {
            domainHandler.delete(context, uuid, transactionKey, (String[])primaryKeys);
        }
    }
}

