/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.jooqdb.lookup;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.storage.jooqdb.JooqDataSourceHandler;
import org.cristalise.storage.jooqdb.auth.Argon2Password;
import org.cristalise.storage.jooqdb.clusterStore.JooqItemPropertyHandler;
import org.cristalise.storage.jooqdb.lookup.JooqDomainPathHandler;
import org.cristalise.storage.jooqdb.lookup.JooqItemHandler;
import org.cristalise.storage.jooqdb.lookup.JooqPermissionHandler;
import org.cristalise.storage.jooqdb.lookup.JooqRolePathHandler;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqLookupManager
implements LookupManager {
    private static final Logger log = LoggerFactory.getLogger(JooqLookupManager.class);
    private JooqItemHandler items;
    private JooqDomainPathHandler domains;
    private JooqRolePathHandler roles;
    private JooqPermissionHandler permissions;
    private JooqItemPropertyHandler properties;
    private Argon2Password passwordHasher;

    public void open(Authenticator auth) {
        JooqDataSourceHandler.readSystemProperties();
        try {
            this.items = new JooqItemHandler();
            this.domains = new JooqDomainPathHandler();
            this.roles = new JooqRolePathHandler();
            this.permissions = new JooqPermissionHandler();
            this.properties = new JooqItemPropertyHandler();
            if (!JooqDataSourceHandler.readOnlyDataSource.booleanValue()) {
                JooqDataSourceHandler.retrieveContext(null).transaction(nested -> {
                    this.items.createTables(DSL.using((Configuration)nested));
                    this.domains.createTables(DSL.using((Configuration)nested));
                    this.roles.createTables(DSL.using((Configuration)nested));
                    this.permissions.createTables(DSL.using((Configuration)nested));
                    this.properties.createTables(DSL.using((Configuration)nested));
                });
            }
            this.passwordHasher = new Argon2Password();
        }
        catch (PersistencyException ex) {
            log.error("open()", (Throwable)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void dropHandlers() throws PersistencyException {
        JooqDataSourceHandler.retrieveContext(null).transaction(nested -> {
            this.properties.dropTables(DSL.using((Configuration)nested));
            this.permissions.dropTables(DSL.using((Configuration)nested));
            this.roles.dropTables(DSL.using((Configuration)nested));
            this.domains.dropTables(DSL.using((Configuration)nested));
            this.items.dropTables(DSL.using((Configuration)nested));
        });
    }

    public void initializeDirectory(TransactionKey transactionKey) throws ObjectNotFoundException {
        log.debug("initializeDirectory() - NOTHING done.");
    }

    public void close() {
        try {
            JooqDataSourceHandler.closeDataSource();
        }
        catch (PersistencyException | DataAccessException e) {
            log.error("close()", e);
        }
    }

    public boolean exists(Path path, TransactionKey transactionKey) {
        if (path == null) {
            return false;
        }
        ArrayList<Boolean> itemExists = new ArrayList<Boolean>();
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            boolean isExist = false;
            if (path instanceof ItemPath) {
                isExist = this.items.exists(context, path.getUUID());
            } else if (path instanceof AgentPath) {
                isExist = this.items.exists(context, path.getUUID());
            } else if (path instanceof DomainPath) {
                isExist = this.domains.exists(context, (DomainPath)path);
            } else if (path instanceof RolePath) {
                isExist = this.roles.exists(context, (RolePath)path, null);
            }
            if (isExist) {
                itemExists.add(isExist);
            }
            JooqDataSourceHandler.logConnectionCount("JooqLookupManager.exists()", context);
        }
        catch (PersistencyException e) {
            log.error("exists()", (Throwable)e);
        }
        return itemExists.size() > 0;
    }

    public void add(Path newPath, TransactionKey transactionKey) throws ObjectCannotBeUpdated, ObjectAlreadyExistsException {
        if (this.exists(newPath, transactionKey)) {
            throw new ObjectAlreadyExistsException("Path exist:" + newPath);
        }
        log.debug("add() - path:" + newPath);
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            int rows = 0;
            if (newPath instanceof AgentPath) {
                rows = this.items.insert(context, (AgentPath)newPath, this.properties);
            } else if (newPath instanceof ItemPath) {
                rows = this.items.insert(context, (ItemPath)newPath);
            } else if (newPath instanceof DomainPath) {
                rows = this.domains.insert(context, (DomainPath)newPath);
            } else if (newPath instanceof RolePath) {
                int n = rows = this.createRole((RolePath)newPath, transactionKey) != null ? 1 : 0;
            }
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("JOOQLookupManager must insert some records:" + rows);
            }
            log.debug("add() - path:" + newPath + " rows inserted:" + rows);
            JooqDataSourceHandler.logConnectionCount("JooqLookupManager.add()", context);
        }
        catch (PersistencyException e) {
            log.error("add()", (Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    public void delete(Path path, TransactionKey transactionKey) throws ObjectCannotBeUpdated {
        if (!this.exists(path, transactionKey)) {
            throw new ObjectCannotBeUpdated("Path does not exist:" + path);
        }
        log.debug("delete() - path:" + path);
        try {
            if (this.getChildren(path, transactionKey).hasNext()) {
                throw new ObjectCannotBeUpdated("Path is not a leaf");
            }
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            int rows = 0;
            if (path instanceof ItemPath) {
                rows = this.items.delete(context, path.getUUID());
            } else if (path instanceof AgentPath) {
                rows = this.items.delete(context, path.getUUID());
            } else if (path instanceof DomainPath) {
                rows = this.domains.delete(context, path.getStringPath());
            } else if (path instanceof RolePath) {
                this.permissions.delete(context, path.getStringPath());
                rows = this.roles.delete(context, (RolePath)path, null);
            }
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("JOOQLookupManager must delete some records:" + rows);
            }
            log.debug("delete() - path:" + path + " rows deleted:" + rows);
        }
        catch (PersistencyException e) {
            log.error("delete()", (Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    public ItemPath getItemPath(String sysKey, TransactionKey transactionKey) throws InvalidItemPathException, ObjectNotFoundException {
        ItemPath ip = new ItemPath(sysKey);
        if (!this.exists((Path)ip, transactionKey)) {
            throw new ObjectNotFoundException("Path does not exist:" + sysKey);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return this.items.fetch(context, ip.getUUID(), this.properties);
        }
        catch (PersistencyException e) {
            log.error("getItemPath()", (Throwable)e);
            throw new InvalidItemPathException(e.getMessage());
        }
    }

    public String getIOR(Path path, TransactionKey transactionKey) throws ObjectNotFoundException {
        try {
            return this.getItemPath(path.getStringPath(), transactionKey).getIORString();
        }
        catch (InvalidItemPathException e) {
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    private List<Path> find(DSLContext context, Path start, String name, List<UUID> uuids, Lookup.SearchConstraints constraints) throws PersistencyException {
        log.debug("find() - start:" + start + " name:" + name);
        ArrayList<Path> paths = new ArrayList<Path>();
        if (start instanceof DomainPath) {
            paths.addAll(this.domains.find(context, (DomainPath)start, name, uuids, constraints));
        } else if (start instanceof RolePath) {
            paths.addAll(this.roles.find(context, (RolePath)start, name, uuids, constraints));
        }
        return paths;
    }

    public Iterator<Path> search(Path start, String name, Lookup.SearchConstraints constraints, TransactionKey transactionKey) {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            result.addAll(this.find(context, start, name, null, constraints));
        }
        catch (PersistencyException e) {
            log.error("search()", (Throwable)e);
        }
        if (result.isEmpty()) {
            return new ArrayList().iterator();
        }
        return result.iterator();
    }

    public AgentPath getAgentPath(String agentName, TransactionKey transactionKey) throws ObjectNotFoundException {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            List<UUID> uuids = this.properties.findItemsByName(context, agentName);
            if (uuids.size() == 0) {
                throw new ObjectNotFoundException("Could not find agent:" + agentName);
            }
            for (UUID uuid : uuids) {
                ItemPath ip = this.items.fetch(context, uuid, this.properties);
                if (!(ip instanceof AgentPath)) continue;
                return (AgentPath)ip;
            }
            throw new ObjectNotFoundException("Could not find agent:" + agentName);
        }
        catch (PersistencyException e) {
            throw new ObjectNotFoundException("Could not retrieve agentName:" + agentName + " error:" + e.getMessage());
        }
    }

    public RolePath getRolePath(String roleName, TransactionKey transactionKey) throws ObjectNotFoundException {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        uuids.add(JooqRolePathHandler.NO_AGENT);
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            List<Path> result = this.roles.find(context, "%/" + roleName, uuids);
            if (result == null || result.size() == 0) {
                throw new ObjectNotFoundException("Role '" + roleName + "' does not exist");
            }
            if (result.size() > 1) {
                throw new ObjectNotFoundException("Unbiguos roleName:'" + roleName + "'");
            }
            RolePath role = (RolePath)result.get(0);
            role.setPermissions(this.permissions.fetch(context, role.getStringPath()));
            return role;
        }
        catch (PersistencyException e) {
            log.error("getRolePath()", (Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public ItemPath resolvePath(DomainPath domainPath, TransactionKey transactionKey) throws InvalidItemPathException, ObjectNotFoundException {
        if (!this.exists((Path)domainPath, transactionKey)) {
            throw new ObjectNotFoundException("Path does not exist:" + domainPath);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            DomainPath dp = this.domains.fetch(context, domainPath);
            if (dp.getTarget() == null) {
                throw new InvalidItemPathException("DomainPath has no target:" + domainPath);
            }
            return this.items.fetch(context, dp.getTarget().getUUID(), this.properties);
        }
        catch (PersistencyException e) {
            log.error("resolvePath()", (Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public String getAgentName(AgentPath agentPath, TransactionKey transactionKey) throws ObjectNotFoundException {
        if (!this.exists((Path)agentPath, transactionKey)) {
            throw new ObjectNotFoundException("Path does not exist:" + agentPath);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            ItemPath ip = this.items.fetch(context, agentPath.getUUID(), this.properties);
            if (ip instanceof AgentPath) {
                return ((AgentPath)ip).getAgentName(transactionKey);
            }
            throw new ObjectNotFoundException("Path is not an agent:" + agentPath);
        }
        catch (PersistencyException e) {
            log.error("getAgentName()", (Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    private String getChildrenPattern(Path path, DSLContext context) {
        if (context.dialect().equals((Object)SQLDialect.POSTGRES)) {
            return this.convertToPostgresPattern(path.getStringPath());
        }
        return "^" + path.getStringPath() + "/[^/]*$";
    }

    public String convertToPostgresPattern(String path) {
        String specialCharsToReplace = Gateway.getProperties().getString("JooqLookupManager.getChildrenPattern.specialCharsToReplace", "[^a-zA-Z0-9 ]");
        return "(?e)^" + path.replaceAll("(" + specialCharsToReplace + ")", "\\\\$1") + "/[^/]*$";
    }

    public Iterator<Path> getChildren(Path path, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            String pattern = this.getChildrenPattern(path, context);
            log.debug("getChildren() - pattern:" + pattern);
            if (path instanceof ItemPath) {
                return new ArrayList().iterator();
            }
            if (path instanceof RolePath) {
                return this.roles.findByRegex(context, pattern).iterator();
            }
            return this.domains.findByRegex(context, pattern).iterator();
        }
        catch (Exception e) {
            log.error("getChildren()", (Throwable)e);
            return new ArrayList().iterator();
        }
    }

    public Lookup.PagedResult getChildren(Path path, int offset, int limit, TransactionKey transactionKey) {
        DSLContext context;
        if (path instanceof ItemPath) {
            return new Lookup.PagedResult();
        }
        int maxRows = 0;
        try {
            context = JooqDataSourceHandler.retrieveContext(transactionKey);
        }
        catch (PersistencyException e) {
            log.error("getChildren()", (Throwable)e);
            return new Lookup.PagedResult();
        }
        String pattern = this.getChildrenPattern(path, context);
        log.debug("getChildren() - pattern:{} offset:{} limit:{}", new Object[]{pattern, offset, limit});
        if (path instanceof RolePath) {
            maxRows = this.roles.countByRegex(context, pattern);
        } else if (path instanceof DomainPath) {
            maxRows = this.domains.countByRegex(context, pattern);
        }
        if (maxRows == 0) {
            return new Lookup.PagedResult();
        }
        List<Path> pathes = null;
        if (path instanceof RolePath) {
            pathes = this.roles.findByRegex(context, pattern, offset, limit);
        } else if (path instanceof DomainPath) {
            pathes = this.domains.findByRegex(context, pattern, offset, limit);
        }
        JooqDataSourceHandler.logConnectionCount("JooqLookupManager.getChildren()", context);
        if (pathes == null) {
            return new Lookup.PagedResult();
        }
        return new Lookup.PagedResult(maxRows, pathes);
    }

    private SelectQuery<?> getSearchSelect(DSLContext context, Path start, List<Property> props) {
        SelectQuery select = context.selectQuery();
        select.addFrom(JooqDomainPathHandler.DOMAIN_PATH_TABLE);
        for (Property p : props) {
            Field joinField = DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "UUID"}), UUID.class);
            select.addJoin((TableLike)JooqItemPropertyHandler.ITEM_PROPERTY_TABLE.as(p.getName()), JoinType.LEFT_OUTER_JOIN, JooqDomainPathHandler.TARGET.equal(joinField));
            select.addConditions(Operator.AND, DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "NAME"}), String.class).equal((Object)p.getName()));
            select.addConditions(Operator.AND, (Condition)DSL.upper((Field)DSL.field((Name)DSL.name((String[])new String[]{p.getName(), "VALUE"}), String.class)).like(DSL.upper((String)p.getValue())));
        }
        select.addConditions(Operator.AND, (Condition)JooqDomainPathHandler.PATH.like(this.domains.getFindPattern(start, "", Lookup.SearchConstraints.WILDCARD_MATCH)));
        return select;
    }

    public Iterator<Path> search(Path start, TransactionKey transactionKey, Property ... props) {
        return this.search((Path)start, Arrays.asList(props), (int)0, (int)0, (TransactionKey)transactionKey).rows.iterator();
    }

    public Lookup.PagedResult search(Path start, List<Property> props, int offset, int limit, TransactionKey transactionKey) {
        DSLContext context;
        if (!this.exists(start, transactionKey)) {
            return new Lookup.PagedResult(0, new ArrayList());
        }
        try {
            context = JooqDataSourceHandler.retrieveContext(transactionKey);
        }
        catch (PersistencyException e) {
            log.error("search()", (Throwable)e);
            return new Lookup.PagedResult();
        }
        int maxRows = -1;
        if (limit > 0) {
            SelectQuery<?> selectCount = this.getSearchSelect(context, start, props);
            selectCount.addSelect(new SelectFieldOrAsterisk[]{DSL.count()});
            log.debug("search(props) - SQL(count):\n{}", selectCount);
            maxRows = (Integer)selectCount.fetchOne(0, Integer.TYPE);
            if (maxRows == 0) {
                return new Lookup.PagedResult(0, new ArrayList());
            }
        }
        SelectQuery<?> select = this.getSearchSelect(context, start, props);
        select.addSelect(new SelectFieldOrAsterisk[]{JooqDomainPathHandler.PATH, JooqDomainPathHandler.TARGET});
        select.addOrderBy(new OrderField[]{JooqDomainPathHandler.PATH});
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        log.debug("search(props) - SQL:\n{}", select);
        return new Lookup.PagedResult(maxRows, this.domains.getListOfPath(select.fetch()));
    }

    public Iterator<Path> search(Path start, PropertyDescriptionList props, TransactionKey transactionKey) {
        return this.search((Path)start, (PropertyDescriptionList)props, (int)0, (int)0, (TransactionKey)transactionKey).rows.iterator();
    }

    public Lookup.PagedResult search(Path start, PropertyDescriptionList props, int offset, int limit, TransactionKey transactionKey) {
        throw new RuntimeException("InMemoryLookup.search(PropertyDescriptionList) - UNIMPLEMENTED start:" + start);
    }

    public RolePath createRole(RolePath role, TransactionKey transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        log.debug("createRole() - role:" + role);
        if (this.exists((Path)role, transactionKey)) {
            throw new ObjectAlreadyExistsException("Role:" + role);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            role.getParent(transactionKey);
            this.roles.insert(context, role, null);
            this.permissions.insert(context, role.getStringPath(), role.getPermissionsList());
            return role;
        }
        catch (Exception e) {
            log.error("createRole()", (Throwable)e);
            throw new ObjectCannotBeUpdated("Parent role for '" + role + "' does not exists");
        }
    }

    public void addRole(AgentPath agent, RolePath role, TransactionKey transactionKey) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        if (!this.exists((Path)role, transactionKey)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        if (!this.exists((Path)agent, transactionKey)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            int rows = this.roles.insert(context, role, agent);
            if (rows != 1) {
                throw new ObjectCannotBeUpdated("Updated rows must be 1 but it was '" + rows + "'");
            }
        }
        catch (Exception e) {
            log.error("addRole()", (Throwable)e);
            throw new ObjectCannotBeUpdated(e.getMessage());
        }
    }

    private SelectQuery<?> getGetAgentsSelect(DSLContext context, RolePath role) {
        SelectQuery select = context.selectQuery();
        select.addFrom((TableLike)JooqRolePathHandler.ROLE_PATH_TABLE.as("role"));
        select.addJoin((TableLike)JooqItemHandler.ITEM_TABLE.as("item"), JoinType.JOIN, JooqRolePathHandler.AGENT.equal(DSL.field((Name)DSL.name((String[])new String[]{"item", "UUID"}), UUID.class)));
        select.addJoin((TableLike)JooqItemPropertyHandler.ITEM_PROPERTY_TABLE.as("prop"), JoinType.JOIN, JooqRolePathHandler.AGENT.equal(DSL.field((Name)DSL.name((String[])new String[]{"prop", "UUID"}), UUID.class)));
        select.addConditions(Operator.AND, JooqRolePathHandler.PATH.equal((Object)role.getStringPath()));
        select.addConditions(Operator.AND, JooqItemPropertyHandler.NAME.equal((Object)"Name"));
        return select;
    }

    public AgentPath[] getAgents(RolePath role, TransactionKey transactionKey) throws ObjectNotFoundException {
        return this.getAgents((RolePath)role, (int)-1, (int)-1, (TransactionKey)transactionKey).rows.toArray(new AgentPath[0]);
    }

    public Lookup.PagedResult getAgents(RolePath role, int offset, int limit, TransactionKey transactionKey) throws ObjectNotFoundException {
        DSLContext context;
        int maxRows = -1;
        try {
            context = JooqDataSourceHandler.retrieveContext(transactionKey);
        }
        catch (PersistencyException e) {
            log.error("getAgents()", (Throwable)e);
            return new Lookup.PagedResult();
        }
        if (limit > 0) {
            SelectQuery<?> selectCount = this.getGetAgentsSelect(context, role);
            selectCount.addSelect(new SelectFieldOrAsterisk[]{DSL.count()});
            log.debug("getAgents(props) - role:{}  SQL(count):\n{}", (Object)role, selectCount);
            maxRows = (Integer)selectCount.fetchOne(0, Integer.TYPE);
        }
        SelectQuery<?> select = this.getGetAgentsSelect(context, role);
        select.addSelect(new SelectFieldOrAsterisk[]{DSL.field((Name)DSL.name((String[])new String[]{"item", "UUID"}), UUID.class), JooqItemHandler.IOR, JooqItemHandler.IS_AGENT, JooqItemPropertyHandler.VALUE.as("Name")});
        if (Gateway.getProperties().getBoolean("JOOQ.TemporaryPwdFieldImplemented", true)) {
            select.addSelect(new SelectFieldOrAsterisk[]{JooqItemHandler.IS_PASSWORD_TEMPORARY});
        }
        select.addOrderBy(new OrderField[]{DSL.field((Name)DSL.name((String)"Name"))});
        if (limit > 0) {
            select.addLimit(limit);
        }
        if (offset > 0) {
            select.addOffset(offset);
        }
        log.debug("getAgents() - role:{}  SQL:\n{}", (Object)role, select);
        Result result = select.fetch();
        Lookup.PagedResult pResult = new Lookup.PagedResult();
        if (result != null) {
            pResult.maxRows = maxRows;
            for (Record record : result) {
                try {
                    pResult.rows.add(JooqItemHandler.getItemPath(context, null, record));
                }
                catch (PersistencyException e) {
                    log.error("getAgents()", (Throwable)e);
                    throw new ObjectNotFoundException(e.getMessage());
                }
            }
        }
        return pResult;
    }

    public RolePath[] getRoles(AgentPath agent, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return this.roles.findRolesOfAgent(context, agent, this.permissions).toArray(new RolePath[0]);
        }
        catch (PersistencyException e) {
            log.error("getRoles()", (Throwable)e);
            return new RolePath[0];
        }
    }

    public Lookup.PagedResult getRoles(AgentPath agent, int offset, int limit, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return new Lookup.PagedResult(this.roles.countRolesOfAgent(context, agent), this.roles.findRolesOfAgent(context, agent, offset, limit, this.permissions));
        }
        catch (PersistencyException e) {
            log.error("getRoles()", (Throwable)e);
            return new Lookup.PagedResult();
        }
    }

    public boolean hasRole(AgentPath agent, RolePath role, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return this.roles.exists(context, role, agent);
        }
        catch (PersistencyException e) {
            log.error("hasRole()", (Throwable)e);
            return false;
        }
    }

    public void removeRole(AgentPath agent, RolePath role, TransactionKey transactionKey) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        if (!this.exists((Path)role, transactionKey)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        if (!this.exists((Path)agent, transactionKey)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            int rows = this.roles.delete(context, role, agent);
            if (rows == 0) {
                throw new ObjectCannotBeUpdated("Role:" + role + " Agent:" + agent + " are not related.");
            }
        }
        catch (Exception e) {
            throw new ObjectCannotBeUpdated("Role:" + role + " Agent:" + agent + " error:" + e.getMessage());
        }
    }

    public void setAgentPassword(AgentPath agent, String newPassword, boolean temporary, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException {
        if (!this.exists((Path)agent, transactionKey)) {
            throw new ObjectNotFoundException("Agent:" + agent);
        }
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            int rows = this.items.updatePassword(context, agent, this.passwordHasher.hashPassword(newPassword.toCharArray()), temporary);
            if (rows != 1) {
                throw new ObjectCannotBeUpdated("Agent:" + agent);
            }
        }
        catch (Exception e) {
            log.error("setAgentPassword()", (Throwable)e);
            throw new ObjectCannotBeUpdated("Agent:" + agent + " error:" + e.getMessage());
        }
    }

    public void setHasJobList(RolePath role, boolean hasJobList, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)role, transactionKey)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        role.setHasJobList(hasJobList);
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            this.roles.update(context, role);
        }
        catch (Exception e) {
            log.error("setHasJobList()", (Throwable)e);
            throw new ObjectCannotBeUpdated("Role:" + role + " error:" + e.getMessage());
        }
    }

    public Iterator<Path> searchAliases(ItemPath itemPath, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return this.domains.find(context, itemPath).iterator();
        }
        catch (PersistencyException e) {
            log.error("searchAliases()", (Throwable)e);
            return new ArrayList().iterator();
        }
    }

    public Lookup.PagedResult searchAliases(ItemPath itemPath, int offset, int limit, TransactionKey transactionKey) {
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            return new Lookup.PagedResult(this.domains.countFind(context, itemPath), this.domains.find(context, itemPath, offset, limit));
        }
        catch (PersistencyException e) {
            log.error("searchAliases()", (Throwable)e);
            return new Lookup.PagedResult();
        }
    }

    public void setIOR(ItemPath item, String ior, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)item, transactionKey)) {
            throw new ObjectNotFoundException("Item:" + item);
        }
        item.setIORString(ior);
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            this.items.updateIOR(context, item, ior);
        }
        catch (Exception e) {
            log.error("setIOR()", (Throwable)e);
            throw new ObjectCannotBeUpdated("Item:" + item + " error:" + e.getMessage());
        }
    }

    public void setPermission(RolePath role, String permission, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        ArrayList<String> permissions = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)permission)) {
            permissions.add(permission);
        }
        this.setPermissions(role, permissions, transactionKey);
    }

    public void setPermissions(RolePath role, List<String> permissions, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        if (!this.exists((Path)role, transactionKey)) {
            throw new ObjectNotFoundException("Role:" + role);
        }
        role.setPermissions(permissions);
        try {
            DSLContext context = JooqDataSourceHandler.retrieveContext(transactionKey);
            if (this.permissions.exists(context, role.getStringPath())) {
                this.permissions.delete(context, role.getStringPath());
            }
            this.permissions.insert(context, role.getStringPath(), role.getPermissionsList());
        }
        catch (Exception e) {
            log.error("setPermissions()", (Throwable)e);
            throw new ObjectCannotBeUpdated("Role:" + role + " error:" + e.getMessage());
        }
    }

    public void postStartServer() {
    }

    public void postBoostrap() {
    }
}

