/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.Logger;

public class Dependency
extends Collection<DependencyMember> {
    protected CastorHashMap mProperties = new CastorHashMap();
    protected String mClassProps = "";

    public Dependency() {
        this.setName("Dependency");
    }

    public Dependency(String name) {
        this.setName(name);
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public void setClassProps(String classProps) {
        this.mClassProps = classProps;
    }

    public String getClassProps() {
        return this.mClassProps;
    }

    public DependencyMember addMember(ItemPath itemPath) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        depMember.setProperties((CastorHashMap)this.mProperties.clone());
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency::addMember(" + itemPath + ") added to children.");
        return depMember;
    }

    public List<ItemPath> compare(Dependency other) {
        ArrayList<ItemPath> newMembers = new ArrayList<ItemPath>();
        for (DependencyMember thisMember : other.getMembers().list) {
            ItemPath thisPath = thisMember.getItemPath();
            if (this.contains(thisPath)) continue;
            newMembers.add(thisPath);
        }
        return newMembers;
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath, CastorHashMap props, String classProps) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        String key;
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        if (classProps != null && !classProps.equals(this.mClassProps)) {
            throw new InvalidCollectionModification("Cannot change classProps in dependency member");
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        CastorHashMap newProps = new CastorHashMap();
        for (Object name : props.keySet()) {
            key = (String)name;
            newProps.put(key, props.get(key));
        }
        for (Object name : this.mProperties.keySet()) {
            key = (String)name;
            newProps.put(key, this.mProperties.get(key));
        }
        depMember.setProperties(newProps);
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency::addMember(" + itemPath + ") added to children.");
        return depMember;
    }

    @Override
    public void removeMember(int memberId) throws ObjectNotFoundException {
        for (DependencyMember element : this.mMembers.list) {
            if (element.getID() != memberId) continue;
            this.mMembers.list.remove(element);
            return;
        }
        throw new ObjectNotFoundException("Member " + memberId + " not found");
    }
}

