/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.HashMap;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeInitiator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Job
implements C2KLocalObject {
    private int id;
    private ItemPath itemPath;
    private String stepName;
    private String stepPath;
    private String stepType;
    private Transition transition;
    private String originStateName;
    private String targetStateName;
    private String agentRole;
    private AgentPath agentPath;
    private CastorHashMap actProps = new CastorHashMap();
    private GTimeStamp creationDate;
    private String name;
    private String agentName;
    private AgentPath delegatePath;
    private String delegateName;
    private String outcomeData;
    private ErrorInfo error;
    private ItemProxy item = null;
    private boolean outcomeSet;
    private boolean transitionResolved = false;
    private static HashMap<String, OutcomeInitiator> ocInitCache = new HashMap();

    public Job() {
        this.setCreationDate(Event.getGMT());
    }

    public Job(Activity act, ItemPath itemPath, Transition transition, AgentPath agent, String role) throws InvalidDataException, ObjectNotFoundException, InvalidAgentPathException {
        this.setCreationDate(Event.getGMT());
        this.setItemPath(itemPath);
        this.setStepPath(act.getPath());
        this.setTransition(transition);
        this.setOriginStateName(act.getStateMachine().getState(transition.getOriginStateId()).getName());
        this.setTargetStateName(act.getStateMachine().getState(transition.getTargetStateId()).getName());
        this.setStepName(act.getName());
        this.setActProps(act.getProperties());
        this.setStepType(act.getType());
        if (agent != null) {
            this.setAgentName(agent.getAgentName());
        }
        this.setAgentRole(role);
    }

    public String getOriginStateName() {
        return this.originStateName;
    }

    public void setOriginStateName(String originStateName) {
        this.originStateName = originStateName;
    }

    public String getTargetStateName() {
        return this.targetStateName;
    }

    public void setTargetStateName(String targetStateName) {
        this.targetStateName = targetStateName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.name = String.valueOf(id);
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public void setItemPath(ItemPath path) {
        this.itemPath = path;
        this.item = null;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String string) {
        this.stepName = string;
    }

    public String getStepPath() {
        return this.stepPath;
    }

    public void setStepPath(String string) {
        this.stepPath = string;
    }

    public String getStepType() {
        return this.stepType;
    }

    public void setStepType(String actType) {
        this.stepType = actType;
    }

    public GTimeStamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(GTimeStamp creationDate) {
        this.creationDate = creationDate;
    }

    public Transition getTransition() {
        if (this.transition != null && !this.transitionResolved) {
            StateMachine sm;
            String name = this.getActPropString("StateMachineName");
            int version = (Integer)this.getActProp("StateMachineVersion");
            try {
                sm = LocalObjectLoader.getStateMachine(name, version);
            }
            catch (Exception e) {
                return this.transition;
            }
            this.transition = sm.getTransition(this.transition.getId());
            this.transitionResolved = true;
        }
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
        this.transitionResolved = false;
    }

    public AgentPath getAgentPath() throws ObjectNotFoundException {
        if (this.agentPath == null && this.getAgentName() != null) {
            this.agentPath = Gateway.getLookup().getAgentPath(this.getAgentName());
        }
        return this.agentPath;
    }

    public void setAgentPath(AgentPath agentPath) {
        this.agentPath = agentPath;
        this.agentName = agentPath.getAgentName();
    }

    public AgentPath getDelegatePath() throws ObjectNotFoundException {
        if (this.delegatePath == null && this.getDelegateName() != null) {
            this.delegatePath = Gateway.getLookup().getAgentPath(this.getDelegateName());
        }
        return this.delegatePath;
    }

    public void setDelegatePath(AgentPath delegatePath) {
        this.delegatePath = delegatePath;
        this.delegateName = delegatePath.getAgentName();
    }

    public void setAgentUUID(String uuid) throws InvalidItemPathException {
        if (uuid == null || uuid.length() == 0) {
            this.agentPath = null;
            this.agentName = null;
            this.delegatePath = null;
            this.delegateName = null;
        } else if (uuid.contains(":")) {
            String[] agentStr = uuid.split(":");
            if (agentStr.length != 2) {
                throw new InvalidItemPathException();
            }
            this.setAgentPath(AgentPath.fromUUIDString(agentStr[0]));
            this.setDelegatePath(AgentPath.fromUUIDString(agentStr[1]));
        } else {
            this.setAgentPath(AgentPath.fromUUIDString(uuid));
        }
    }

    public String getAgentUUID() {
        if (this.agentPath != null) {
            try {
                if (this.delegatePath != null) {
                    return this.getAgentPath().getUUID().toString() + ":" + this.getDelegatePath().getUUID().toString();
                }
                return this.getAgentPath().getUUID().toString();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAgentName() {
        if (this.agentName == null) {
            this.agentName = (String)this.actProps.get("Agent Name");
        }
        return this.agentName;
    }

    public String getDelegateName() {
        if (this.delegateName == null && this.delegatePath != null) {
            this.delegateName = this.delegatePath.getAgentName();
        }
        return this.delegateName;
    }

    public void setAgentName(String agentName) throws ObjectNotFoundException {
        this.agentName = agentName;
        this.agentPath = Gateway.getLookup().getAgentPath(agentName);
    }

    public void setDelegateName(String delegateName) throws ObjectNotFoundException {
        this.delegateName = delegateName;
        this.delegatePath = Gateway.getLookup().getAgentPath(delegateName);
    }

    public String getAgentRole() {
        return this.agentRole;
    }

    public void setAgentRole(String role) {
        this.agentRole = role;
    }

    public Schema getSchema() throws InvalidDataException, ObjectNotFoundException {
        if (this.getTransition().hasOutcome(this.actProps)) {
            Schema schema = this.getTransition().getSchema(this.actProps);
            return schema;
        }
        return null;
    }

    @Deprecated
    public String getSchemaName() throws InvalidDataException, ObjectNotFoundException {
        try {
            return this.getSchema().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getSchemaVersion() throws InvalidDataException, ObjectNotFoundException {
        try {
            return this.getSchema().getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isOutcomeRequired() {
        return this.getTransition().hasOutcome(this.actProps) && this.getTransition().getOutcome().isRequired();
    }

    public Script getScript() throws ObjectNotFoundException, InvalidDataException {
        if (this.getTransition().hasScript(this.actProps)) {
            return this.getTransition().getScript(this.actProps);
        }
        return null;
    }

    @Deprecated
    public String getScriptName() {
        try {
            return this.getScript().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getScriptVersion() throws InvalidDataException {
        try {
            return this.getScript().getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.actProps.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.actProps.setKeyValuePairs(pairs);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        try {
            this.id = Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            this.id = -1;
        }
    }

    public ItemProxy getItemProxy() throws ObjectNotFoundException, InvalidItemPathException {
        if (this.item == null) {
            this.item = Gateway.getProxyManager().getProxy(this.itemPath);
        }
        return this.item;
    }

    public String getDescription() {
        String desc = (String)this.actProps.get("Description");
        if (desc == null) {
            desc = "No Description";
        }
        return desc;
    }

    public void setOutcome(String outcome) {
        this.outcomeData = outcome;
        this.outcomeSet = this.outcomeData != null;
    }

    public void setOutcome(Outcome outcome) {
        this.outcomeData = outcome.getData();
        this.outcomeSet = this.outcomeData != null;
    }

    public void setError(ErrorInfo errors) {
        this.error = errors;
        try {
            this.outcomeData = Gateway.getMarshaller().marshall(this.error);
        }
        catch (Exception e) {
            Logger.error("Error marshalling ErrorInfo in job");
            Logger.error(e);
        }
    }

    public String getLastView() throws InvalidDataException, ObjectNotFoundException {
        String viewName = (String)this.getActProp("Viewpoint");
        if (viewName.length() > 0) {
            String schemaName = this.getSchema().getName();
            try {
                Viewpoint view = (Viewpoint)Gateway.getStorage().get(this.itemPath, "ViewPoint/" + schemaName + "/" + viewName, null);
                return view.getOutcome().getData();
            }
            catch (PersistencyException e) {
                Logger.error((Throwable)((Object)e));
                throw new InvalidDataException("ViewpointOutcomeInitiator: PersistencyException loading viewpoint ViewPoint/" + schemaName + "/" + viewName + " in item " + this.itemPath.getUUID());
            }
        }
        throw new ObjectNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutcomeInitiator getOutcomeInitiator() throws InvalidDataException {
        String ocInitName = (String)this.getActProp("OutcomeInit");
        if (ocInitName.length() > 0) {
            OutcomeInitiator ocInit;
            String ocPropName = "OutcomeInit." + ocInitName;
            HashMap<String, OutcomeInitiator> hashMap = ocInitCache;
            synchronized (hashMap) {
                ocInit = ocInitCache.get(ocPropName);
                if (ocInit == null) {
                    Object ocInitObj;
                    if (!Gateway.getProperties().containsKey(ocPropName)) {
                        throw new InvalidDataException("Outcome instantiator " + ocPropName + " isn't defined");
                    }
                    try {
                        ocInitObj = Gateway.getProperties().getInstance(ocPropName);
                    }
                    catch (Exception e) {
                        Logger.error(e);
                        throw new InvalidDataException("Outcome instantiator " + ocPropName + " couldn't be instantiated");
                    }
                    ocInit = (OutcomeInitiator)ocInitObj;
                    ocInitCache.put(ocPropName, ocInit);
                }
            }
            return ocInit;
        }
        return null;
    }

    public String getOutcomeString() throws InvalidDataException {
        if (this.outcomeData == null && this.transition.hasOutcome(this.actProps)) {
            block4: {
                try {
                    this.outcomeData = this.getLastView();
                }
                catch (ObjectNotFoundException ex) {
                    OutcomeInitiator ocInit = this.getOutcomeInitiator();
                    if (ocInit == null) break block4;
                    this.outcomeData = ocInit.initOutcome(this);
                }
            }
            if (this.outcomeData != null) {
                this.outcomeSet = true;
            }
        }
        return this.outcomeData;
    }

    public Outcome getOutcome() throws InvalidDataException, ObjectNotFoundException {
        return new Outcome(-1, this.getOutcomeString(), this.transition.getSchema(this.actProps));
    }

    public boolean hasOutcome() {
        return this.transition.hasOutcome(this.actProps);
    }

    public boolean hasScript() {
        return this.transition.hasScript(this.actProps);
    }

    public boolean isOutcomeSet() {
        return this.outcomeSet;
    }

    @Override
    public String getClusterType() {
        return "Job";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemPath == null ? 0 : this.itemPath.hashCode());
        result = 31 * result + (this.stepPath == null ? 0 : this.stepPath.hashCode());
        result = 31 * result + (this.transition == null ? 0 : this.transition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Job other = (Job)obj;
        if (this.itemPath == null ? other.itemPath != null : !this.itemPath.equals(other.itemPath)) {
            return false;
        }
        if (this.stepPath == null ? other.stepPath != null : !this.stepPath.equals(other.stepPath)) {
            return false;
        }
        return !(this.transition == null ? other.transition != null : !this.transition.equals(other.transition));
    }

    private void setActProps(CastorHashMap actProps) {
        this.actProps = actProps;
    }

    public Object getActProp(String name) {
        return this.actProps.get(name);
    }

    public String getActPropString(String name) {
        Object obj = this.getActProp(name);
        return obj == null ? null : String.valueOf(obj);
    }
}

