/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.RemoteMap;
import org.cristalise.kernel.utils.Logger;

public class JobList
extends RemoteMap<Job> {
    public JobList(AgentPath agentPath, Object locker) {
        super(agentPath, "Job", locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        JobList jobList = this;
        synchronized (jobList) {
            int jobId = this.getLastId() + 1;
            job.setId(jobId);
            this.put(String.valueOf(jobId), job);
        }
    }

    @Override
    public String getClusterType() {
        return null;
    }

    public Job getJob(int id) {
        return (Job)this.get(String.valueOf(id));
    }

    public void removeJobsForItem(ItemPath itemPath) {
        Iterator currentMembers = this.values().iterator();
        Job j = null;
        while (currentMembers.hasNext()) {
            j = (Job)currentMembers.next();
            if (!j.getItemPath().equals(itemPath)) continue;
            this.remove(String.valueOf(j.getId()));
        }
        Logger.msg(5, "JobList::removeJobsWithSysKey() - " + itemPath + " DONE.");
    }

    public void removeJobsForStep(ItemPath itemPath, String stepPath) {
        ArrayList<String> staleJobs = new ArrayList<String>();
        for (String jid : this.keySet()) {
            Job j = (Job)this.get(jid);
            if (!j.getItemPath().equals(itemPath) || !j.getStepPath().equals(stepPath)) continue;
            staleJobs.add(jid);
        }
        Logger.msg(3, "JobList.removeJobsForStep() - removing " + staleJobs.size());
        for (String jid : staleJobs) {
            this.remove(jid);
        }
        Logger.msg(5, "JobList::removeJobsForStep() - " + itemPath + " DONE.");
    }

    public Vector<Job> getJobsOfItem(ItemPath itemPath) {
        Iterator currentMembers = this.values().iterator();
        Job j = null;
        Vector<Job> jobs = new Vector<Job>();
        while (currentMembers.hasNext()) {
            j = (Job)currentMembers.next();
            if (!j.getItemPath().equals(itemPath)) continue;
            jobs.add(j);
        }
        Logger.msg(5, "JobList::getJobsOfSysKey() - returning " + jobs.size() + " Jobs.");
        return jobs;
    }
}

