/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.ActiveEntity;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.Logger;

public class ImportAgent
extends ModuleImport {
    private String password;
    private ArrayList<Property> properties = new ArrayList();
    private ArrayList<String> roles = new ArrayList();

    public ImportAgent() {
    }

    public ImportAgent(String name, String password) {
        this.name = name;
        this.password = password;
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException {
        AgentPath newAgent = new AgentPath(this.getItemPath(), this.name);
        newAgent.setPassword(this.password);
        ActiveEntity newAgentEnt = Gateway.getCorbaServer().createAgent(newAgent);
        Gateway.getLookupManager().add(newAgent);
        this.properties.add(new Property("Name", this.name, true));
        this.properties.add(new Property("Type", "Agent", false));
        try {
            newAgentEnt.initialise(agentPath.getSystemKey(), Gateway.getMarshaller().marshall(new PropertyArrayList(this.properties)), null, null);
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new CannotManageException("Error initialising new agent");
        }
        if (this.roles.isEmpty()) {
            this.roles.add("");
        }
        for (String role : this.roles) {
            RolePath thisRole;
            try {
                thisRole = Gateway.getLookup().getRolePath(role);
            }
            catch (ObjectNotFoundException ex) {
                throw new ObjectNotFoundException("Role " + role + " does not exist.");
            }
            Gateway.getLookupManager().addRole(newAgent, thisRole);
        }
        return newAgent;
    }

    @Override
    public ItemPath getItemPath() {
        if (this.itemPath == null) {
            try {
                AgentPath existAgent = Gateway.getLookup().getAgentPath(this.name);
                this.itemPath = existAgent;
            }
            catch (ObjectNotFoundException ex) {
                this.itemPath = new AgentPath(new ItemPath(), this.name);
            }
        }
        return this.itemPath;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList<String> roles) {
        this.roles = roles;
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }
}

