/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportDependencyMember;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;

public class ImportDependency {
    public String name;
    public Integer version;
    public boolean isDescription;
    public String itemDescriptionPath;
    public String itemDescriptionVersion = null;
    public ArrayList<ImportDependencyMember> dependencyMemberList = new ArrayList();
    public CastorHashMap props = new CastorHashMap();

    public ImportDependency() {
    }

    public ImportDependency(String name) {
        this();
        this.name = name;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.props.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.props.setKeyValuePairs(pairs);
    }

    public Dependency create() throws InvalidCollectionModification, ObjectNotFoundException, ObjectAlreadyExistsException {
        Dependency newDep;
        Dependency dependency = newDep = this.isDescription ? new DependencyDescription(this.name) : new Dependency(this.name);
        if (this.version != null) {
            newDep.setVersion(this.version);
        }
        if (this.itemDescriptionPath != null && this.itemDescriptionPath.length() > 0) {
            ItemPath itemPath;
            try {
                itemPath = new ItemPath(this.itemDescriptionPath);
            }
            catch (InvalidItemPathException ex) {
                itemPath = new DomainPath(this.itemDescriptionPath).getItemPath();
            }
            String descVer = this.itemDescriptionVersion == null ? "last" : this.itemDescriptionVersion;
            PropertyDescriptionList propList = PropertyUtility.getPropertyDescriptionOutcome(itemPath, descVer, null);
            StringBuffer classProps = new StringBuffer();
            for (PropertyDescription pd : propList.list) {
                this.props.put(pd.getName(), pd.getDefaultValue());
                if (!pd.getIsClassIdentifier()) continue;
                classProps.append(classProps.length() > 0 ? "," : "").append(pd.getName());
            }
            newDep.setProperties(this.props);
            newDep.setClassProps(classProps.toString());
        }
        for (ImportDependencyMember thisMem : this.dependencyMemberList) {
            ItemPath itemPath;
            try {
                itemPath = new ItemPath(thisMem.itemPath);
            }
            catch (InvalidItemPathException ex) {
                itemPath = new DomainPath(thisMem.itemPath).getItemPath();
            }
            DependencyMember newDepMem = newDep.addMember(itemPath);
            newDepMem.getProperties().putAll(thisMem.props);
        }
        return newDep;
    }
}

