/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.entity.imports.ImportAggregation;
import org.cristalise.kernel.entity.imports.ImportDependency;
import org.cristalise.kernel.entity.imports.ImportOutcome;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;

public class ImportItem
extends ModuleImport {
    protected String initialPath;
    protected String workflow;
    protected Integer workflowVer;
    protected ArrayList<Property> properties = new ArrayList();
    protected ArrayList<ImportAggregation> aggregationList = new ArrayList();
    protected ArrayList<ImportDependency> dependencyList = new ArrayList();
    protected ArrayList<ImportOutcome> outcomes = new ArrayList();

    public ImportItem() {
    }

    public ImportItem(String ns, String name, String initialPath, ItemPath itemPath, String wf, int wfVer) {
        this();
        this.setNamespace(ns);
        this.setName(name);
        this.setItemPath(itemPath);
        this.setInitialPath(initialPath);
        this.setWorkflow(wf);
        this.setWorkflowVer(wfVer);
    }

    @Override
    public ItemPath getItemPath() {
        DomainPath existingItem;
        if (this.itemPath == null && (existingItem = new DomainPath(this.initialPath + "/" + this.name)).exists()) {
            try {
                this.itemPath = existingItem.getItemPath();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        if (this.itemPath == null) {
            this.itemPath = new ItemPath();
        }
        return this.itemPath;
    }

    @Override
    public void setNamespace(String ns) {
        super.setNamespace(ns);
        if (this.initialPath == null) {
            this.initialPath = "/desc/" + ns;
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset) throws ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, InvalidCollectionModification {
        CompositeActivityDef compact;
        TraceableEntity newItem;
        DomainPath domPath = new DomainPath(new DomainPath(this.initialPath), this.name);
        if (domPath.exists()) {
            ItemPath domItem = domPath.getItemPath();
            if (!this.getItemPath().equals(domItem)) {
                throw new CannotManageException("Item " + domPath + " was found with the wrong itemPath (" + domPath.getItemPath() + " vs " + this.getItemPath() + ")");
            }
        }
        if (this.getItemPath().exists()) {
            Logger.msg(1, "ImportItem.create() - Verifying module item " + domPath + " at " + this.getItemPath());
            newItem = Gateway.getCorbaServer().getItem(this.getItemPath());
        } else {
            Logger.msg("ImportItem.create() - Creating module item " + this.getItemPath() + " at " + domPath);
            newItem = Gateway.getCorbaServer().createItem(this.getItemPath());
            Gateway.getLookupManager().add(this.getItemPath());
        }
        this.properties.add(new Property("Name", this.name, true));
        int usedWfVer = this.workflowVer == null ? 0 : this.workflowVer;
        try {
            compact = (CompositeActivityDef)LocalObjectLoader.getActDef(this.workflow, usedWfVer);
        }
        catch (ObjectNotFoundException ex) {
            throw new CannotManageException("Could not find workflow " + this.workflow + "v" + usedWfVer + " for item " + domPath);
        }
        catch (InvalidDataException e) {
            throw new CannotManageException("Workflow def " + this.workflow + " v" + usedWfVer + " for item " + domPath + " was not valid");
        }
        CollectionArrayList colls = new CollectionArrayList();
        for (ImportDependency importDependency : this.dependencyList) {
            Dependency newDep = importDependency.create();
            colls.put(newDep);
        }
        for (ImportAggregation importAggregation : this.aggregationList) {
            Aggregation newAgg = importAggregation.create();
            colls.put(newAgg);
        }
        try {
            newItem.initialise(agentPath.getSystemKey(), Gateway.getMarshaller().marshall(new PropertyArrayList(this.properties)), Gateway.getMarshaller().marshall(compact.instantiate()), Gateway.getMarshaller().marshall(colls));
        }
        catch (Exception ex) {
            Logger.error("Error initialising new item " + this.ns + "/" + this.name);
            Logger.error(ex);
            throw new CannotManageException("Problem initialising new item. See server log.");
        }
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        History hist = new History(this.getItemPath(), null);
        for (ImportOutcome thisOutcome : this.outcomes) {
            Viewpoint impView;
            Outcome newOutcome;
            Schema schema;
            String outcomeData = thisOutcome.getData(this.ns);
            try {
                schema = LocalObjectLoader.getSchema(thisOutcome.schema, thisOutcome.version);
            }
            catch (InvalidDataException ex) {
                throw new ObjectCannotBeUpdated("Could not load schema " + thisOutcome.schema + " v" + thisOutcome.version);
            }
            try {
                newOutcome = new Outcome(-1, outcomeData, schema);
                String errors = newOutcome.validate();
                if (errors != null && errors.length() > 0) {
                    throw new ObjectCannotBeUpdated("Invalid XML in view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
                }
            }
            catch (InvalidDataException ex) {
                throw new ObjectCannotBeUpdated("XML is not valid in view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
            }
            try {
                impView = (Viewpoint)Gateway.getStorage().get(this.getItemPath(), "ViewPoint/" + thisOutcome.schema + "/" + thisOutcome.viewname, null);
                Diff xmlDiff = new Diff(newOutcome.getDOM(), impView.getOutcome().getDOM());
                if (xmlDiff.identical()) {
                    Logger.msg(5, "NewItem.create() - View " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name + " identical, no update required");
                    continue;
                }
                Logger.msg("NewItem.create() - Difference found in view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name + ": " + xmlDiff.toString());
                if (!reset && !impView.getEvent().getStepPath().equals("Import")) {
                    Logger.msg("Last edit was not done by import, and reset not requested. Not overwriting.");
                    continue;
                }
            }
            catch (ObjectNotFoundException ex) {
                Logger.msg("View " + thisOutcome.schema + "/" + thisOutcome.viewname + " not found in " + this.ns + "/" + this.name + ". Creating.");
                impView = new Viewpoint(this.getItemPath(), schema, thisOutcome.viewname, -1);
            }
            catch (PersistencyException e) {
                throw new ObjectCannotBeUpdated("Could not check data for view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
            }
            catch (InvalidDataException e) {
                throw new ObjectCannotBeUpdated("Could not check previous event for view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
            }
            Event newEvent = hist.addEvent(agentPath, null, "Admin", "Import", "Import", "Import", schema, Bootstrap.getPredefSM(), 0, thisOutcome.viewname);
            newOutcome.setID(newEvent.getID());
            impView.setEventId(newEvent.getID());
            try {
                Gateway.getStorage().put(this.getItemPath(), newOutcome, null);
                Gateway.getStorage().put(this.getItemPath(), impView, null);
            }
            catch (PersistencyException e) {
                throw new ObjectCannotBeUpdated("Could not store data for view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
            }
        }
        if (!domPath.exists()) {
            domPath.setItemPath(this.getItemPath());
            Gateway.getLookupManager().add(domPath);
        }
        return domPath;
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public Integer getWorkflowVer() {
        return this.workflowVer;
    }

    public void setWorkflowVer(Integer workflowVer) {
        this.workflowVer = workflowVer;
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public ArrayList<ImportAggregation> getAggregationList() {
        return this.aggregationList;
    }

    public void setAggregationList(ArrayList<ImportAggregation> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public ArrayList<ImportDependency> getDependencyList() {
        return this.dependencyList;
    }

    public void setDependencyList(ArrayList<ImportDependency> dependencyList) {
        this.dependencyList = dependencyList;
    }

    public ArrayList<ImportOutcome> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(ArrayList<ImportOutcome> outcomes) {
        this.outcomes = outcomes;
    }
}

