/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Agent;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

public class AgentProxy
extends ItemProxy {
    AgentPath mAgentPath;
    String mAgentName;
    Authenticator auth;

    protected AgentProxy(Object ior, AgentPath agentPath) throws ObjectNotFoundException {
        super(ior, agentPath);
        this.mAgentPath = agentPath;
    }

    @Override
    public void finalize() throws Throwable {
        if (this.auth != null) {
            this.auth.disconnect();
        }
        super.finalize();
    }

    public Authenticator getAuthObj() {
        return this.auth;
    }

    public void setAuthObj(Authenticator auth) {
        this.auth = auth;
    }

    @Override
    public Agent narrow() throws ObjectNotFoundException {
        try {
            return AgentHelper.narrow(this.mIOR);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new ObjectNotFoundException("CORBA Object was not an Agent, or the server is down.");
        }
    }

    public String execute(Job job) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ScriptErrorException, InvalidCollectionModification {
        String error;
        ItemProxy item = Gateway.getProxyManager().getProxy(job.getItemPath());
        Date startTime = new Date();
        Logger.msg(3, "AgentProxy - executing " + job.getStepPath() + " for " + this.mAgentPath.getAgentName());
        if (job.hasScript()) {
            Logger.msg(3, "AgentProxy - executing script");
            try {
                if (job.hasOutcome() || job.isOutcomeSet()) {
                    Logger.msg(5, "AgentProxy - validating outcome before script execution");
                    error = job.getOutcome().validate();
                    if (error.length() > 0) {
                        Logger.error("Outcome not valid: \n " + error);
                        throw new InvalidDataException(error);
                    }
                }
                ErrorInfo scriptErrors = (ErrorInfo)this.callScript(item, job);
                String errorString = scriptErrors.toString();
                if (scriptErrors.getFatal()) {
                    Logger.msg(3, "AgentProxy - fatal script error");
                    throw new ScriptErrorException(scriptErrors);
                }
                if (errorString.length() > 0) {
                    Logger.warning("Script errors: " + errorString);
                }
            }
            catch (ScriptingEngineException ex) {
                Logger.error(ex);
                throw new InvalidDataException(ex.getMessage());
            }
        }
        if (job.isOutcomeSet()) {
            Logger.msg(3, "AgentProxy - validating outcome");
            error = job.getOutcome().validate();
            if (error.length() > 0) {
                throw new InvalidDataException(error);
            }
        }
        job.setAgentPath(this.mAgentPath);
        Logger.msg(3, "AgentProxy - submitting job to item proxy");
        String result = item.requestAction(job);
        if (Logger.doLog(3)) {
            Date timeNow = new Date();
            long secsNow = (timeNow.getTime() - startTime.getTime()) / 1000L;
            Logger.msg(3, "Execution took " + secsNow + " seconds");
        }
        return result;
    }

    private java.lang.Object callScript(ItemProxy item, Job job) throws ScriptingEngineException, InvalidDataException, ObjectNotFoundException {
        Script script = job.getScript();
        script.setActExecEnvironment(item, this, job);
        return script.execute();
    }

    public String execute(ItemProxy item, String predefStep, C2KLocalObject obj) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        String param;
        try {
            param = this.marshall(obj);
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new InvalidDataException("Error on marshall");
        }
        return this.execute(item, predefStep, param);
    }

    public String execute(ItemProxy item, String predefStep, String[] params) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        String schemaName = PredefinedStep.getPredefStepSchemaName(predefStep);
        String param = schemaName.equals("PredefinedStepOutcome") ? PredefinedStep.bundleData(params) : params[0];
        try {
            return item.getItem().requestAction(this.mAgentPath.getSystemKey(), "workflow/predefined/" + predefStep, 0, param);
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw ex;
        }
    }

    public String execute(ItemProxy item, String predefStep, String param) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.execute(item, predefStep, new String[]{param});
    }

    public String marshall(java.lang.Object obj) throws Exception {
        return Gateway.getMarshaller().marshall(obj);
    }

    public java.lang.Object unmarshall(String obj) throws Exception {
        return Gateway.getMarshaller().unmarshall(obj);
    }

    public ItemProxy searchItem(String name) throws ObjectNotFoundException {
        return this.searchItem(new DomainPath(""), name);
    }

    public ItemProxy searchItem(Path root, String name) throws ObjectNotFoundException {
        Iterator<Path> results = Gateway.getLookup().search(root, name);
        Path returnPath = null;
        if (!results.hasNext()) {
            throw new ObjectNotFoundException(name);
        }
        while (results.hasNext()) {
            Path nextMatch = results.next();
            if (returnPath != null && nextMatch.getUUID() != null && !returnPath.getUUID().equals(nextMatch.getUUID())) {
                throw new ObjectNotFoundException("Too many items with that name");
            }
            returnPath = nextMatch;
        }
        return Gateway.getProxyManager().getProxy(returnPath);
    }

    public List<ItemProxy> searchItems(Path start, PropertyDescriptionList props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    public List<ItemProxy> searchItems(Path start, Property[] props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    private List<ItemProxy> createItemProxyList(Iterator<Path> results) {
        ArrayList<ItemProxy> returnList = new ArrayList<ItemProxy>();
        while (results.hasNext()) {
            Path nextMatch = results.next();
            try {
                returnList.add(Gateway.getProxyManager().getProxy(nextMatch));
            }
            catch (ObjectNotFoundException e) {
                Logger.error("Path '" + nextMatch + "' did not resolve to an Item");
            }
        }
        return returnList;
    }

    public ItemProxy getItem(String itemPath) throws ObjectNotFoundException {
        return this.getItem(new DomainPath(itemPath));
    }

    @Override
    public AgentPath getPath() {
        return this.mAgentPath;
    }

    public ItemProxy getItem(Path itemPath) throws ObjectNotFoundException {
        return Gateway.getProxyManager().getProxy(itemPath);
    }

    public ItemProxy getItemByUUID(String uuid) throws ObjectNotFoundException, InvalidItemPathException {
        return Gateway.getProxyManager().getProxy(new ItemPath(uuid));
    }
}

