/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.cristalise.kernel.entity.proxy.ProxyClientConnection;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.server.SimpleTCPIPServer;

public class ProxyServer
implements Runnable {
    ArrayList<ProxyClientConnection> proxyClients;
    SimpleTCPIPServer proxyListener = null;
    String serverName = null;
    boolean keepRunning = true;
    LinkedBlockingQueue<ProxyMessage> messageQueue;

    public ProxyServer(String serverName) {
        Logger.msg(5, "ProxyManager::initServer - Starting.....");
        int port = Gateway.getProperties().getInt("ItemServer.Proxy.port", 0);
        this.serverName = serverName;
        this.proxyClients = new ArrayList();
        this.messageQueue = new LinkedBlockingQueue();
        if (port == 0) {
            Logger.error("ItemServer.Proxy.port not defined in connect file. Remote proxies will not be informed of changes.");
            return;
        }
        try {
            Logger.msg(5, "ProxyManager::initServer - Initialising proxy informer on port " + port);
            this.proxyListener = new SimpleTCPIPServer(port, ProxyClientConnection.class, 200);
            this.proxyListener.startListening();
        }
        catch (Exception ex) {
            Logger.error("Error setting up Proxy Server. Remote proxies will not be informed of changes.");
            Logger.error(ex);
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Proxy Server");
        while (this.keepRunning) {
            Object object;
            ProxyMessage message = this.messageQueue.poll();
            if (message != null) {
                object = this.proxyClients;
                synchronized (object) {
                    for (ProxyClientConnection client : this.proxyClients) {
                        client.sendMessage(message);
                    }
                    continue;
                }
            }
            try {
                object = this;
                synchronized (object) {
                    if (this.messageQueue.isEmpty()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProxyEvent(ProxyMessage message) {
        try {
            ProxyServer proxyServer = this;
            synchronized (proxyServer) {
                this.messageQueue.put(message);
                this.notify();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConnections(int logLevel) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            Logger.msg(logLevel, "Currently connected proxy clients:");
            for (ProxyClientConnection client : this.proxyClients) {
                Logger.msg(logLevel, "   " + client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownServer() {
        Logger.msg(1, "ProxyManager: Closing Server.");
        this.proxyListener.stopListening();
        ProxyServer proxyServer = this;
        synchronized (proxyServer) {
            this.keepRunning = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyClient(ProxyClientConnection client) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            this.proxyClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterProxyClient(ProxyClientConnection client) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            this.proxyClients.remove(client);
        }
    }
}

