/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class TransferItem {
    private ArrayList<String> domainPaths;
    protected ItemPath itemPath;
    static AgentPath importAgentId;

    public TransferItem() throws Exception {
        try {
            importAgentId = Gateway.getLookup().getAgentPath("system");
        }
        catch (ObjectNotFoundException e) {
            Logger.error("TransferItem - System user not found!");
            throw e;
        }
    }

    public TransferItem(ItemPath itemPath) throws Exception {
        this.itemPath = itemPath;
        this.domainPaths = new ArrayList();
        Iterator<Path> paths = Gateway.getLookup().searchAliases(itemPath);
        while (paths.hasNext()) {
            DomainPath thisPath = (DomainPath)paths.next();
            this.domainPaths.add(thisPath.toString());
        }
    }

    public ArrayList<String> getDomainPaths() {
        return this.domainPaths;
    }

    public void setDomainPaths(ArrayList<String> domainPaths) {
        this.domainPaths = domainPaths;
    }

    public void setUUID(String uuid) throws InvalidItemPathException {
        this.itemPath = new ItemPath(uuid);
    }

    public String getUUID() {
        return this.itemPath.getUUID().toString();
    }

    public void exportItem(File dir, String path) throws Exception {
        Logger.msg("Path " + path + " in " + this.itemPath);
        String[] contents = Gateway.getStorage().getClusterContents(this.itemPath, path);
        if (contents.length > 0) {
            FileStringUtility.createNewDir(dir.getCanonicalPath());
            for (String content : contents) {
                this.exportItem(new File(dir, content), path + "/" + content);
            }
        } else {
            try {
                C2KLocalObject obj = Gateway.getStorage().get(this.itemPath, path, null);
                Logger.msg("Dumping object " + path + " in " + this.itemPath);
                File dumpPath = new File(dir.getCanonicalPath() + ".xml");
                FileStringUtility.string2File(dumpPath, Gateway.getMarshaller().marshall(obj));
                return;
            }
            catch (ObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    public void importItem(File dir) throws Exception {
        try {
            Property name = (Property)Gateway.getStorage().get(this.itemPath, "Property/Name", null);
            throw new Exception("Item " + this.itemPath + " already in use as " + name.getValue());
        }
        catch (Exception ex) {
            ArrayList<String> objectFiles = FileStringUtility.listDir(dir.getCanonicalPath(), false, true);
            ArrayList<C2KLocalObject> objects = new ArrayList<C2KLocalObject>();
            for (String element : objectFiles) {
                String xmlFile = FileStringUtility.file2String(element);
                String choppedPath = element.substring(dir.getCanonicalPath().length() + 1, element.length() - 4);
                Logger.msg(choppedPath);
                C2KLocalObject newObj = choppedPath.startsWith("Outcome") ? new Outcome(choppedPath, xmlFile) : (C2KLocalObject)Gateway.getMarshaller().unmarshall(xmlFile);
                objects.add(newObj);
            }
            TraceableEntity newItem = Gateway.getCorbaServer().createItem(this.itemPath);
            Gateway.getLookupManager().add(this.itemPath);
            PropertyArrayList props = new PropertyArrayList();
            CollectionArrayList colls = new CollectionArrayList();
            GraphableVertex wf = null;
            for (C2KLocalObject obj : objects) {
                if (obj instanceof Property) {
                    props.list.add((Property)obj);
                    continue;
                }
                if (obj instanceof Collection) {
                    colls.list.add((Collection)obj);
                    continue;
                }
                if (!(obj instanceof Workflow)) continue;
                wf = (Workflow)obj;
            }
            if (wf == null) {
                throw new Exception("No workflow found in import for " + this.itemPath);
            }
            newItem.initialise(importAgentId.getSystemKey(), Gateway.getMarshaller().marshall(props), Gateway.getMarshaller().marshall(wf.search("workflow/domain")), Gateway.getMarshaller().marshall(colls));
            this.importByType("AuditTrail", objects);
            this.importByType("Outcome", objects);
            this.importByType("ViewPoint", objects);
            Gateway.getStorage().commit(this);
            for (String element : this.domainPaths) {
                DomainPath newPath = new DomainPath(element, this.itemPath);
                Gateway.getLookupManager().add(newPath);
            }
            return;
        }
    }

    private void importByType(String type, ArrayList<C2KLocalObject> objects) throws Exception {
        for (C2KLocalObject element : objects) {
            if (!element.getClusterType().equals(type)) continue;
            Gateway.getStorage().put(this.itemPath, element, this);
        }
    }
}

