/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.events;

import java.util.Calendar;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.Logger;

public class Event
implements C2KLocalObject {
    ItemPath mItemPath;
    AgentPath mAgentPath;
    AgentPath mDelegatePath;
    int mOriginState;
    int mTransition;
    int mTargetState;
    Integer mID;
    Integer mSchemaVersion;
    Integer mStateMachineVersion;
    String mName;
    String mStepName;
    String mStepPath;
    String mStepType;
    String mSchemaName;
    String mStateMachineName;
    String mViewName;
    String mAgentRole;
    GTimeStamp mTimeStamp;

    public Event(ItemPath itemPath, AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId) {
        Transition transition = stateMachine.getTransition(transitionId);
        Logger.msg(7, "History.addEvent() - creating new event for " + transition.getName() + " on " + stepName + " in " + this.mItemPath);
        this.setItemPath(itemPath);
        this.setAgentPath(agentPath);
        this.setDelegatePath(delegatePath);
        this.setAgentRole(agentRole);
        this.setStepName(stepName);
        this.setStepPath(stepPath);
        this.setStepType(stepType);
        this.setTransition(transitionId);
        this.setOriginState(transition.getOriginStateId());
        this.setTargetState(transition.getTargetStateId());
        this.setStateMachineName(stateMachine.getItemID());
        this.setStateMachineVersion(stateMachine.getVersion());
        this.setTimeStamp(Event.getGMT());
    }

    public Event() {
    }

    public int getOriginState() {
        return this.mOriginState;
    }

    public void setOriginState(int originState) {
        this.mOriginState = originState;
    }

    public int getTargetState() {
        return this.mTargetState;
    }

    public void setTargetState(int targetState) {
        this.mTargetState = targetState;
    }

    public Integer getStateMachineVersion() {
        return this.mStateMachineVersion;
    }

    public void setStateMachineVersion(Integer stateMachineVersion) {
        this.mStateMachineVersion = stateMachineVersion;
    }

    public String getStateMachineName() {
        return this.mStateMachineName;
    }

    public void setStateMachineName(String stateMachineName) {
        this.mStateMachineName = stateMachineName;
    }

    public void setID(Integer id) {
        this.mID = id;
        this.mName = id == null ? null : String.valueOf(id);
    }

    public void setItemPath(ItemPath itemPath) {
        this.mItemPath = itemPath;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public void setAgentUUID(String uuid) throws InvalidItemPathException {
        if (uuid == null || uuid.length() == 0) {
            this.mAgentPath = null;
        } else if (uuid.contains(":")) {
            String[] agentStr = uuid.split(":");
            if (agentStr.length != 2) {
                throw new InvalidItemPathException();
            }
            this.setAgentPath(AgentPath.fromUUIDString(agentStr[0]));
            this.setDelegatePath(AgentPath.fromUUIDString(agentStr[1]));
        } else {
            this.setAgentPath(AgentPath.fromUUIDString(uuid));
        }
    }

    public String getAgentUUID() {
        if (this.mAgentPath != null) {
            if (this.mDelegatePath != null) {
                return this.getAgentPath().getUUID().toString() + ":" + this.getDelegatePath().getUUID().toString();
            }
            return this.getAgentPath().getUUID().toString();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
        try {
            this.mID = Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            this.mID = null;
        }
    }

    public void setStepName(String name) {
        this.mStepName = name;
    }

    public void setStepPath(String path) {
        this.mStepPath = path;
    }

    public void setStepType(String type) {
        this.mStepType = type;
    }

    public void setViewName(String viewName) {
        this.mViewName = viewName;
    }

    public void setAgentPath(AgentPath agentPath) {
        this.mAgentPath = agentPath;
    }

    public void setDelegatePath(AgentPath delegatorPath) {
        this.mDelegatePath = delegatorPath;
    }

    public void setAgentRole(String agentRole) {
        this.mAgentRole = agentRole;
    }

    public void setTimeStamp(GTimeStamp inTimeStamp) {
        this.mTimeStamp = inTimeStamp;
    }

    public Integer getID() {
        return this.mID;
    }

    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String getStepName() {
        return this.mStepName;
    }

    public String getStepPath() {
        return this.mStepPath;
    }

    public String getStepType() {
        return this.mStepType;
    }

    public String getViewName() {
        return this.mViewName;
    }

    public AgentPath getAgentPath() {
        return this.mAgentPath;
    }

    public AgentPath getDelegatePath() {
        return this.mDelegatePath;
    }

    public String getAgentRole() {
        return this.mAgentRole;
    }

    public GTimeStamp getTimeStamp() {
        return this.mTimeStamp;
    }

    public String getTimeString() {
        return Event.timeToString(this.mTimeStamp);
    }

    public static String timeToString(GTimeStamp timeStamp) {
        StringBuffer time = new StringBuffer().append(timeStamp.mYear).append("-");
        if (timeStamp.mMonth < 10) {
            time.append("0");
        }
        time.append(timeStamp.mMonth).append("-");
        if (timeStamp.mDay < 10) {
            time.append("0");
        }
        time.append(timeStamp.mDay).append(" ");
        if (timeStamp.mHour < 10) {
            time.append("0");
        }
        time.append(timeStamp.mHour).append(":");
        if (timeStamp.mMinute < 10) {
            time.append("0");
        }
        time.append(timeStamp.mMinute).append(":");
        if (timeStamp.mSecond < 10) {
            time.append("0");
        }
        time.append(timeStamp.mSecond);
        return time.toString();
    }

    public void setTimeString(String time) throws InvalidDataException {
        if (time.length() == 19) {
            this.mTimeStamp = new GTimeStamp(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(5, 7)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(11, 13)), Integer.parseInt(time.substring(14, 16)), Integer.parseInt(time.substring(17, 19)), Calendar.getInstance().get(15));
        } else if (time.length() == 14) {
            this.mTimeStamp = new GTimeStamp(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(4, 6)), Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(10, 12)), Integer.parseInt(time.substring(12, 14)), Calendar.getInstance().get(15));
        } else {
            throw new InvalidDataException("Unknown time format: " + time);
        }
    }

    public static GTimeStamp getGMT() {
        Calendar now = Calendar.getInstance();
        return new GTimeStamp(now.get(1), now.get(2) + 1, now.get(5), now.get(11), now.get(12), now.get(13), now.get(15));
    }

    @Override
    public String getClusterType() {
        return "AuditTrail";
    }

    public int getTransition() {
        return this.mTransition;
    }

    public void setTransition(int i) {
        this.mTransition = i;
    }

    public Integer getSchemaVersion() {
        return this.mSchemaVersion;
    }

    public void setSchemaVersion(Integer schemaVersion) {
        this.mSchemaVersion = schemaVersion;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public void setSchemaName(String schemaName) {
        this.mSchemaName = schemaName;
    }

    public void addOutcomeDetails(Schema schema, String viewName) {
        this.setSchemaName(schema.getItemID());
        this.setSchemaVersion(schema.getVersion());
        if (viewName == null || viewName.equals("")) {
            this.setViewName("last");
        } else {
            this.setViewName(viewName);
        }
    }
}

