/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.events;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.RemoteMap;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.Logger;

public class History
extends RemoteMap<Event> {
    int lastID = -1;

    public History(ItemPath itemPath, Object locker) {
        super(itemPath, "AuditTrail", locker);
    }

    public Event getEvent(int id) {
        return (Event)this.get(String.valueOf(id));
    }

    @Override
    public Event remove(Object key) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event storeNewEvent(Event newEvent) {
        History history = this;
        synchronized (history) {
            int newEventID = this.getLastId() + 1;
            newEvent.setID(newEventID);
            this.put(newEvent.getName(), newEvent);
            this.lastID = newEventID;
            return newEvent;
        }
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId) {
        return this.storeNewEvent(new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId));
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName) {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    @Deprecated
    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, String stateMachineName, Integer stateMachineVersion, Transition transition) {
        return this.addEvent(agentPath, agentRole, stepName, stepPath, stepType, null, null, stateMachineName, stateMachineVersion, transition, null);
    }

    @Deprecated
    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, String schemaName, Integer schemaVersion, String stateMachineName, Integer stateMachineVersion, Transition transition, String viewName) {
        Logger.msg(7, "History.addEvent() - creating new event for " + transition.getName() + " on " + stepName + " in " + this.mItemPath);
        Event newEvent = new Event();
        newEvent.setItemPath(this.mItemPath);
        newEvent.setAgentPath(agentPath);
        newEvent.setAgentRole(agentRole);
        newEvent.setStepName(stepName);
        newEvent.setStepPath(stepPath);
        newEvent.setStepType(stepType);
        if (schemaName != null && !schemaName.equals("")) {
            newEvent.setSchemaName(schemaName);
            newEvent.setSchemaVersion(schemaVersion);
            if (viewName == null || viewName.equals("")) {
                newEvent.setViewName("last");
            } else {
                newEvent.setViewName(viewName);
            }
        }
        newEvent.setOriginState(transition.getOriginStateId());
        newEvent.setTargetState(transition.getTargetStateId());
        newEvent.setTransition(transition.getId());
        newEvent.setStateMachineName(stateMachineName);
        newEvent.setStateMachineVersion(stateMachineVersion);
        newEvent.setTimeStamp(Event.getGMT());
        return this.storeNewEvent(newEvent);
    }

    @Deprecated
    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, String stateMachineName, Integer stateMachineVersion, Transition transition, String timeString) throws InvalidDataException {
        return this.addEvent(agentPath, agentRole, stepName, stepPath, stepType, null, null, stateMachineName, stateMachineVersion, transition, null, timeString);
    }

    @Deprecated
    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, String schemaName, Integer schemaVersion, String stateMachineName, Integer stateMachineVersion, Transition transition, String viewName, String timeString) throws InvalidDataException {
        Logger.msg(7, "History.addEvent() - creating new event for " + transition.getName() + " on " + stepName + " in " + this.mItemPath);
        Event newEvent = new Event();
        newEvent.setItemPath(this.mItemPath);
        newEvent.setAgentPath(agentPath);
        newEvent.setAgentRole(agentRole);
        newEvent.setStepName(stepName);
        newEvent.setStepPath(stepPath);
        newEvent.setStepType(stepType);
        if (schemaName != null && !schemaName.equals("")) {
            newEvent.setSchemaName(schemaName);
            newEvent.setSchemaVersion(schemaVersion);
            if (viewName == null || viewName.equals("")) {
                newEvent.setViewName("last");
            } else {
                newEvent.setViewName(viewName);
            }
        }
        newEvent.setOriginState(transition.getOriginStateId());
        newEvent.setTargetState(transition.getTargetStateId());
        newEvent.setTransition(transition.getId());
        newEvent.setStateMachineName(stateMachineName);
        newEvent.setStateMachineVersion(stateMachineVersion);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }
}

