/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;

public abstract class GraphableVertex
extends Vertex {
    public static final String NAME = "Name";
    private CastorHashMap mProperties = new CastorHashMap();
    private boolean mIsLayoutable;
    protected boolean mIsComposite;
    private GraphModel mChildrenGraphModel;
    private GraphableVertex parent;

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    protected Integer deriveVersionNumber(Object val) throws InvalidDataException {
        if (val == null || val.equals("") || val.toString().equals("-1")) {
            return null;
        }
        try {
            return Integer.valueOf(val.toString());
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid version number : " + val.toString());
        }
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public GraphableVertex getParent() {
        return this.parent;
    }

    public void setParent(GraphableVertex parent) {
        if (this.equals(parent)) {
            throw new ExceptionInInitializerError();
        }
        this.parent = parent;
    }

    @Override
    public GraphModel getChildGraphModel() {
        return this.mChildrenGraphModel;
    }

    @Override
    public Object getCreationContext() {
        return this;
    }

    public Vertex[] getOutGraphables() {
        if (this.parent == null) {
            return new Vertex[0];
        }
        return this.parent.mChildrenGraphModel.getOutVertices(this);
    }

    public DirectedEdge[] getOutEdges() {
        if (this.parent == null) {
            return new DirectedEdge[0];
        }
        return this.parent.mChildrenGraphModel.getOutEdges(this);
    }

    public DirectedEdge[] getInEdges() {
        if (this.parent == null) {
            return new DirectedEdge[0];
        }
        DirectedEdge[] edges = this.getParent().mChildrenGraphModel.getInEdges(this);
        if (edges != null) {
            return edges;
        }
        return new DirectedEdge[0];
    }

    public GraphableVertex[] getChildren() {
        return this.getLayoutableChildren();
    }

    public DirectedEdge[] getChildrenEdges() {
        if (this.getIsComposite()) {
            return this.getChildGraphModel().getEdges();
        }
        return null;
    }

    public GraphableVertex[] getLayoutableChildren() {
        if (this.getIsComposite() && this.mChildrenGraphModel != null) {
            Vertex[] vs = this.mChildrenGraphModel.getVertices();
            GraphableVertex[] gvs = new GraphableVertex[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                gvs[i] = (GraphableVertex)vs[i];
            }
            return gvs;
        }
        return null;
    }

    public GraphableVertex search(String ids) {
        if (this.getName().equals(ids)) {
            return this;
        }
        if (String.valueOf(this.getID()).equals(ids)) {
            return this;
        }
        if (this.getIsComposite()) {
            GraphableVertex[] graphables = this.getChildren();
            if (ids.startsWith(String.valueOf(this.getID()))) {
                ids = ids.substring(ids.indexOf("/") + 1);
            } else if (ids.startsWith(this.getName())) {
                ids = ids.substring(this.getName().length() + 1);
            } else if (ids.startsWith(this.getPath())) {
                ids = ids.substring(this.getPath().length() + 1);
            } else {
                return null;
            }
            for (GraphableVertex graphable : graphables) {
                GraphableVertex grap = graphable.search(ids);
                if (grap == null) continue;
                return grap;
            }
        }
        return null;
    }

    public boolean getIsLayoutable() {
        return this.mIsLayoutable;
    }

    public void setIsLayoutable(boolean isLayoutable) {
        this.mIsLayoutable = isLayoutable;
    }

    public boolean getIsComposite() {
        return this.mIsComposite;
    }

    public void setIsComposite(boolean isComposite) {
        this.mIsComposite = isComposite;
    }

    public void addChild(GraphableVertex graphableVertex, GraphPoint g) {
        this.getChildGraphModel().addVertexAndCreateId(graphableVertex, g);
        graphableVertex.setParent(this);
    }

    public GraphModel getChildrenGraphModel() {
        return this.mChildrenGraphModel;
    }

    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        this.mChildrenGraphModel = childrenGraph;
        DirectedEdge[] edges = this.mChildrenGraphModel.getEdges();
        GraphableVertex[] graphables = this.getLayoutableChildren();
        if (graphables != null) {
            for (GraphableVertex graphable : graphables) {
                graphable.setParent(this);
            }
        }
        if (edges != null) {
            for (DirectedEdge edge : edges) {
                ((GraphableEdge)edge).setParent(this);
            }
        }
        childrenGraph.setContainingVertex(this);
    }

    @Override
    public GraphPoint getCentrePoint() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getCentrePoint();
    }

    @Override
    public int[] getInEdgeIds() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getInEdgeIds();
    }

    @Override
    public int[] getOutEdgeIds() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getOutEdgeIds();
    }

    @Override
    public GraphPoint[] getOutlinePoints() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getOutlinePoints();
    }

    public String getPath() {
        if (this.getName() != null && !this.getName().equals("")) {
            return this.getParent().getPath() + "/" + this.getName();
        }
        return this.getParent().getPath() + "/" + this.getID();
    }
}

