/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import java.awt.Polygon;
import java.util.Vector;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;

public class Vertex {
    private int mId = -1;
    private String mName = "";
    private GraphPoint mCentrePoint = new GraphPoint(0, 0);
    private int mHeight = 0;
    private int mWidth = 0;
    private Vector<Integer> mInEdgeIdVector = new Vector();
    private Vector<Integer> mOutEdgeIdVector = new Vector();
    private final Vector<Object> mTags = new Vector();
    private Polygon mOutlinePolygon = new Polygon();
    private GraphPoint[] mOutlinePoints = new GraphPoint[0];
    private GraphModel graphModel;

    public void setID(int id) {
        this.mId = id;
    }

    public int getID() {
        return this.mId;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getName() {
        return this.mName;
    }

    public void setCentrePoint(GraphPoint p) {
        this.mCentrePoint = p;
    }

    public GraphPoint getCentrePoint() {
        return this.mCentrePoint;
    }

    public void setHeight(int h) {
        this.mHeight = h;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setWidth(int w) {
        this.mWidth = w;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setOutlinePoints(GraphPoint[] outline) {
        int topLeftX = outline[0].x;
        int topLeftY = outline[0].y;
        int bottomRightX = 0;
        int bottomRightY = 0;
        int i = 0;
        this.mOutlinePoints = outline;
        this.mOutlinePolygon = new Polygon();
        for (i = 0; i < outline.length; ++i) {
            this.mOutlinePolygon.addPoint(outline[i].x, outline[i].y);
            if (outline[i].x < topLeftX) {
                topLeftX = outline[i].x;
            }
            if (outline[i].y < topLeftY) {
                topLeftY = outline[i].y;
            }
            if (outline[i].x > bottomRightX) {
                bottomRightX = outline[i].x;
            }
            if (outline[i].y <= bottomRightY) continue;
            bottomRightY = outline[i].y;
        }
        this.mHeight = bottomRightY - topLeftY;
        this.mWidth = bottomRightX - topLeftX;
    }

    public GraphPoint[] getOutlinePoints() {
        return this.mOutlinePoints;
    }

    public void moveAbsolute(GraphPoint p) {
        int deltaX = p.x - this.mCentrePoint.x;
        int deltaY = p.y - this.mCentrePoint.y;
        int i = 0;
        for (i = 0; i < this.mOutlinePoints.length; ++i) {
            this.mOutlinePoints[i].x += deltaX;
            this.mOutlinePoints[i].y += deltaY;
        }
        this.mOutlinePolygon.translate(deltaX, deltaY);
        this.mCentrePoint.x = p.x;
        this.mCentrePoint.y = p.y;
    }

    public boolean containsPoint(GraphPoint p) {
        return this.mOutlinePolygon.contains(p.x, p.y);
    }

    public void setInEdgeIds(int[] ids) {
        int i = 0;
        this.mInEdgeIdVector = new Vector(10, 10);
        for (i = 0; i < ids.length; ++i) {
            this.mInEdgeIdVector.add(ids[i]);
        }
    }

    public int[] getInEdgeIds() {
        return Vertex.integerVectorToIntArray(this.mInEdgeIdVector);
    }

    public void setOutEdgeIds(int[] ids) {
        int i = 0;
        this.mOutEdgeIdVector = new Vector(10, 10);
        for (i = 0; i < ids.length; ++i) {
            this.mOutEdgeIdVector.add(ids[i]);
        }
    }

    public int[] getOutEdgeIds() {
        return Vertex.integerVectorToIntArray(this.mOutEdgeIdVector);
    }

    private static int[] integerVectorToIntArray(Vector<Integer> vector) {
        int[] array = new int[vector.size()];
        Integer integer = null;
        int i = 0;
        for (i = 0; i < array.length; ++i) {
            integer = vector.elementAt(i);
            array[i] = integer;
        }
        return array;
    }

    public void addInEdgeId(int id) {
        this.mInEdgeIdVector.add(id);
    }

    public void removeInEdgeId(int id) {
        Integer integer = null;
        int i = 0;
        for (i = 0; i < this.mInEdgeIdVector.size(); ++i) {
            integer = this.mInEdgeIdVector.elementAt(i);
            if (integer != id) continue;
            this.mInEdgeIdVector.removeElementAt(i);
            return;
        }
    }

    public void addOutEdgeId(int id) {
        this.mOutEdgeIdVector.add(id);
    }

    public void removeOutEdgeId(int id) {
        Integer integer = null;
        int i = 0;
        for (i = 0; i < this.mOutEdgeIdVector.size(); ++i) {
            integer = this.mOutEdgeIdVector.elementAt(i);
            if (integer != id) continue;
            this.mOutEdgeIdVector.removeElementAt(i);
            return;
        }
    }

    public void setTag(Object o) {
        this.mTags.add(o);
    }

    public boolean hasTag(Object o) {
        return this.mTags.contains(o);
    }

    public void clearTag(Object o) {
        this.mTags.remove(o);
    }

    public GraphModel getChildGraphModel() {
        return null;
    }

    public Object getCreationContext() {
        return null;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public boolean isJoin() {
        return false;
    }

    public boolean isLoop() {
        return false;
    }
}

