/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ActivityDef
extends WfVertexDef
implements C2KLocalObject,
DescriptionObject {
    public static final String SCHNAME = "SchemaType";
    public static final String SCHVER = "SchemaVersion";
    public static final String SCRNAME = "ScriptName";
    public static final String SCRVER = "ScriptVersion";
    public static final String SMNAME = "StateMachineName";
    public static final String SMVER = "StateMachineVersion";
    public static final String SCHCOL = "schema";
    public static final String SCRCOL = "script";
    public static final String SMCOL = "statemachine";
    private int mId = -1;
    private String mName = "";
    private Integer mVersion = null;
    public boolean changed = false;
    Schema actSchema;
    Script actScript;
    StateMachine actStateMachine;
    ItemPath itemPath;

    public ActivityDef() {
        this.mErrors = new Vector(0, 1);
        this.setProperties(new WfCastorHashMap());
        this.setIsLayoutable(false);
    }

    protected String getDefaultSMName() {
        return "Default";
    }

    @Override
    public void setID(int id) {
        this.mId = id;
        if (this.mName.equals("")) {
            this.setName(String.valueOf(id));
        }
    }

    @Override
    public int getID() {
        return this.mId;
    }

    @Override
    public String getItemID() {
        return this.itemPath.getUUID().toString();
    }

    @Override
    public void setName(String n) {
        this.mName = n;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setVersion(Integer v) {
        this.mVersion = v;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public String getErrors() {
        return super.getErrors();
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public String getClusterType() {
        return null;
    }

    public String getActName() {
        return this.getName();
    }

    public String getDescName() {
        return this.getName();
    }

    public void configureInstanceProp(CastorHashMap props, DescriptionObject desc, String nameProp, String verProp) {
        if (desc != null) {
            props.put(nameProp, desc.getItemID());
            props.put(verProp, desc.getVersion());
        }
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName());
    }

    public WfVertex instantiate(String name) throws ObjectNotFoundException, InvalidDataException {
        Activity act = new Activity();
        this.configureInstance(act);
        act.setName(name);
        if (this.getItemPath() != null) {
            act.setType(this.getItemID());
        }
        return act;
    }

    @Override
    public void configureInstance(WfVertex act) throws InvalidDataException, ObjectNotFoundException {
        super.configureInstance(act);
        this.configureInstanceProp(act.getProperties(), this.getSchema(), SCHNAME, SCHVER);
        this.configureInstanceProp(act.getProperties(), this.getScript(), SCRNAME, SCRVER);
        this.configureInstanceProp(act.getProperties(), this.getStateMachine(), SMNAME, SMVER);
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.itemPath = path;
    }

    public Schema getSchema() throws InvalidDataException, ObjectNotFoundException {
        if (this.actSchema == null) {
            try {
                this.actSchema = (Schema)this.getCollectionResource(SCHCOL)[0];
            }
            catch (ObjectNotFoundException ex) {
                this.actSchema = (Schema)this.getPropertyResource(SCHNAME, SCHVER);
            }
        }
        return this.actSchema;
    }

    public Script getScript() throws InvalidDataException, ObjectNotFoundException {
        if (this.actScript == null) {
            try {
                this.actScript = (Script)this.getCollectionResource(SCRCOL)[0];
            }
            catch (ObjectNotFoundException ex) {
                this.actScript = (Script)this.getPropertyResource(SCRNAME, SCRVER);
            }
        }
        return this.actScript;
    }

    public StateMachine getStateMachine() throws InvalidDataException, ObjectNotFoundException {
        if (this.actStateMachine == null) {
            try {
                this.actStateMachine = (StateMachine)this.getCollectionResource(SMCOL)[0];
            }
            catch (ObjectNotFoundException ex) {
                String smNameProp = (String)this.getProperties().get(SMNAME);
                this.actStateMachine = smNameProp == null || smNameProp.length() > 0 ? LocalObjectLoader.getStateMachine(this.getDefaultSMName(), 0) : (StateMachine)this.getPropertyResource(SMNAME, SMVER);
            }
        }
        return this.actStateMachine;
    }

    protected DescriptionObject[] getCollectionResource(String collName) throws ObjectNotFoundException, InvalidDataException {
        Dependency resColl;
        if (this.itemPath == null) {
            throw new ObjectNotFoundException();
        }
        String verStr = this.mVersion == null || this.mVersion == -1 ? "last" : String.valueOf(this.mVersion);
        try {
            resColl = (Dependency)Gateway.getStorage().get(this.itemPath, "Collection/" + collName + "/" + verStr, null);
        }
        catch (PersistencyException e) {
            throw new InvalidDataException("Error loading description collection " + collName);
        }
        ArrayList<DescriptionObject> retArr = new ArrayList<DescriptionObject>();
        for (DependencyMember resMem : resColl.getMembers().list) {
            String resUUID = resMem.getChildUUID();
            Integer resVer = this.deriveVersionNumber(resMem.getProperties().get("Version"));
            switch (collName) {
                case "schema": {
                    retArr.add(LocalObjectLoader.getSchema(resUUID, resVer));
                    break;
                }
                case "script": {
                    retArr.add(LocalObjectLoader.getScript(resUUID, resVer));
                    break;
                }
                case "statemachine": {
                    retArr.add(LocalObjectLoader.getStateMachine(resUUID, resVer));
                    break;
                }
                case "Activity": {
                    retArr.add(LocalObjectLoader.getActDef(resUUID, resVer));
                    break;
                }
            }
        }
        if (retArr.size() == 0) {
            throw new ObjectNotFoundException();
        }
        return retArr.toArray(new DescriptionObject[retArr.size()]);
    }

    protected DescriptionObject getPropertyResource(String nameProp, String verProp) throws InvalidDataException, ObjectNotFoundException {
        if (Gateway.getLookup() == null) {
            return null;
        }
        String resName = (String)this.getProperties().get(nameProp);
        if (!this.getProperties().isAbstract(nameProp) && resName != null && resName.length() > 0) {
            Integer resVer = this.deriveVersionNumber(this.getProperties().get(verProp));
            if (resVer == null && !this.getProperties().isAbstract(verProp)) {
                throw new InvalidDataException("Invalid version property '" + resVer + "' in " + verProp + " for " + this.getName());
            }
            switch (nameProp) {
                case "SchemaType": {
                    return LocalObjectLoader.getSchema(resName, resVer);
                }
                case "ScriptName": {
                    return LocalObjectLoader.getScript(resName, resVer);
                }
                case "StateMachineName": {
                    return LocalObjectLoader.getStateMachine(resName, resVer);
                }
            }
        }
        return null;
    }

    public void setSchema(Schema actSchema) {
        this.actSchema = actSchema;
    }

    public void setScript(Script actScript) {
        this.actScript = actScript;
    }

    public void setStateMachine(StateMachine actStateMachine) {
        this.actStateMachine = actStateMachine;
    }

    public Dependency makeDescCollection(String colName, DescriptionObject ... descs) throws InvalidDataException {
        Dependency descDep = new Dependency(colName);
        if (this.mVersion != null && this.mVersion > -1) {
            descDep.setVersion(this.mVersion);
        }
        for (DescriptionObject thisDesc : descs) {
            if (thisDesc == null) continue;
            try {
                DependencyMember descMem = descDep.addMember(thisDesc.getItemPath());
                descMem.getProperties().put("Version", thisDesc.getVersion());
            }
            catch (Exception e) {
                Logger.error(e);
                throw new InvalidDataException("Problem creating description collection for " + thisDesc + " in " + this.getName());
            }
        }
        return descDep;
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        retArr.put(this.makeDescCollection("Schema", this.getSchema()));
        retArr.put(this.makeDescCollection("Script", this.getScript()));
        retArr.put(this.makeDescCollection("StateMachine", this.getStateMachine()));
        return retArr;
    }

    @Override
    public void export(Writer imports, File dir) throws InvalidDataException, ObjectNotFoundException, IOException {
        String actXML;
        try {
            actXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Couldn't marshall activity def " + this.getActName());
        }
        FileStringUtility.string2File(new File(new File(dir, "EA"), this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), actXML);
        if (imports != null) {
            imports.write("<Activity name=\"" + this.getActName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\"") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "type=\"EA\" resource=\"boot/EA/" + this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml\">" + (this.getSchema() == null ? "" : "<Schema id=\"" + this.getSchema().getItemID() + "\" version=\"" + this.getSchema().getVersion() + "\"/>") + (this.getScript() == null ? "" : "<Script id=\"" + this.getScript().getItemID() + "\" version=\"" + this.getScript().getVersion() + "\"/>") + (this.getStateMachine() == null ? "" : "<StateMachine id=\"" + this.getStateMachine().getItemID() + "\" version=\"" + this.getStateMachine().getVersion() + "\"/>") + "</Activity>\n");
        }
    }
}

