/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;

public class ActivitySlotDef
extends WfVertexDef {
    private String activityDef;
    private ActivityDef theActivityDef;

    public ActivitySlotDef() {
    }

    public ActivitySlotDef(String name, ActivityDef actDef) {
        this.setName(name);
        this.getProperties().put("Name", name);
        this.setTheActivityDef(actDef);
    }

    public void setActivityDef(String oActivityDef) {
        this.activityDef = oActivityDef;
        this.theActivityDef = null;
    }

    public String getActivityDef() {
        return this.activityDef;
    }

    public ActivityDef getTheActivityDef() throws ObjectNotFoundException, InvalidDataException {
        if (this.theActivityDef == null) {
            try {
                DescriptionObject[] parentActDefs;
                for (DescriptionObject thisActDef : parentActDefs = ((CompositeActivityDef)this.getParent()).getCollectionResource("Activity")) {
                    String childUUID = thisActDef.getItemID();
                    if (!childUUID.equals(this.getActivityDef()) && !thisActDef.getName().equals(this.getActivityDef())) continue;
                    ActivityDef currentActDef = (ActivityDef)thisActDef;
                    Integer requiredVersion = this.deriveVersionNumber(this.getProperties().get("Version"));
                    if (currentActDef.getVersion() != requiredVersion) {
                        this.setTheActivityDef(LocalObjectLoader.getActDef(childUUID, requiredVersion));
                    } else {
                        this.setTheActivityDef(currentActDef);
                    }
                    break;
                }
            }
            catch (ObjectNotFoundException ex) {
                // empty catch block
            }
            if (this.theActivityDef == null) {
                Integer version = this.deriveVersionNumber(this.getProperties().get("Version"));
                if (version == null) {
                    throw new InvalidDataException("No version defined in ActivityDefSlot " + this.getName());
                }
                this.setTheActivityDef(LocalObjectLoader.getActDef(this.getActivityDef(), version));
            }
        }
        return this.theActivityDef;
    }

    public void setTheActivityDef(ActivityDef actDef) {
        this.theActivityDef = actDef;
        this.activityDef = actDef.getItemID();
        this.getProperties().put("Version", actDef.getVersion());
        if (actDef instanceof CompositeActivityDef) {
            this.mIsComposite = true;
        }
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        boolean err = true;
        int nbInEdgres = this.getInEdges().length;
        int nbOutEdges = this.getOutEdges().length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            err = false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            err = false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            err = false;
        }
        if (nbOutEdges == 0 && !((CompositeActivityDef)this.getParent()).hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            err = false;
        }
        Vertex[] allSiblings = this.getParent().getChildGraphModel().getVertices();
        String thisName = (String)this.getProperties().get("Name");
        if (thisName == null || thisName.length() == 0) {
            this.mErrors.add("Slot name is empty");
        } else {
            for (Vertex v : allSiblings) {
                ActivitySlotDef otherSlot;
                String otherName;
                if (!(v instanceof ActivitySlotDef) || v.getID() == this.getID() || (otherName = (String)(otherSlot = (ActivitySlotDef)v).getProperties().get("Name")) == null || !otherName.equals(thisName)) continue;
                this.mErrors.add("Duplicate slot name");
                err = false;
            }
        }
        try {
            KeyValuePair[] props;
            for (KeyValuePair prop : props = this.getTheActivityDef().getProperties().getKeyValuePairs()) {
                if (!prop.isAbstract() || this.getProperties().containsKey(prop.getKey())) continue;
                this.mErrors.add("Abstract property '" + prop.getKey() + "' not defined in slot");
                err = false;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Vertex[] outV = this.getOutGraphables();
        Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
        boolean errInLoop = false;
        for (Vertex element : outV) {
            for (Vertex anteVertice : anteVertices) {
                if (this.loop() || element.getID() != anteVertice.getID()) continue;
                errInLoop = true;
            }
        }
        if (errInLoop) {
            this.mErrors.add("Problem in Loop");
            err = false;
        }
        return err;
    }

    public WfVertexDef[] getNextWfVertices() {
        return (WfVertexDef[])this.getOutGraphables();
    }

    public boolean isLayoutable() {
        return true;
    }

    private void configureInstance(Activity act) {
        KeyValuePair[] k;
        for (KeyValuePair element : k = this.getProperties().getKeyValuePairs()) {
            act.getProperties().put(element.getKey(), element.getValue(), element.isAbstract());
        }
        act.setCentrePoint(this.getCentrePoint());
        act.setOutlinePoints(this.getOutlinePoints());
        act.setInEdgeIds(this.getInEdgeIds());
        act.setOutEdgeIds(this.getOutEdgeIds());
        act.setName(this.getActName());
        act.setID(this.getID());
    }

    public String getActName() {
        return (String)this.getProperties().get("Name");
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        Activity newActivity = (Activity)this.getTheActivityDef().instantiate();
        this.configureInstance(newActivity);
        if (newActivity.getProperties().getAbstract().size() > 0) {
            throw new InvalidDataException("Abstract properties not overridden: " + newActivity.getProperties().getAbstract().toString());
        }
        return newActivity;
    }
}

