/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.AndSplitDef;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.NextDef;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.WfVertexDefOutlineCreator;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class CompositeActivityDef
extends ActivityDef {
    public static final String ACTCOL = "Activity";
    private ArrayList<ActivityDef> refChildActDef = new ArrayList();
    private final TypeNameAndConstructionInfo[] mVertexTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Activity", "Atomic"), new TypeNameAndConstructionInfo("Local Activity", "AtomicLocal"), new TypeNameAndConstructionInfo("Composite", "Composite"), new TypeNameAndConstructionInfo("Sub-workflow", "CompositeLocal"), new TypeNameAndConstructionInfo("AND Split", "And"), new TypeNameAndConstructionInfo("OR Split", "Or"), new TypeNameAndConstructionInfo("XOR Split", "XOr"), new TypeNameAndConstructionInfo("Join", "Join"), new TypeNameAndConstructionInfo("Loop", "Loop")};
    private final TypeNameAndConstructionInfo[] mEdgeTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Next Edge", "Next")};

    public ArrayList<ActivityDef> getRefChildActDef() {
        return this.refChildActDef;
    }

    public void setRefChildActDef(ArrayList<ActivityDef> refChildActDef) {
        this.refChildActDef = refChildActDef;
    }

    public TypeNameAndConstructionInfo[] getVertexTypeNameAndConstructionInfo() {
        return this.mVertexTypeNameAndConstructionInfo;
    }

    public TypeNameAndConstructionInfo[] getEdgeTypeNameAndConstructionInfo() {
        return this.mEdgeTypeNameAndConstructionInfo;
    }

    public CompositeActivityDef() {
        this.getProperties().put("Abortable", false);
        this.getProperties().put("RepeatWhen", "false");
        try {
            this.setChildrenGraphModel(new GraphModel(new WfVertexDefOutlineCreator()));
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.setIsComposite(true);
    }

    @Override
    protected String getDefaultSMName() {
        return "CompositeActivity";
    }

    public NextDef addNextDef(WfVertexDef origin, WfVertexDef terminus) {
        NextDef returnNxt = new NextDef(origin, terminus);
        this.getChildrenGraphModel().addEdgeAndCreateId((DirectedEdge)returnNxt, origin, terminus);
        return returnNxt;
    }

    public ActivitySlotDef addExistingActivityDef(String name, ActivityDef actDef, GraphPoint point) throws InvalidDataException {
        this.changed = true;
        boolean newActDef = true;
        for (ActivityDef existingActDef : this.refChildActDef) {
            if (!existingActDef.getName().equals(actDef.getName())) continue;
            if (existingActDef.getVersion().equals(actDef.getVersion())) {
                actDef = existingActDef;
                newActDef = false;
                break;
            }
            throw new InvalidDataException("Cannot use same activity def with different version in the same composite activity");
        }
        if (newActDef) {
            this.refChildActDef.add(actDef);
        }
        ActivitySlotDef child = new ActivitySlotDef(name, actDef);
        this.addChild(child, point);
        return child;
    }

    public ActivityDef addLocalActivityDef(String name, String type, GraphPoint point) {
        this.changed = true;
        ActivityDef child = type.startsWith("Composite") ? new CompositeActivityDef() : new ActivityDef();
        child.setName(name);
        child.setIsLayoutable(true);
        this.addChild(child, point);
        return child;
    }

    public WfVertexDef newChild(String Name, String Type2, Integer version, GraphPoint location) throws ObjectNotFoundException, InvalidDataException {
        WfVertexDef child;
        this.changed = true;
        if (Type2.equals("Or")) {
            child = new OrSplitDef();
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("XOr")) {
            child = new XOrSplitDef();
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("And")) {
            child = new AndSplitDef();
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("Loop")) {
            child = new LoopDef();
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("Atomic") || Type2.equals("Composite")) {
            ActivityDef act = Type2.equals("Atomic") ? LocalObjectLoader.getElemActDef(Name, version) : LocalObjectLoader.getCompActDef(Name, version);
            child = this.addExistingActivityDef(act.getActName(), act, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("AtomicLocal") || Type2.equals("CompositeLocal")) {
            child = this.addLocalActivityDef(Name, Type2, location);
        } else if (Type2.equals("Join")) {
            child = new JoinDef();
            child.getProperties().put("Type", "Join");
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else if (Type2.equals("Route")) {
            child = new JoinDef();
            child.getProperties().put("Type", "Route");
            this.addChild(child, location);
            Logger.msg(5, Type2 + " " + child.getID() + " added to " + this.getID());
        } else {
            throw new InvalidDataException("Unknown child type: " + Type2);
        }
        return child;
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName());
    }

    @Override
    public WfVertex instantiate(String name) throws ObjectNotFoundException, InvalidDataException {
        CompositeActivity cAct = new CompositeActivity();
        this.configureInstance(cAct);
        if (this.getItemPath() != null) {
            cAct.setType(this.getItemID());
        }
        cAct.setName(name);
        GraphableVertex[] vertexDefs = this.getLayoutableChildren();
        Vertex[] wfVertices = new WfVertex[vertexDefs.length];
        for (int i = 0; i < vertexDefs.length; ++i) {
            WfVertexDef vertDef = (WfVertexDef)vertexDefs[i];
            wfVertices[i] = vertDef.instantiate();
            wfVertices[i].setParent(cAct);
        }
        DirectedEdge[] nexts = new Next[this.getChildrenGraphModel().getEdges().length];
        for (int i = 0; i < this.getChildrenGraphModel().getEdges().length; ++i) {
            NextDef nextDef = (NextDef)this.getChildrenGraphModel().getEdges()[i];
            nexts[i] = nextDef.instantiate();
            ((GraphableEdge)nexts[i]).setParent(cAct);
        }
        cAct.getChildrenGraphModel().setStartVertexId(this.getChildrenGraphModel().getStartVertexId());
        cAct.getChildrenGraphModel().setEdges(nexts);
        cAct.getChildrenGraphModel().setVertices(wfVertices);
        cAct.getChildrenGraphModel().setNextId(this.getChildrenGraphModel().getNextId());
        cAct.getChildrenGraphModel().resetVertexOutlines();
        return cAct;
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = super.makeDescCollections();
        retArr.put(this.makeActDefCollection());
        return retArr;
    }

    public Dependency makeActDefCollection() throws InvalidDataException {
        return this.makeDescCollection(ACTCOL, this.refChildActDef.toArray(new ActivityDef[this.refChildActDef.size()]));
    }

    public ArrayList<ActivityDef> findRefActDefs(GraphModel graph) throws ObjectNotFoundException, InvalidDataException {
        ArrayList<ActivityDef> graphActDefs = new ArrayList<ActivityDef>();
        for (Vertex elem : graph.getVertices()) {
            ActivityDef actDef;
            if (!(elem instanceof ActivitySlotDef) || graphActDefs.contains(actDef = ((ActivitySlotDef)elem).getTheActivityDef())) continue;
            graphActDefs.add(actDef);
        }
        return graphActDefs;
    }

    public boolean hasGoodNumberOfActivity() {
        int endingAct = 0;
        GraphableVertex[] graphableVertices = this.getLayoutableChildren();
        if (graphableVertices != null) {
            for (GraphableVertex graphableVertice : graphableVertices) {
                WfVertexDef vertex = (WfVertexDef)graphableVertice;
                if (this.getChildrenGraphModel().getOutEdges(vertex).length != 0) continue;
                ++endingAct;
            }
        }
        return endingAct <= true;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return this.getName();
        }
        return super.getPath();
    }

    @Override
    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        super.setChildrenGraphModel(childrenGraph);
        childrenGraph.setVertexOutlineCreator(new WfVertexDefOutlineCreator());
        try {
            this.setRefChildActDef(this.findRefActDefs(childrenGraph));
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    @Deprecated
    public String[] getCastorNonLayoutableChildren() {
        return new String[0];
    }

    @Deprecated
    public void setCastorNonLayoutableChildren(String[] dummy) {
    }

    @Override
    public boolean verify() {
        boolean err = super.verify();
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            WfVertexDef wfvChild = (WfVertexDef)vChildren[i];
            if (wfvChild.verify()) continue;
            this.mErrors.add(wfvChild.getName() + ": " + wfvChild.getErrors());
            err = false;
        }
        return err;
    }

    @Override
    public void export(Writer imports, File dir) throws InvalidDataException, ObjectNotFoundException, IOException {
        String compactXML;
        this.setRefChildActDef(this.findRefActDefs(this.getGraphModel()));
        for (int i = 0; i < this.getChildren().length; ++i) {
            GraphableVertex vert = this.getChildren()[i];
            if (vert instanceof AndSplitDef) {
                try {
                    ((AndSplitDef)vert).getRoutingScript().export(imports, dir);
                }
                catch (ObjectNotFoundException ex) {
                    // empty catch block
                }
            }
            if (!(vert instanceof ActivitySlotDef)) continue;
            ActivityDef refAct = ((ActivitySlotDef)vert).getTheActivityDef();
            refAct.export(imports, dir);
        }
        try {
            compactXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Couldn't marshall composite activity def " + this.getActName());
        }
        FileStringUtility.string2File(new File(new File(dir, "CA"), this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), compactXML);
        if (imports != null) {
            imports.write("<Workflow name=\"" + this.getActName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\"") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "type=\"EA\" resource=\"boot/EA/" + this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml\">" + (this.getSchema() == null ? "" : "<Schema name=\"" + this.getSchema().getName() + "\" id=\"" + this.getSchema().getItemID() + "\" version=\"" + this.getSchema().getVersion() + "\"/>") + (this.getScript() == null ? "" : "<Script name=\"" + this.getScript().getName() + "\" id=\"" + this.getScript().getItemID() + "\" version=\"" + this.getScript().getVersion() + "\"/>") + (this.getStateMachine() == null ? "" : "<StateMachine name=\"" + this.getStateMachine().getName() + "\" id=\"" + this.getStateMachine().getItemID() + "\" version=\"" + this.getStateMachine().getVersion() + "\"/>"));
            for (ActivityDef childActDef : this.refChildActDef) {
                imports.write("<Activity name=\"" + childActDef.getActName() + "\" id=\"" + childActDef.getItemID() + "\" version=\"" + childActDef.getVersion() + "\">");
            }
            imports.write("</Workflow>\n");
        }
    }
}

