/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.Next;

public class NextDef
extends GraphableEdge {
    public NextDef() {
    }

    public boolean verify() {
        return true;
    }

    public NextDef(WfVertexDef pre, WfVertexDef nex) {
        this.setParent(pre.getParent());
        if (pre instanceof OrSplitDef || pre instanceof XOrSplitDef) {
            int num = pre.getOutGraphables().length;
            try {
                num = Integer.parseInt((String)pre.getProperties().get("LastNum"));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.getProperties().put("Alias", String.valueOf(num));
            pre.getProperties().put("LastNum", String.valueOf(num + 1));
        }
    }

    @Override
    public boolean containsPoint(GraphPoint p) {
        boolean arrowOnY;
        GraphPoint originPoint = this.getOriginPoint();
        GraphPoint terminusPoint = this.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        if ("Broken +".equals(this.getProperties().get("Type"))) {
            midPoint.x = (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = (originPoint.y + terminusPoint.y) / 2;
        } else if ("Broken -".equals(this.getProperties().get("Type"))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? terminusPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : originPoint.y;
        } else if ("Broken |".equals(this.getProperties().get("Type"))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? originPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : terminusPoint.y;
        } else {
            midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
            midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        }
        int minX = midPoint.x - 10;
        int minY = midPoint.y - 10;
        int maxX = midPoint.x + 10;
        int maxY = midPoint.y + 10;
        return p.x >= minX && p.x <= maxX && p.y >= minY && p.y <= maxY;
    }

    public Next instantiate() {
        Next next = new Next();
        next.setID(this.getID());
        next.setOriginVertexId(this.getOriginVertexId());
        next.setTerminusVertexId(this.getTerminusVertexId());
        next.setProperties(this.getProperties());
        next.setOriginPoint(this.getOriginPoint());
        next.setTerminusPoint(this.getTerminusPoint());
        return next;
    }
}

